"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStreamPutRecord = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
/**
 * Use an Amazon Kinesis Data Streams as a target for AWS EventBridge Scheduler.
 */
class KinesisStreamPutRecord extends target_1.ScheduleTargetBase {
    constructor(stream, props) {
        super(props, stream.streamArn);
        this.stream = stream;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_KinesisStreamPutRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisStreamPutRecord);
            }
            throw error;
        }
        if (!aws_cdk_lib_1.Token.isUnresolved(props.partitionKey) && (props.partitionKey.length < 1 || props.partitionKey.length > 256)) {
            throw new Error(`partitionKey length must be between 1 and 256, got ${props.partitionKey.length}`);
        }
    }
    addTargetActionToRole(role) {
        this.stream.grant(role, 'kinesis:PutRecord', 'kinesis:PutRecords');
        this.stream.encryptionKey?.grant(role, 'kms:GenerateDataKey*');
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            kinesisParameters: {
                partitionKey: this.props.partitionKey,
            },
        };
    }
}
exports.KinesisStreamPutRecord = KinesisStreamPutRecord;
_a = JSII_RTTI_SYMBOL_1;
KinesisStreamPutRecord[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.KinesisStreamPutRecord", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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