"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDataFirehosePutRecord = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
/**
 * Use an Amazon Kinesis Data Firehose as a target for AWS EventBridge Scheduler.
 */
class KinesisDataFirehosePutRecord extends target_1.ScheduleTargetBase {
    constructor(deliveryStream, props = {}) {
        super(props, deliveryStream.deliveryStreamArn);
        this.deliveryStream = deliveryStream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisDataFirehosePutRecord);
            }
            throw error;
        }
    }
    addTargetActionToRole(role) {
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['firehose:PutRecord'],
            resources: [this.deliveryStream.deliveryStreamArn],
        }));
    }
}
exports.KinesisDataFirehosePutRecord = KinesisDataFirehosePutRecord;
_a = JSII_RTTI_SYMBOL_1;
KinesisDataFirehosePutRecord[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.KinesisDataFirehosePutRecord", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1kYXRhLWZpcmVob3NlLXB1dC1yZWNvcmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJraW5lc2lzLWRhdGEtZmlyZWhvc2UtcHV0LXJlY29yZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQSxpREFBNkQ7QUFDN0QscUNBQXVFO0FBRXZFOztHQUVHO0FBQ0gsTUFBYSw0QkFBNkIsU0FBUSwyQkFBa0I7SUFDbEUsWUFDbUIsY0FBK0IsRUFDaEQsUUFBaUMsRUFBRTtRQUVuQyxLQUFLLENBQUMsS0FBSyxFQUFFLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBSDlCLG1CQUFjLEdBQWQsY0FBYyxDQUFpQjs7Ozs7OytDQUZ2Qyw0QkFBNEI7Ozs7S0FNdEM7SUFFUyxxQkFBcUIsQ0FBQyxJQUFXO1FBRXpDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLHlCQUFlLENBQUM7WUFDNUMsT0FBTyxFQUFFLENBQUMsb0JBQW9CLENBQUM7WUFDL0IsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQztTQUNuRCxDQUFDLENBQUMsQ0FBQztLQUNMOztBQWRILG9FQWVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSURlbGl2ZXJ5U3RyZWFtIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWtpbmVzaXNmaXJlaG9zZS1hbHBoYSc7XG5pbXBvcnQgeyBJU2NoZWR1bGVUYXJnZXQgfSBmcm9tICdAYXdzLWNkay9hd3Mtc2NoZWR1bGVyLWFscGhhJztcbmltcG9ydCB7IElSb2xlLCBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IFNjaGVkdWxlVGFyZ2V0QmFzZSwgU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMgfSBmcm9tICcuL3RhcmdldCc7XG5cbi8qKlxuICogVXNlIGFuIEFtYXpvbiBLaW5lc2lzIERhdGEgRmlyZWhvc2UgYXMgYSB0YXJnZXQgZm9yIEFXUyBFdmVudEJyaWRnZSBTY2hlZHVsZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBLaW5lc2lzRGF0YUZpcmVob3NlUHV0UmVjb3JkIGV4dGVuZHMgU2NoZWR1bGVUYXJnZXRCYXNlIGltcGxlbWVudHMgSVNjaGVkdWxlVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBkZWxpdmVyeVN0cmVhbTogSURlbGl2ZXJ5U3RyZWFtLFxuICAgIHByb3BzOiBTY2hlZHVsZVRhcmdldEJhc2VQcm9wcyA9IHt9LFxuICApIHtcbiAgICBzdXBlcihwcm9wcywgZGVsaXZlcnlTdHJlYW0uZGVsaXZlcnlTdHJlYW1Bcm4pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFkZFRhcmdldEFjdGlvblRvUm9sZShyb2xlOiBJUm9sZSk6IHZvaWQge1xuXG4gICAgcm9sZS5hZGRUb1ByaW5jaXBhbFBvbGljeShuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGFjdGlvbnM6IFsnZmlyZWhvc2U6UHV0UmVjb3JkJ10sXG4gICAgICByZXNvdXJjZXM6IFt0aGlzLmRlbGl2ZXJ5U3RyZWFtLmRlbGl2ZXJ5U3RyZWFtQXJuXSxcbiAgICB9KSk7XG4gIH1cbn1cbiJdfQ==