import { IDeliveryStream } from '@aws-cdk/aws-kinesisfirehose-alpha';
import { IScheduleTarget } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an Amazon Kinesis Data Firehose as a target for AWS EventBridge Scheduler.
 */
export declare class KinesisDataFirehosePutRecord extends ScheduleTargetBase implements IScheduleTarget {
    private readonly deliveryStream;
    constructor(deliveryStream: IDeliveryStream, props?: ScheduleTargetBaseProps);
    protected addTargetActionToRole(role: IRole): void;
}
