"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InspectorStartAssessmentRun = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
/**
 * Use an Amazon Inspector as a target for AWS EventBridge Scheduler.
 */
class InspectorStartAssessmentRun extends target_1.ScheduleTargetBase {
    constructor(template, props = {}) {
        super(props, template.attrArn);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InspectorStartAssessmentRun);
            }
            throw error;
        }
    }
    addTargetActionToRole(role) {
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['inspector:StartAssessmentRun'],
            resources: ['*'],
        }));
    }
}
exports.InspectorStartAssessmentRun = InspectorStartAssessmentRun;
_a = JSII_RTTI_SYMBOL_1;
InspectorStartAssessmentRun[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.InspectorStartAssessmentRun", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zcGVjdG9yLXN0YXJ0LWFzc2Vzc21lbnQtcnVuLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW5zcGVjdG9yLXN0YXJ0LWFzc2Vzc21lbnQtcnVuLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBLGlEQUE2RDtBQUU3RCxxQ0FBdUU7QUFFdkU7O0dBRUc7QUFDSCxNQUFhLDJCQUE0QixTQUFRLDJCQUFrQjtJQUNqRSxZQUNFLFFBQStCLEVBQy9CLFFBQWlDLEVBQUU7UUFFbkMsS0FBSyxDQUFDLEtBQUssRUFBRSxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUM7Ozs7OzsrQ0FMdEIsMkJBQTJCOzs7O0tBTXJDO0lBRVMscUJBQXFCLENBQUMsSUFBVztRQUN6QyxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSx5QkFBZSxDQUFDO1lBQzVDLE9BQU8sRUFBRSxDQUFDLDhCQUE4QixDQUFDO1lBQ3pDLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztTQUNqQixDQUFDLENBQUMsQ0FBQztLQUNMOztBQWJILGtFQWNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVNjaGVkdWxlVGFyZ2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNjaGVkdWxlci1hbHBoYSc7XG5pbXBvcnQgeyBJUm9sZSwgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDZm5Bc3Nlc3NtZW50VGVtcGxhdGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaW5zcGVjdG9yJztcbmltcG9ydCB7IFNjaGVkdWxlVGFyZ2V0QmFzZSwgU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMgfSBmcm9tICcuL3RhcmdldCc7XG5cbi8qKlxuICogVXNlIGFuIEFtYXpvbiBJbnNwZWN0b3IgYXMgYSB0YXJnZXQgZm9yIEFXUyBFdmVudEJyaWRnZSBTY2hlZHVsZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBJbnNwZWN0b3JTdGFydEFzc2Vzc21lbnRSdW4gZXh0ZW5kcyBTY2hlZHVsZVRhcmdldEJhc2UgaW1wbGVtZW50cyBJU2NoZWR1bGVUYXJnZXQge1xuICBjb25zdHJ1Y3RvcihcbiAgICB0ZW1wbGF0ZTogQ2ZuQXNzZXNzbWVudFRlbXBsYXRlLFxuICAgIHByb3BzOiBTY2hlZHVsZVRhcmdldEJhc2VQcm9wcyA9IHt9LFxuICApIHtcbiAgICBzdXBlcihwcm9wcywgdGVtcGxhdGUuYXR0ckFybik7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWRkVGFyZ2V0QWN0aW9uVG9Sb2xlKHJvbGU6IElSb2xlKTogdm9pZCB7XG4gICAgcm9sZS5hZGRUb1ByaW5jaXBhbFBvbGljeShuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGFjdGlvbnM6IFsnaW5zcGVjdG9yOlN0YXJ0QXNzZXNzbWVudFJ1biddLFxuICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICB9KSk7XG4gIH1cbn1cbiJdfQ==