"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const target_1 = require("./target");
/**
 * Send an event to an AWS EventBridge by AWS EventBridge Scheduler.
 */
class EventBridgePutEvents extends target_1.ScheduleTargetBase {
    constructor(entry, props = {}) {
        super(props, entry.eventBus.eventBusArn);
        this.entry = entry;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_EventBridgePutEventsEntry(entry);
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventBridgePutEvents);
            }
            throw error;
        }
        if (this.props.input) {
            throw new Error('ScheduleTargetBaseProps.input is not supported for EventBridgePutEvents. Please use entry.detail instead.');
        }
    }
    addTargetActionToRole(role) {
        const eventBus = this.entry.eventBus;
        eventBus.grantPutEventsTo(role);
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            input: this.entry.detail,
            eventBridgeParameters: {
                detailType: this.entry.detailType,
                source: this.entry.source,
            },
        };
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.EventBridgePutEvents", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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