"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineStartPipelineExecution = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
/**
 * Use an AWS CodePipeline pipeline as a target for AWS EventBridge Scheduler.
 */
class CodePipelineStartPipelineExecution extends target_1.ScheduleTargetBase {
    constructor(pipeline, props = {}) {
        super(props, pipeline.pipelineArn);
        this.pipeline = pipeline;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodePipelineStartPipelineExecution);
            }
            throw error;
        }
    }
    addTargetActionToRole(role) {
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['codepipeline:StartPipelineExecution'],
            resources: [this.pipeline.pipelineArn],
        }));
    }
}
exports.CodePipelineStartPipelineExecution = CodePipelineStartPipelineExecution;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineStartPipelineExecution[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.CodePipelineStartPipelineExecution", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZXBpcGVsaW5lLXN0YXJ0LXBpcGVsaW5lLWV4ZWN1dGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvZGVwaXBlbGluZS1zdGFydC1waXBlbGluZS1leGVjdXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBRUEsaURBQTZEO0FBQzdELHFDQUF1RTtBQUV2RTs7R0FFRztBQUNILE1BQWEsa0NBQW1DLFNBQVEsMkJBQWtCO0lBQ3hFLFlBQ21CLFFBQW1CLEVBQ3BDLFFBQWlDLEVBQUU7UUFFbkMsS0FBSyxDQUFDLEtBQUssRUFBRSxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7UUFIbEIsYUFBUSxHQUFSLFFBQVEsQ0FBVzs7Ozs7OytDQUYzQixrQ0FBa0M7Ozs7S0FNNUM7SUFFUyxxQkFBcUIsQ0FBQyxJQUFXO1FBQ3pDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLHlCQUFlLENBQUM7WUFDNUMsT0FBTyxFQUFFLENBQUMscUNBQXFDLENBQUM7WUFDaEQsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUM7U0FDdkMsQ0FBQyxDQUFDLENBQUM7S0FDTDs7QUFiSCxnRkFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElTY2hlZHVsZVRhcmdldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zY2hlZHVsZXItYWxwaGEnO1xuaW1wb3J0IHsgSVBpcGVsaW5lIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNvZGVwaXBlbGluZSc7XG5pbXBvcnQgeyBJUm9sZSwgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBTY2hlZHVsZVRhcmdldEJhc2UsIFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzIH0gZnJvbSAnLi90YXJnZXQnO1xuXG4vKipcbiAqIFVzZSBhbiBBV1MgQ29kZVBpcGVsaW5lIHBpcGVsaW5lIGFzIGEgdGFyZ2V0IGZvciBBV1MgRXZlbnRCcmlkZ2UgU2NoZWR1bGVyLlxuICovXG5leHBvcnQgY2xhc3MgQ29kZVBpcGVsaW5lU3RhcnRQaXBlbGluZUV4ZWN1dGlvbiBleHRlbmRzIFNjaGVkdWxlVGFyZ2V0QmFzZSBpbXBsZW1lbnRzIElTY2hlZHVsZVRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgcGlwZWxpbmU6IElQaXBlbGluZSxcbiAgICBwcm9wczogU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMgPSB7fSxcbiAgKSB7XG4gICAgc3VwZXIocHJvcHMsIHBpcGVsaW5lLnBpcGVsaW5lQXJuKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhZGRUYXJnZXRBY3Rpb25Ub1JvbGUocm9sZTogSVJvbGUpOiB2b2lkIHtcbiAgICByb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydjb2RlcGlwZWxpbmU6U3RhcnRQaXBlbGluZUV4ZWN1dGlvbiddLFxuICAgICAgcmVzb3VyY2VzOiBbdGhpcy5waXBlbGluZS5waXBlbGluZUFybl0sXG4gICAgfSkpO1xuICB9XG59XG4iXX0=