import { IScheduleTarget } from '@aws-cdk/aws-scheduler-alpha';
import { IPipeline } from 'aws-cdk-lib/aws-codepipeline';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an AWS CodePipeline pipeline as a target for AWS EventBridge Scheduler.
 */
export declare class CodePipelineStartPipelineExecution extends ScheduleTargetBase implements IScheduleTarget {
    private readonly pipeline;
    constructor(pipeline: IPipeline, props?: ScheduleTargetBaseProps);
    protected addTargetActionToRole(role: IRole): void;
}
