"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildStartBuild = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
/**
 * Use an AWS CodeBuild as a target for AWS EventBridge Scheduler.
 */
class CodeBuildStartBuild extends target_1.ScheduleTargetBase {
    constructor(project, props = {}) {
        super(props, project.projectArn);
        this.project = project;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeBuildStartBuild);
            }
            throw error;
        }
    }
    addTargetActionToRole(role) {
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['codebuild:StartBuild'],
            resources: [this.project.projectArn],
        }));
    }
}
exports.CodeBuildStartBuild = CodeBuildStartBuild;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildStartBuild[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.CodeBuildStartBuild", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZWJ1aWxkLXN0YXJ0LWJ1aWxkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29kZWJ1aWxkLXN0YXJ0LWJ1aWxkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLGlEQUE2RDtBQUM3RCxxQ0FBdUU7QUFFdkU7O0dBRUc7QUFDSCxNQUFhLG1CQUFvQixTQUFRLDJCQUFrQjtJQUN6RCxZQUNtQixPQUFpQixFQUNsQyxRQUFpQyxFQUFFO1FBRW5DLEtBQUssQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBSGhCLFlBQU8sR0FBUCxPQUFPLENBQVU7Ozs7OzsrQ0FGekIsbUJBQW1COzs7O0tBTTdCO0lBRVMscUJBQXFCLENBQUMsSUFBVztRQUN6QyxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSx5QkFBZSxDQUFDO1lBQzVDLE9BQU8sRUFBRSxDQUFDLHNCQUFzQixDQUFDO1lBQ2pDLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDO1NBQ3JDLENBQUMsQ0FBQyxDQUFDO0tBQ0w7O0FBYkgsa0RBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJU2NoZWR1bGVUYXJnZXQgfSBmcm9tICdAYXdzLWNkay9hd3Mtc2NoZWR1bGVyLWFscGhhJztcbmltcG9ydCB7IElQcm9qZWN0IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNvZGVidWlsZCc7XG5pbXBvcnQgeyBJUm9sZSwgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBTY2hlZHVsZVRhcmdldEJhc2UsIFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzIH0gZnJvbSAnLi90YXJnZXQnO1xuXG4vKipcbiAqIFVzZSBhbiBBV1MgQ29kZUJ1aWxkIGFzIGEgdGFyZ2V0IGZvciBBV1MgRXZlbnRCcmlkZ2UgU2NoZWR1bGVyLlxuICovXG5leHBvcnQgY2xhc3MgQ29kZUJ1aWxkU3RhcnRCdWlsZCBleHRlbmRzIFNjaGVkdWxlVGFyZ2V0QmFzZSBpbXBsZW1lbnRzIElTY2hlZHVsZVRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgcHJvamVjdDogSVByb2plY3QsXG4gICAgcHJvcHM6IFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzID0ge30sXG4gICkge1xuICAgIHN1cGVyKHByb3BzLCBwcm9qZWN0LnByb2plY3RBcm4pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFkZFRhcmdldEFjdGlvblRvUm9sZShyb2xlOiBJUm9sZSk6IHZvaWQge1xuICAgIHJvbGUuYWRkVG9QcmluY2lwYWxQb2xpY3kobmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ2NvZGVidWlsZDpTdGFydEJ1aWxkJ10sXG4gICAgICByZXNvdXJjZXM6IFt0aGlzLnByb2plY3QucHJvamVjdEFybl0sXG4gICAgfSkpO1xuICB9XG59XG4iXX0=