#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.in_interfaces.reference import Reference

from pycatia.mec_mod_interfaces.shape import Shape
from pycatia.sketcher_interfaces.sketch import Sketch


class SketchBasedShape(Shape):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     MecModInterfaces.Shape
                |                         SketchBasedShape
                | 
                | Represents the shapes based on sketched 2D geometry.
                | It is the base object for prisms, holes, revolutions, stiffeners, and
                | sweeps.
                | 
                | See also:
                |     Prism, Hole, Revolution, Stiffener, Sweep
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sketch_based_shape = com_object

    @property
    def sketch(self) -> Sketch:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property Sketch() As Sketch (Read Only)
                | 
                |     Returns the sketch the shape is based on.
                | 
                |     Example:
                |         The following example returns the sketch a pad named firstPad is based
                |         on:
                | 
                |          Set sketchPad = firstPad.Sketch

        :return: Sketch
        :rtype: Sketch
        """

        return Sketch(self.sketch_based_shape.Sketch)

    def set_profile_element(self, i_profile_element: Reference) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetProfileElement(Reference iProfileElement)
                | 
                |     Returns or sets a profile element.

        :param Reference i_profile_element:
        :return: None
        :rtype: None
        """
        return self.sketch_based_shape.SetProfileElement(i_profile_element.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_profile_element'
        # # vba_code = """
        # # Public Function set_profile_element(sketch_based_shape)
        # #     Dim iProfileElement (2)
        # #     sketch_based_shape.SetProfileElement iProfileElement
        # #     set_profile_element = iProfileElement
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SketchBasedShape(name="{self.name}")'
