#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-07-06 14:02:20.222384

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.in_interfaces.reference import Reference
from pycatia.mec_mod_interfaces.hybrid_shape import HybridShape


class HybridShapeSweep(HybridShape):

    """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     MecModInterfaces.HybridShape
                |                         HybridShapeSweep
                | 
                | Represents the hybrid shape Sweep feature object.
                | Role: Declare hybrid shape Sweep root feature object. All interfaces for
                | different type of sweep derives HybridShapeSweep.
                | 
                | Use the CATIAHybridShapeFactory to create a HybridShapeSweep
                | objects.
                | 
                | See also:
                |     HybridShapeFactory
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.hybrid_shape_sweep = com_object

    @property
    def c0_vertices_mode(self) -> bool:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property C0VerticesMode() As boolean
                | 
                |     Returns or sets the management mode of C0 vertices as twisted
                |     areas.
                |     TRUE or FALSE.

        :return: bool
        :rtype: bool
        """

        return self.hybrid_shape_sweep.C0VerticesMode

    @c0_vertices_mode.setter
    def c0_vertices_mode(self, value: bool):
        """
        :param bool value:
        """

        self.hybrid_shape_sweep.C0VerticesMode = value

    @property
    def fill_twisted_areas(self) -> int:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property FillTwistedAreas() As long
                | 
                |     Returns or sets the fill twisted areas mode.

        :return: int
        :rtype: int
        """

        return self.hybrid_shape_sweep.FillTwistedAreas

    @fill_twisted_areas.setter
    def fill_twisted_areas(self, value: int):
        """
        :param int value:
        """

        self.hybrid_shape_sweep.FillTwistedAreas = value

    @property
    def setback_value(self) -> float:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property SetbackValue() As double
                | 
                |     Returns or sets the setback value.

        :return: float
        :rtype: float
        """

        return self.hybrid_shape_sweep.SetbackValue

    @setback_value.setter
    def setback_value(self, value: float):
        """
        :param float value:
        """

        self.hybrid_shape_sweep.SetbackValue = value

    def add_cut_points(self, i_element1: Reference, i_element2: Reference) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AddCutPoints(Reference iElement1,
                | Reference iElement2)
                | 
                |     Sets two cut points on the master guide. These points define a zone to be
                |     kept on the final swept surface.
                | 
                |     Parameters:
                | 
                |         iElement1
                |             First / start cut point. 
                |         iElement2
                |             Second / end cut point.

        :param Reference i_element1:
        :param Reference i_element2:
        :return: None
        :rtype: None
        """
        return self.hybrid_shape_sweep.AddCutPoints(i_element1.com_object, i_element2.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_cut_points'
        # # vba_code = """
        # # Public Function add_cut_points(hybrid_shape_sweep)
        # #     Dim iElement1 (2)
        # #     hybrid_shape_sweep.AddCutPoints iElement1
        # #     add_cut_points = iElement1
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_fill_points(self, i_element1: Reference, i_element2: Reference) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AddFillPoints(Reference iElement1,
                | Reference iElement2)
                | 
                |     Sets two fill points on the master guide. These points define a zone to be
                |     filled on the final swept surface.
                | 
                |     Parameters:
                | 
                |         iElement1
                |             First / start fill point. 
                |         iElement2
                |             Second / end fill point.

        :param Reference i_element1:
        :param Reference i_element2:
        :return: None
        :rtype: None
        """
        return self.hybrid_shape_sweep.AddFillPoints(i_element1.com_object, i_element2.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_fill_points'
        # # vba_code = """
        # # Public Function add_fill_points(hybrid_shape_sweep)
        # #     Dim iElement1 (2)
        # #     hybrid_shape_sweep.AddFillPoints iElement1
        # #     add_fill_points = iElement1
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_cut_point(self, i_rank: int) -> Reference:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetCutPoint(long iRank) As Reference

        :param int i_rank:
        :return: Reference
        :rtype: Reference
        """
        return Reference(self.hybrid_shape_sweep.GetCutPoint(i_rank))

    def get_fill_point(self, i_rank: int) -> Reference:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetFillPoint(long iRank) As Reference

        :param int i_rank:
        :return: Reference
        :rtype: Reference
        """
        return Reference(self.hybrid_shape_sweep.GetFillPoint(i_rank))

    def remove_all_cut_points(self) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub RemoveAllCutPoints()
                | 
                |     Removes all cut points.

        :return: None
        :rtype: None
        """
        return self.hybrid_shape_sweep.RemoveAllCutPoints()

    def remove_all_fill_points(self) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub RemoveAllFillPoints()
                | 
                |     Removes all fill points.

        :return: None
        :rtype: None
        """
        return self.hybrid_shape_sweep.RemoveAllFillPoints()

    def __repr__(self):
        return f'HybridShapeSweep(name="{ self.name }")'
