# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UCIntegration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UCIntegration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'uc_integration_key': 'str',
            'integration_presence_source': 'str',
            'pbx_permission': 'str',
            'icon': 'UCIcon',
            'badge_icons': 'dict(str, UCIcon)',
            'i10n': 'dict(str, UCI10n)',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'uc_integration_key': 'ucIntegrationKey',
            'integration_presence_source': 'integrationPresenceSource',
            'pbx_permission': 'pbxPermission',
            'icon': 'icon',
            'badge_icons': 'badgeIcons',
            'i10n': 'i10n',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._uc_integration_key = None
        self._integration_presence_source = None
        self._pbx_permission = None
        self._icon = None
        self._badge_icons = None
        self._i10n = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this UCIntegration.
        The globally unique identifier for the object.

        :return: The id of this UCIntegration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this UCIntegration.
        The globally unique identifier for the object.

        :param id: The id of this UCIntegration.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this UCIntegration.


        :return: The name of this UCIntegration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UCIntegration.


        :param name: The name of this UCIntegration.
        :type: str
        """
        

        self._name = name

    @property
    def uc_integration_key(self):
        """
        Gets the uc_integration_key of this UCIntegration.
        ucIntegrationKey

        :return: The uc_integration_key of this UCIntegration.
        :rtype: str
        """
        return self._uc_integration_key

    @uc_integration_key.setter
    def uc_integration_key(self, uc_integration_key):
        """
        Sets the uc_integration_key of this UCIntegration.
        ucIntegrationKey

        :param uc_integration_key: The uc_integration_key of this UCIntegration.
        :type: str
        """
        

        self._uc_integration_key = uc_integration_key

    @property
    def integration_presence_source(self):
        """
        Gets the integration_presence_source of this UCIntegration.
        integrationPresenceType

        :return: The integration_presence_source of this UCIntegration.
        :rtype: str
        """
        return self._integration_presence_source

    @integration_presence_source.setter
    def integration_presence_source(self, integration_presence_source):
        """
        Sets the integration_presence_source of this UCIntegration.
        integrationPresenceType

        :param integration_presence_source: The integration_presence_source of this UCIntegration.
        :type: str
        """
        allowed_values = ["MicrosoftTeams", "ZoomPhone", "EightByEight"]
        if integration_presence_source.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for integration_presence_source -> " + integration_presence_source)
            self._integration_presence_source = "outdated_sdk_version"
        else:
            self._integration_presence_source = integration_presence_source

    @property
    def pbx_permission(self):
        """
        Gets the pbx_permission of this UCIntegration.
        pbxPermission

        :return: The pbx_permission of this UCIntegration.
        :rtype: str
        """
        return self._pbx_permission

    @pbx_permission.setter
    def pbx_permission(self, pbx_permission):
        """
        Sets the pbx_permission of this UCIntegration.
        pbxPermission

        :param pbx_permission: The pbx_permission of this UCIntegration.
        :type: str
        """
        

        self._pbx_permission = pbx_permission

    @property
    def icon(self):
        """
        Gets the icon of this UCIntegration.
        icon

        :return: The icon of this UCIntegration.
        :rtype: UCIcon
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """
        Sets the icon of this UCIntegration.
        icon

        :param icon: The icon of this UCIntegration.
        :type: UCIcon
        """
        

        self._icon = icon

    @property
    def badge_icons(self):
        """
        Gets the badge_icons of this UCIntegration.
        badgeIcon

        :return: The badge_icons of this UCIntegration.
        :rtype: dict(str, UCIcon)
        """
        return self._badge_icons

    @badge_icons.setter
    def badge_icons(self, badge_icons):
        """
        Sets the badge_icons of this UCIntegration.
        badgeIcon

        :param badge_icons: The badge_icons of this UCIntegration.
        :type: dict(str, UCIcon)
        """
        

        self._badge_icons = badge_icons

    @property
    def i10n(self):
        """
        Gets the i10n of this UCIntegration.
        i10n

        :return: The i10n of this UCIntegration.
        :rtype: dict(str, UCI10n)
        """
        return self._i10n

    @i10n.setter
    def i10n(self, i10n):
        """
        Sets the i10n of this UCIntegration.
        i10n

        :param i10n: The i10n of this UCIntegration.
        :type: dict(str, UCI10n)
        """
        

        self._i10n = i10n

    @property
    def self_uri(self):
        """
        Gets the self_uri of this UCIntegration.
        The URI for this object

        :return: The self_uri of this UCIntegration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this UCIntegration.
        The URI for this object

        :param self_uri: The self_uri of this UCIntegration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

