# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DialogflowAgent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DialogflowAgent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'project': 'DialogflowProject',
            'languages': 'list[str]',
            'intents': 'list[DialogflowIntent]',
            'environments': 'list[str]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'project': 'project',
            'languages': 'languages',
            'intents': 'intents',
            'environments': 'environments',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._project = None
        self._languages = None
        self._intents = None
        self._environments = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this DialogflowAgent.
        The globally unique identifier for the object.

        :return: The id of this DialogflowAgent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DialogflowAgent.
        The globally unique identifier for the object.

        :param id: The id of this DialogflowAgent.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this DialogflowAgent.


        :return: The name of this DialogflowAgent.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DialogflowAgent.


        :param name: The name of this DialogflowAgent.
        :type: str
        """
        

        self._name = name

    @property
    def project(self):
        """
        Gets the project of this DialogflowAgent.
        The project this Dialogflow agent belongs to

        :return: The project of this DialogflowAgent.
        :rtype: DialogflowProject
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Sets the project of this DialogflowAgent.
        The project this Dialogflow agent belongs to

        :param project: The project of this DialogflowAgent.
        :type: DialogflowProject
        """
        

        self._project = project

    @property
    def languages(self):
        """
        Gets the languages of this DialogflowAgent.
        The supported languages of the Dialogflow agent

        :return: The languages of this DialogflowAgent.
        :rtype: list[str]
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """
        Sets the languages of this DialogflowAgent.
        The supported languages of the Dialogflow agent

        :param languages: The languages of this DialogflowAgent.
        :type: list[str]
        """
        

        self._languages = languages

    @property
    def intents(self):
        """
        Gets the intents of this DialogflowAgent.
        An array of Intents associated with this agent

        :return: The intents of this DialogflowAgent.
        :rtype: list[DialogflowIntent]
        """
        return self._intents

    @intents.setter
    def intents(self, intents):
        """
        Sets the intents of this DialogflowAgent.
        An array of Intents associated with this agent

        :param intents: The intents of this DialogflowAgent.
        :type: list[DialogflowIntent]
        """
        

        self._intents = intents

    @property
    def environments(self):
        """
        Gets the environments of this DialogflowAgent.
        Available environments for this agent

        :return: The environments of this DialogflowAgent.
        :rtype: list[str]
        """
        return self._environments

    @environments.setter
    def environments(self, environments):
        """
        Sets the environments of this DialogflowAgent.
        Available environments for this agent

        :param environments: The environments of this DialogflowAgent.
        :type: list[str]
        """
        

        self._environments = environments

    @property
    def self_uri(self):
        """
        Gets the self_uri of this DialogflowAgent.
        The URI for this object

        :return: The self_uri of this DialogflowAgent.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this DialogflowAgent.
        The URI for this object

        :param self_uri: The self_uri of this DialogflowAgent.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

