# coding: utf-8

"""
LearningApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class LearningApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_learning_assignment(self, assignment_id, **kwargs):
        """
        Delete a learning assignment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_learning_assignment(assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assignment_id: The Learning Assignment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_learning_assignment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `delete_learning_assignment`")


        resource_path = '/api/v2/learning/assignments/{assignmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_learning_module(self, module_id, **kwargs):
        """
        Delete a learning module
        This will delete a learning module if it is unpublished or it will delete a published and archived learning module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_learning_module(module_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_learning_module" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `delete_learning_module`")


        resource_path = '/api/v2/learning/modules/{moduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_assignment(self, assignment_id, **kwargs):
        """
        Get Learning Assignment
        Permission not required if you are the assigned user of the learning assignment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_assignment(assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assignment_id: The ID of Learning Assignment (required)
        :param list[str] expand: Fields to expand in response
        :return: LearningAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_assignment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_learning_assignment`")


        resource_path = '/api/v2/learning/assignments/{assignmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_assignments(self, **kwargs):
        """
        List of Learning module Assignments
        Either moduleId or user value is required

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_assignments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: Specifies the ID of the learning module. Fetch assignments for learning module ID
        :param str interval: Specifies the range of dueDates to be queried. Milliseconds will be truncated. A maximum of 1 year can be specified in the range. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str completion_interval: Specifies the range of completion dates to be used for filtering. A maximum of 1 year can be specified in the range. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str overdue: Specifies if only the non-overdue (overdue is \"False\") or overdue (overdue is \"True\") assignments are returned. If overdue is \"Any\" or if the overdue parameter is not supplied, all assignments are returned
        :param int page_size: Page size
        :param int page_number: Page number
        :param str pcPass: Specifies if only the failed (pass is \"False\") or passed (pass is \"True\") assignments (completed with assessment)are returned. If pass is \"Any\" or if the pass parameter is not supplied, all assignments are returned
        :param float min_percentage_score: The minimum assessment score for an assignment (completed with assessment) to be included in the results (inclusive)
        :param float max_percentage_score: The maximum assessment score for an assignment (completed with assessment) to be included in the results (inclusive)
        :param str sort_order: Specifies result set sort order; if not specified, default sort order is descending (Desc)
        :param str sort_by: Specifies which field to sort the results by, default sort is by recommendedCompletionDate
        :param list[str] user_id: Specifies the list of user IDs to be queried, up to 100 user IDs.
        :param list[str] types: Specifies the assignment types, currently not supported and will be ignored. For now, all learning assignments regardless of types will be returned
        :param list[str] states: Specifies the assignment states to filter by
        :param list[str] expand: Specifies the expand option for returning additional information
        :return: LearningAssignmentsDomainEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'interval', 'completion_interval', 'overdue', 'page_size', 'page_number', 'pcPass', 'min_percentage_score', 'max_percentage_score', 'sort_order', 'sort_by', 'user_id', 'types', 'states', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_assignments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/learning/assignments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'module_id' in params:
            query_params['moduleId'] = params['module_id']
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'completion_interval' in params:
            query_params['completionInterval'] = params['completion_interval']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'pcPass' in params:
            query_params['pass'] = params['pcPass']
        if 'min_percentage_score' in params:
            query_params['minPercentageScore'] = params['min_percentage_score']
        if 'max_percentage_score' in params:
            query_params['maxPercentageScore'] = params['max_percentage_score']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'user_id' in params:
            query_params['userId'] = params['user_id']
        if 'types' in params:
            query_params['types'] = params['types']
        if 'states' in params:
            query_params['states'] = params['states']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignmentsDomainEntity',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_assignments_me(self, **kwargs):
        """
        List of Learning Assignments assigned to current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_assignments_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: Specifies the ID of the learning module. Fetch assignments for learning module ID
        :param str interval: Specifies the range of dueDates to be queried. Milliseconds will be truncated. A maximum of 1 year can be specified in the range. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str completion_interval: Specifies the range of completion dates to be used for filtering. A maximum of 1 year can be specified in the range. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str overdue: Specifies if only the non-overdue (overdue is \"False\") or overdue (overdue is \"True\") assignments are returned. If overdue is \"Any\" or if the overdue parameter is not supplied, all assignments are returned
        :param int page_size: Page size
        :param int page_number: Page number
        :param str pcPass: Specifies if only the failed (pass is \"False\") or passed (pass is \"True\") assignments (completed with assessment)are returned. If pass is \"Any\" or if the pass parameter is not supplied, all assignments are returned
        :param float min_percentage_score: The minimum assessment score for an assignment (completed with assessment) to be included in the results (inclusive)
        :param float max_percentage_score: The maximum assessment score for an assignment (completed with assessment) to be included in the results (inclusive)
        :param str sort_order: Specifies result set sort order; if not specified, default sort order is descending (Desc)
        :param str sort_by: Specifies which field to sort the results by, default sort is by recommendedCompletionDate
        :param list[str] types: Specifies the assignment types, currently not supported and will be ignored. For now, all learning assignments regardless of types will be returned
        :param list[str] states: Specifies the assignment states to filter by
        :param list[str] expand: Specifies the expand option for returning additional information
        :return: LearningAssignmentsDomainEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'interval', 'completion_interval', 'overdue', 'page_size', 'page_number', 'pcPass', 'min_percentage_score', 'max_percentage_score', 'sort_order', 'sort_by', 'types', 'states', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_assignments_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/learning/assignments/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'module_id' in params:
            query_params['moduleId'] = params['module_id']
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'completion_interval' in params:
            query_params['completionInterval'] = params['completion_interval']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'pcPass' in params:
            query_params['pass'] = params['pcPass']
        if 'min_percentage_score' in params:
            query_params['minPercentageScore'] = params['min_percentage_score']
        if 'max_percentage_score' in params:
            query_params['maxPercentageScore'] = params['max_percentage_score']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'types' in params:
            query_params['types'] = params['types']
        if 'states' in params:
            query_params['states'] = params['states']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignmentsDomainEntity',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_module(self, module_id, **kwargs):
        """
        Get a learning module
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_module(module_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :param list[str] expand: Fields to expand in response(case insensitive)
        :return: LearningModule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_module" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `get_learning_module`")


        resource_path = '/api/v2/learning/modules/{moduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_module_job(self, module_id, job_id, **kwargs):
        """
        Get a specific Learning Module job status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_module_job(module_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :param str job_id: The ID of the learning module job (required)
        :return: LearningModuleJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_module_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `get_learning_module_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_learning_module_job`")


        resource_path = '/api/v2/learning/modules/{moduleId}/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModuleJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_module_rule(self, module_id, **kwargs):
        """
        Get a learning module rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_module_rule(module_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :return: LearningModuleRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_module_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `get_learning_module_rule`")


        resource_path = '/api/v2/learning/modules/{moduleId}/rule'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModuleRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_module_version(self, module_id, version_id, **kwargs):
        """
        Get specific version of a published module
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_module_version(module_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :param str version_id: The version of learning module (required)
        :param list[str] expand: Fields to expand in response(case insensitive)
        :return: LearningModule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'version_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_module_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `get_learning_module_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_learning_module_version`")


        resource_path = '/api/v2/learning/modules/{moduleId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_modules(self, **kwargs):
        """
        Get all learning modules of an organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_modules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool is_archived: Archive status
        :param list[str] types: Specifies the module types.
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param str search_term: Search Term (searchable by name)
        :param list[str] expand: Fields to expand in response(case insensitive)
        :param str is_published: Specifies if only the Unpublished (isPublished is \"False\") or Published (isPublished is \"True\") modules are returned. If isPublished is \"Any\" or omitted, both types are returned
        :return: LearningModulesDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['is_archived', 'types', 'page_size', 'page_number', 'sort_order', 'sort_by', 'search_term', 'expand', 'is_published']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_modules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/learning/modules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'is_archived' in params:
            query_params['isArchived'] = params['is_archived']
        if 'types' in params:
            query_params['types'] = params['types']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'search_term' in params:
            query_params['searchTerm'] = params['search_term']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'is_published' in params:
            query_params['isPublished'] = params['is_published']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModulesDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_learning_modules_assignments(self, user_ids, **kwargs):
        """
        Get all learning modules of an organization including assignments for a specific user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_learning_modules_assignments(user_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] user_ids: The IDs of the users to include (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str search_term: Search Term (searches by name and description)
        :param str overdue: Specifies if only modules with overdue/not overdue (overdue is \"True\" or \"False\") assignments are returned. If overdue is \"Any\" or omitted, both are returned and can including modules that are unassigned.
        :param list[str] assignment_states: Specifies the assignment states to return.
        :param list[str] expand: Fields to expand in response(case insensitive)
        :return: AssignedLearningModuleDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_ids', 'page_size', 'page_number', 'search_term', 'overdue', 'assignment_states', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_learning_modules_assignments" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_ids' is set
        if ('user_ids' not in params) or (params['user_ids'] is None):
            raise ValueError("Missing the required parameter `user_ids` when calling `get_learning_modules_assignments`")


        resource_path = '/api/v2/learning/modules/assignments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_ids' in params:
            query_params['userIds'] = params['user_ids']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'search_term' in params:
            query_params['searchTerm'] = params['search_term']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'assignment_states' in params:
            query_params['assignmentStates'] = params['assignment_states']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssignedLearningModuleDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_learning_assignment(self, assignment_id, **kwargs):
        """
        Update Learning Assignment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_learning_assignment(assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assignment_id: The ID of Learning Assignment (required)
        :param LearningAssignmentUpdate body: The Learning Assignment to be updated
        :return: LearningAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_learning_assignment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `patch_learning_assignment`")


        resource_path = '/api/v2/learning/assignments/{assignmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assessments_scoring(self, body, **kwargs):
        """
        Score learning assessment for preview
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assessments_scoring(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LearningAssessmentScoringRequest body: Assessment form and answers to score (required)
        :return: AssessmentScoringSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assessments_scoring" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_learning_assessments_scoring`")


        resource_path = '/api/v2/learning/assessments/scoring'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssessmentScoringSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assignment_reassign(self, assignment_id, **kwargs):
        """
        Reassign Learning Assignment
        This will reassign the state of the assignment to 'Assigned' and update the assignment to the latest version of the module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assignment_reassign(assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assignment_id: The Learning Assignment ID (required)
        :return: LearningAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assignment_reassign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `post_learning_assignment_reassign`")


        resource_path = '/api/v2/learning/assignments/{assignmentId}/reassign'.replace('{format}', 'json')
        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assignment_reset(self, assignment_id, **kwargs):
        """
        Reset Learning Assignment
        This will reset the state of the assignment to 'Assigned' and remove the version of Learning module associated with the assignment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assignment_reset(assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assignment_id: The Learning Assignment ID (required)
        :return: LearningAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assignment_reset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `post_learning_assignment_reset`")


        resource_path = '/api/v2/learning/assignments/{assignmentId}/reset'.replace('{format}', 'json')
        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assignments(self, **kwargs):
        """
        Create Learning Assignment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assignments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LearningAssignmentCreate body: The Learning Assignment to be created
        :return: LearningAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assignments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/learning/assignments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assignments_aggregates_query(self, body, **kwargs):
        """
        Retrieve aggregated assignment data
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assignments_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LearningAssignmentAggregateParam body: Aggregate Request (required)
        :return: LearningAssignmentAggregateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assignments_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_learning_assignments_aggregates_query`")


        resource_path = '/api/v2/learning/assignments/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignmentAggregateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assignments_bulkadd(self, **kwargs):
        """
        Add multiple learning assignments
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assignments_bulkadd(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[LearningAssignmentItem] body: The learning assignments to be created
        :return: LearningAssignmentBulkAddResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assignments_bulkadd" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/learning/assignments/bulkadd'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignmentBulkAddResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_assignments_bulkremove(self, **kwargs):
        """
        Remove multiple Learning Assignments
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_assignments_bulkremove(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: The IDs of the learning assignments to be removed
        :return: LearningAssignmentBulkRemoveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_assignments_bulkremove" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/learning/assignments/bulkremove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignmentBulkRemoveResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_module_jobs(self, module_id, body, **kwargs):
        """
        Starts a specified operation on learning module
        This will initiate operation specified in the request body for a learning module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_module_jobs(module_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :param LearningModuleJobRequest body: The learning module job request (required)
        :return: LearningModuleJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_module_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `post_learning_module_jobs`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_learning_module_jobs`")


        resource_path = '/api/v2/learning/modules/{moduleId}/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModuleJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_module_publish(self, module_id, **kwargs):
        """
        Publish a Learning module
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_module_publish(module_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :return: LearningModulePublishResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_module_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `post_learning_module_publish`")


        resource_path = '/api/v2/learning/modules/{moduleId}/publish'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModulePublishResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_modules(self, body, **kwargs):
        """
        Create a new learning module
        This will create a new unpublished learning module with the specified fields.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_modules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LearningModuleRequest body: The learning module to be created (required)
        :return: LearningModule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_modules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_learning_modules`")


        resource_path = '/api/v2/learning/modules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_learning_rules_query(self, page_size, page_number, body, **kwargs):
        """
        Get users for learning module rule
        This will get the users who matches the given rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_learning_rules_query(page_size, page_number, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size (required)
        :param int page_number: Page number (required)
        :param LearningAssignmentUserQuery body: The learning module rule to fetch users (required)
        :return: LearningAssignmentUserListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_learning_rules_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `post_learning_rules_query`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `post_learning_rules_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_learning_rules_query`")


        resource_path = '/api/v2/learning/rules/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningAssignmentUserListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_learning_module(self, module_id, body, **kwargs):
        """
        Update a learning module
        This will update the name, description, completion time in days and inform steps for a learning module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_learning_module(module_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :param LearningModuleRequest body: The learning module to be updated (required)
        :return: LearningModule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_learning_module" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `put_learning_module`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_learning_module`")


        resource_path = '/api/v2/learning/modules/{moduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_learning_module_rule(self, module_id, body, **kwargs):
        """
        Update a learning module rule
        This will update a learning module rule with the specified fields.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_learning_module_rule(module_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: The ID of the learning module (required)
        :param LearningModuleRule body: The learning module rule to be updated (required)
        :return: LearningModuleRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_learning_module_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `put_learning_module_rule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_learning_module_rule`")


        resource_path = '/api/v2/learning/modules/{moduleId}/rule'.replace('{format}', 'json')
        path_params = {}
        if 'module_id' in params:
            path_params['moduleId'] = params['module_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LearningModuleRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
