"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TestCaseResult:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TestCaseResultEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TestCaseResult.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUCCESS: _TestCaseResult.ValueType  # 0
    FAILURE: _TestCaseResult.ValueType  # 1
    SKIPPED: _TestCaseResult.ValueType  # 2

class TestCaseResult(_TestCaseResult, metaclass=_TestCaseResultEnumTypeWrapper): ...

SUCCESS: TestCaseResult.ValueType  # 0
FAILURE: TestCaseResult.ValueType  # 1
SKIPPED: TestCaseResult.ValueType  # 2
global___TestCaseResult = TestCaseResult

class TestCaseDescriptor(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUITE_NAME_FIELD_NUMBER: builtins.int
    TEST_NAME_FIELD_NUMBER: builtins.int
    FILE_NAME_FIELD_NUMBER: builtins.int
    suite_name: builtins.str
    """Name of the test suite to which this test case belongs."""
    test_name: builtins.str
    """Name of the test case."""
    file_name: builtins.str
    """Path to the file in which the test case is defined."""
    def __init__(
        self,
        *,
        suite_name: builtins.str = ...,
        test_name: builtins.str = ...,
        file_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_name", b"file_name", "suite_name", b"suite_name", "test_name", b"test_name"]) -> None: ...

global___TestCaseDescriptor = TestCaseDescriptor

class TestCaseExpectation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPRESSION_FIELD_NUMBER: builtins.int
    EVALUATED_EXPRESSION_FIELD_NUMBER: builtins.int
    LINE_NUMBER_FIELD_NUMBER: builtins.int
    SUCCESS_FIELD_NUMBER: builtins.int
    expression: builtins.str
    """The source code for the expression which was run."""
    evaluated_expression: builtins.str
    """The expression with arguments evaluated."""
    line_number: builtins.int
    """Line number at which the expectation is located."""
    success: builtins.bool
    """Whether the expectation succeeded."""
    def __init__(
        self,
        *,
        expression: builtins.str = ...,
        evaluated_expression: builtins.str = ...,
        line_number: builtins.int = ...,
        success: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["evaluated_expression", b"evaluated_expression", "expression", b"expression", "line_number", b"line_number", "success", b"success"]) -> None: ...

global___TestCaseExpectation = TestCaseExpectation

class TestRunStart(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___TestRunStart = TestRunStart

class TestRunEnd(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PASSED_FIELD_NUMBER: builtins.int
    FAILED_FIELD_NUMBER: builtins.int
    SKIPPED_FIELD_NUMBER: builtins.int
    DISABLED_FIELD_NUMBER: builtins.int
    passed: builtins.int
    failed: builtins.int
    skipped: builtins.int
    disabled: builtins.int
    def __init__(
        self,
        *,
        passed: builtins.int = ...,
        failed: builtins.int = ...,
        skipped: builtins.int = ...,
        disabled: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["disabled", b"disabled", "failed", b"failed", "passed", b"passed", "skipped", b"skipped"]) -> None: ...

global___TestRunEnd = TestRunEnd

class Event(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEST_RUN_START_FIELD_NUMBER: builtins.int
    TEST_RUN_END_FIELD_NUMBER: builtins.int
    TEST_CASE_START_FIELD_NUMBER: builtins.int
    TEST_CASE_END_FIELD_NUMBER: builtins.int
    TEST_CASE_DISABLED_FIELD_NUMBER: builtins.int
    TEST_CASE_EXPECTATION_FIELD_NUMBER: builtins.int
    @property
    def test_run_start(self) -> global___TestRunStart:
        """Unit test run has started."""
    @property
    def test_run_end(self) -> global___TestRunEnd:
        """Unit test run has ended."""
    @property
    def test_case_start(self) -> global___TestCaseDescriptor:
        """Start of a test case."""
    test_case_end: global___TestCaseResult.ValueType
    """End of a test case."""
    @property
    def test_case_disabled(self) -> global___TestCaseDescriptor:
        """Encountered a disabled test case."""
    @property
    def test_case_expectation(self) -> global___TestCaseExpectation:
        """Expectation statement within a test case."""
    def __init__(
        self,
        *,
        test_run_start: global___TestRunStart | None = ...,
        test_run_end: global___TestRunEnd | None = ...,
        test_case_start: global___TestCaseDescriptor | None = ...,
        test_case_end: global___TestCaseResult.ValueType = ...,
        test_case_disabled: global___TestCaseDescriptor | None = ...,
        test_case_expectation: global___TestCaseExpectation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["test_case_disabled", b"test_case_disabled", "test_case_end", b"test_case_end", "test_case_expectation", b"test_case_expectation", "test_case_start", b"test_case_start", "test_run_end", b"test_run_end", "test_run_start", b"test_run_start", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["test_case_disabled", b"test_case_disabled", "test_case_end", b"test_case_end", "test_case_expectation", b"test_case_expectation", "test_case_start", b"test_case_start", "test_run_end", b"test_run_end", "test_run_start", b"test_run_start", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["test_run_start", "test_run_end", "test_case_start", "test_case_end", "test_case_disabled", "test_case_expectation"] | None: ...

global___Event = Event

class TestRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_PASSED_EXPECTATIONS_FIELD_NUMBER: builtins.int
    TEST_SUITE_FIELD_NUMBER: builtins.int
    report_passed_expectations: builtins.bool
    """Whether to send expectation events for successful checks."""
    @property
    def test_suite(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional list of test suites to run."""
    def __init__(
        self,
        *,
        report_passed_expectations: builtins.bool = ...,
        test_suite: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["report_passed_expectations", b"report_passed_expectations", "test_suite", b"test_suite"]) -> None: ...

global___TestRunRequest = TestRunRequest
