"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import pw_software_update.tuf_pb2
import sys
import typing

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class UpdateBundle(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class TargetsMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> pw_software_update.tuf_pb2.SignedTargetsMetadata: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: pw_software_update.tuf_pb2.SignedTargetsMetadata | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class TargetPayloadsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_METADATA_FIELD_NUMBER: builtins.int
    SNAPSHOT_METADATA_FIELD_NUMBER: builtins.int
    TARGETS_METADATA_FIELD_NUMBER: builtins.int
    TARGET_PAYLOADS_FIELD_NUMBER: builtins.int
    ROOT_METADATA_FIELD_NUMBER: builtins.int
    @property
    def timestamp_metadata(self) -> pw_software_update.tuf_pb2.SignedTimestampMetadata:
        """The timestamp role is used for freshness check of the snapshot. Any
        project-specific update metadata should go in the top-level
        targets_metadata or with the TargetFile information
        """
    @property
    def snapshot_metadata(self) -> pw_software_update.tuf_pb2.SignedSnapshotMetadata:
        """The snapshot role is used to ensure that the collection of targets_metadata
        files is securely consistent (no target metadata mix and match). Any
        project-specific update metadata should go in the top-level
        targets_metadata or with the TargetFile information
        """
    @property
    def targets_metadata(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, pw_software_update.tuf_pb2.SignedTargetsMetadata]:
        """Map of target metadata name to target metadata.
        Target metadata name can be an arbitrary name or a path that describes
        where the file lives relative to the base directory of the repository, as
        described in the snapshot metadata. e.g. "path/to/target/0".
        """
    @property
    def target_payloads(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.bytes]:
        """Map of target file name to target payload bytes.
        Target file name can be an arbitrary name or a path that describes where
        the file lives relative to the base directory of the repository, as
        described in the target metadata. e.g. "path/to/amber_tools/0".
        """
    @property
    def root_metadata(self) -> pw_software_update.tuf_pb2.SignedRootMetadata:
        """If present, a client will attempt to upgrade its on-device trusted root
        metadata to the root metadata included in the bundle, following the
        standard "Update the root role" flow specified in the TUF spec, but
        without "version climbing".

        The exact steps are:
        1. Check if there is a root metadata in the bundle.
        2. If the root metadata IS NOT included, assume on-device root metadata
           is up-to-date and continue with the rest of metadata verification.
        3. If the root metadata IS included, verify the new root metadata using
           the on-device root metadata.
        4. If the verification is successful, persist new root metadata and
           continue with the rest of metadata verification. Otherwise abort the
           update session.

        The key deviation from standard flow is the client assumes it can always
        directly upgrade to the single new root metadata in the update bundle,
        without any step-stone history root metadata. This works only because
        we are not supporting (more than 1) root key rotations.
        """
    def __init__(
        self,
        *,
        timestamp_metadata: pw_software_update.tuf_pb2.SignedTimestampMetadata | None = ...,
        snapshot_metadata: pw_software_update.tuf_pb2.SignedSnapshotMetadata | None = ...,
        targets_metadata: collections.abc.Mapping[builtins.str, pw_software_update.tuf_pb2.SignedTargetsMetadata] | None = ...,
        target_payloads: collections.abc.Mapping[builtins.str, builtins.bytes] | None = ...,
        root_metadata: pw_software_update.tuf_pb2.SignedRootMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_root_metadata", b"_root_metadata", "_snapshot_metadata", b"_snapshot_metadata", "_timestamp_metadata", b"_timestamp_metadata", "root_metadata", b"root_metadata", "snapshot_metadata", b"snapshot_metadata", "timestamp_metadata", b"timestamp_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_root_metadata", b"_root_metadata", "_snapshot_metadata", b"_snapshot_metadata", "_timestamp_metadata", b"_timestamp_metadata", "root_metadata", b"root_metadata", "snapshot_metadata", b"snapshot_metadata", "target_payloads", b"target_payloads", "targets_metadata", b"targets_metadata", "timestamp_metadata", b"timestamp_metadata"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_root_metadata", b"_root_metadata"]) -> typing_extensions.Literal["root_metadata"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_snapshot_metadata", b"_snapshot_metadata"]) -> typing_extensions.Literal["snapshot_metadata"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timestamp_metadata", b"_timestamp_metadata"]) -> typing_extensions.Literal["timestamp_metadata"] | None: ...

global___UpdateBundle = UpdateBundle

class Manifest(google.protobuf.message.Message):
    """Update bundle metadata
    Designed to inform the update server what the device currently has in-place.
    Also used to persist the TUF metadata for use in the verification process.
    Stored manifest is only written/erased by the update service. In all other
    contexts the stored manifest is considered read-only.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class TargetsMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> pw_software_update.tuf_pb2.TargetsMetadata: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: pw_software_update.tuf_pb2.TargetsMetadata | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TARGETS_METADATA_FIELD_NUMBER: builtins.int
    USER_MANIFEST_FIELD_NUMBER: builtins.int
    @property
    def targets_metadata(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, pw_software_update.tuf_pb2.TargetsMetadata]: ...
    user_manifest: builtins.bytes
    """Insert user manifest target file content here"""
    def __init__(
        self,
        *,
        targets_metadata: collections.abc.Mapping[builtins.str, pw_software_update.tuf_pb2.TargetsMetadata] | None = ...,
        user_manifest: builtins.bytes | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_user_manifest", b"_user_manifest", "user_manifest", b"user_manifest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_user_manifest", b"_user_manifest", "targets_metadata", b"targets_metadata", "user_manifest", b"user_manifest"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_user_manifest", b"_user_manifest"]) -> typing_extensions.Literal["user_manifest"] | None: ...

global___Manifest = Manifest
