"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class BundledUpdateState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BundledUpdateState._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: BundledUpdateState._Enum.ValueType  # 0
        """Not an expected state in the OTA system; only for proto."""
        INACTIVE: BundledUpdateState._Enum.ValueType  # 1
        """Valid methods in this state: Start()

        Transition:
          Start() succeeds --> TRANSFERRING
          Start() fails    --> FINISHED
        """
        TRANSFERRING: BundledUpdateState._Enum.ValueType  # 2
        """Valid methods in this state: GetStatus(), Abort().

        Transitions:
          Transfer completes --> TRANSFERRED
          Transfer fails     --> FINISHED
          Abort() called     --> ABORTING
        """
        TRANSFERRED: BundledUpdateState._Enum.ValueType  # 3
        """Valid methods in this state: GetStatus(), Abort(), Verify().

        Transitions:
          Verify() called    --> VERIFYING
          Apply() called     --> VERIFYING
          Abort() called     --> ABORTING
        """
        VERIFYING: BundledUpdateState._Enum.ValueType  # 4
        """Valid methods in this state: GetStatus(), Abort().

        Transitions:
          Verifying finished --> VERIFIED
          Verifying failed   --> FINISHED
          Abort() called     --> ABORTING
        """
        VERIFIED: BundledUpdateState._Enum.ValueType  # 5
        """Valid methods in this state: GetStatus(), Abort(), Apply().

        Transitions:
          Apply() called --> APPLYING
          Abort() called --> ABORTING
        """
        APPLYING: BundledUpdateState._Enum.ValueType  # 6
        """Valid methods in this state: GetStatus().

        Transitions:
          Apply() finished --> FINISHED; may require persisting across a reboot.
          Apply() failed   --> FINISHED; with error set.
        """
        ABORTING: BundledUpdateState._Enum.ValueType  # 7
        """Valid methods in this state: GetStatus().

        Transitions:
          Abort finishes --> FINISHED
          Abort fails    --> FINISHED
        """
        FINISHED: BundledUpdateState._Enum.ValueType  # 8
        """Valid methods in this state: GetStatus(), Reset().

        Terminal state indicating a finished update; whether successful or
        not. Additional termination information available in completion_state
        and possibly note.

        Transitions:
          Reset() succeeds --> INACTIVE
          Reset() fails    --> FINISHED
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNKNOWN: BundledUpdateState.Enum.ValueType  # 0
    """Not an expected state in the OTA system; only for proto."""
    INACTIVE: BundledUpdateState.Enum.ValueType  # 1
    """Valid methods in this state: Start()

    Transition:
      Start() succeeds --> TRANSFERRING
      Start() fails    --> FINISHED
    """
    TRANSFERRING: BundledUpdateState.Enum.ValueType  # 2
    """Valid methods in this state: GetStatus(), Abort().

    Transitions:
      Transfer completes --> TRANSFERRED
      Transfer fails     --> FINISHED
      Abort() called     --> ABORTING
    """
    TRANSFERRED: BundledUpdateState.Enum.ValueType  # 3
    """Valid methods in this state: GetStatus(), Abort(), Verify().

    Transitions:
      Verify() called    --> VERIFYING
      Apply() called     --> VERIFYING
      Abort() called     --> ABORTING
    """
    VERIFYING: BundledUpdateState.Enum.ValueType  # 4
    """Valid methods in this state: GetStatus(), Abort().

    Transitions:
      Verifying finished --> VERIFIED
      Verifying failed   --> FINISHED
      Abort() called     --> ABORTING
    """
    VERIFIED: BundledUpdateState.Enum.ValueType  # 5
    """Valid methods in this state: GetStatus(), Abort(), Apply().

    Transitions:
      Apply() called --> APPLYING
      Abort() called --> ABORTING
    """
    APPLYING: BundledUpdateState.Enum.ValueType  # 6
    """Valid methods in this state: GetStatus().

    Transitions:
      Apply() finished --> FINISHED; may require persisting across a reboot.
      Apply() failed   --> FINISHED; with error set.
    """
    ABORTING: BundledUpdateState.Enum.ValueType  # 7
    """Valid methods in this state: GetStatus().

    Transitions:
      Abort finishes --> FINISHED
      Abort fails    --> FINISHED
    """
    FINISHED: BundledUpdateState.Enum.ValueType  # 8
    """Valid methods in this state: GetStatus(), Reset().

    Terminal state indicating a finished update; whether successful or
    not. Additional termination information available in completion_state
    and possibly note.

    Transitions:
      Reset() succeeds --> INACTIVE
      Reset() fails    --> FINISHED
    """

    def __init__(
        self,
    ) -> None: ...

global___BundledUpdateState = BundledUpdateState

class BundledUpdateResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BundledUpdateResult._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: BundledUpdateResult._Enum.ValueType  # 0
        SUCCESS: BundledUpdateResult._Enum.ValueType  # 1
        UNKNOWN_ERROR: BundledUpdateResult._Enum.ValueType  # 2
        ABORTED: BundledUpdateResult._Enum.ValueType  # 3
        TRANSFER_FAILED: BundledUpdateResult._Enum.ValueType  # 4
        VERIFY_FAILED: BundledUpdateResult._Enum.ValueType  # 5
        APPLY_FAILED: BundledUpdateResult._Enum.ValueType  # 6

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNKNOWN: BundledUpdateResult.Enum.ValueType  # 0
    SUCCESS: BundledUpdateResult.Enum.ValueType  # 1
    UNKNOWN_ERROR: BundledUpdateResult.Enum.ValueType  # 2
    ABORTED: BundledUpdateResult.Enum.ValueType  # 3
    TRANSFER_FAILED: BundledUpdateResult.Enum.ValueType  # 4
    VERIFY_FAILED: BundledUpdateResult.Enum.ValueType  # 5
    APPLY_FAILED: BundledUpdateResult.Enum.ValueType  # 6

    def __init__(
        self,
    ) -> None: ...

global___BundledUpdateResult = BundledUpdateResult

class BundledUpdateStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    CURRENT_STATE_PROGRESS_HUNDRETH_PERCENT_FIELD_NUMBER: builtins.int
    TRANSFER_ID_FIELD_NUMBER: builtins.int
    BUNDLE_FILENAME_FIELD_NUMBER: builtins.int
    NOTE_FIELD_NUMBER: builtins.int
    EXTENDED_STATUS_FIELD_NUMBER: builtins.int
    state: global___BundledUpdateState.Enum.ValueType
    result: global___BundledUpdateResult.Enum.ValueType
    current_state_progress_hundreth_percent: builtins.int
    """This is the percentage of estimated progress for the current update
    state in hundreths of a percent. (e.g. 5.00% = 500u)
    """
    transfer_id: builtins.int
    """If present, the active transfer ID for the update."""
    bundle_filename: builtins.str
    """The name of the update bundle. Not present when in INACTIVE state. This is
    useful for enabling resuming of transfers across reboots or disconnects,
    without transferring an expensive manifest.
    """
    note: builtins.bytes
    """Additional information related to the state may be provided here.
    Examples: "Failed verifying: ml_model.bin", "Flash partition couldn't be
    acquired and was busy", etc. Can provide more granular information than
    just the completion result.
    """
    @property
    def extended_status(self) -> google.protobuf.any_pb2.Any:
        """Custom application data."""
    def __init__(
        self,
        *,
        state: global___BundledUpdateState.Enum.ValueType = ...,
        result: global___BundledUpdateResult.Enum.ValueType | None = ...,
        current_state_progress_hundreth_percent: builtins.int | None = ...,
        transfer_id: builtins.int | None = ...,
        bundle_filename: builtins.str | None = ...,
        note: builtins.bytes | None = ...,
        extended_status: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_bundle_filename", b"_bundle_filename", "_current_state_progress_hundreth_percent", b"_current_state_progress_hundreth_percent", "_extended_status", b"_extended_status", "_note", b"_note", "_result", b"_result", "_transfer_id", b"_transfer_id", "bundle_filename", b"bundle_filename", "current_state_progress_hundreth_percent", b"current_state_progress_hundreth_percent", "extended_status", b"extended_status", "note", b"note", "result", b"result", "transfer_id", b"transfer_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_bundle_filename", b"_bundle_filename", "_current_state_progress_hundreth_percent", b"_current_state_progress_hundreth_percent", "_extended_status", b"_extended_status", "_note", b"_note", "_result", b"_result", "_transfer_id", b"_transfer_id", "bundle_filename", b"bundle_filename", "current_state_progress_hundreth_percent", b"current_state_progress_hundreth_percent", "extended_status", b"extended_status", "note", b"note", "result", b"result", "state", b"state", "transfer_id", b"transfer_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_bundle_filename", b"_bundle_filename"]) -> typing_extensions.Literal["bundle_filename"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_current_state_progress_hundreth_percent", b"_current_state_progress_hundreth_percent"]) -> typing_extensions.Literal["current_state_progress_hundreth_percent"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_extended_status", b"_extended_status"]) -> typing_extensions.Literal["extended_status"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_note", b"_note"]) -> typing_extensions.Literal["note"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_result", b"_result"]) -> typing_extensions.Literal["result"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_transfer_id", b"_transfer_id"]) -> typing_extensions.Literal["transfer_id"] | None: ...

global___BundledUpdateStatus = BundledUpdateStatus

class StartRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUNDLE_FILENAME_FIELD_NUMBER: builtins.int
    bundle_filename: builtins.str
    """If present, the filename for the staged file. This should persist across
    reboots, and will be returned from GetStatus() until either the update
    applies or is aborted.
    """
    def __init__(
        self,
        *,
        bundle_filename: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_bundle_filename", b"_bundle_filename", "bundle_filename", b"bundle_filename"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_bundle_filename", b"_bundle_filename", "bundle_filename", b"bundle_filename"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_bundle_filename", b"_bundle_filename"]) -> typing_extensions.Literal["bundle_filename"] | None: ...

global___StartRequest = StartRequest
