"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import pw_chrono_protos.chrono_pb2
import pw_cpu_exception_cortex_m_protos.cpu_state_pb2
import pw_log.proto.log_pb2
import pw_snapshot_metadata_proto.snapshot_metadata_pb2
import pw_thread_protos.thread_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Snapshot(google.protobuf.message.Message):
    """The Snapshot proto is a list that dictates field numbers that should
    be used when serializing proto messages into a "Snapshot" that can be
    ingested by Pigweed's upstream tooling.

    There are various field number ranges that are marked for "upstream" use,
    and others that are marked for "pigweed users". This allows a user to
    define a parallel proto that defines product-specific messages using mutually
    exclusive field numbers:

      MySnapshot {
        // Use a project-specific logging proto format.
        repeated MyLogFormat = 8;

        // Pigweed's snapshot doesn't support my custom RTOS, so write that to
        // a field number reserved for downstream projects.
        MyCustomRtosInfo = 22;
      }

    Writing both proto messages to the same proto encoder is valid because the
    field nubmers are mutually exclusive. This prevents collisions that would
    break a proto decode. The final message will have to be decoded twice; once
    as a pw.snapshot.Snapshot and once as the project-specific message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class TagsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    LOGS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    THREADS_FIELD_NUMBER: builtins.int
    RELATED_SNAPSHOTS_FIELD_NUMBER: builtins.int
    ARMV7M_CPU_STATE_FIELD_NUMBER: builtins.int
    TRACE_DATA_FIELD_NUMBER: builtins.int
    TIMESTAMPS_FIELD_NUMBER: builtins.int
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[pw_log.proto.log_pb2.LogEntry]: ...
    @property
    def metadata(self) -> pw_snapshot_metadata_proto.snapshot_metadata_pb2.Metadata:
        """Note: Proto tags 16-2047 encode with two bytes of overhead."""
    @property
    def tags(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Other data that should be highlighted in this crash. This field may have
        entries added to it during a decode.
        """
    @property
    def threads(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[pw_thread_protos.thread_pb2.Thread]: ...
    @property
    def related_snapshots(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Snapshot]:
        """If a device has multiple cores, it may be useful to collect an associated
        snapshot for attached cores when a snapshot collection is triggered on one
        core. By embedding one or more snapshots into a snapshot, the snapshots are
        considered associated.
        """
    @property
    def armv7m_cpu_state(self) -> pw_cpu_exception_cortex_m_protos.cpu_state_pb2.ArmV7mCpuState: ...
    trace_data: builtins.bytes
    """Platform-specific binary trace data region. Binary trace data is using
    pw_trace_tokenized buffer format for stored data.
    """
    @property
    def timestamps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[pw_chrono_protos.chrono_pb2.TimePoint]:
        """Timestamps that mark when this snapshot occurred. This field is repeated
        to accommodate wall-clock time, time since boot, and/or the raw system
        clock value.
        """
    def __init__(
        self,
        *,
        logs: collections.abc.Iterable[pw_log.proto.log_pb2.LogEntry] | None = ...,
        metadata: pw_snapshot_metadata_proto.snapshot_metadata_pb2.Metadata | None = ...,
        tags: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        threads: collections.abc.Iterable[pw_thread_protos.thread_pb2.Thread] | None = ...,
        related_snapshots: collections.abc.Iterable[global___Snapshot] | None = ...,
        armv7m_cpu_state: pw_cpu_exception_cortex_m_protos.cpu_state_pb2.ArmV7mCpuState | None = ...,
        trace_data: builtins.bytes = ...,
        timestamps: collections.abc.Iterable[pw_chrono_protos.chrono_pb2.TimePoint] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["armv7m_cpu_state", b"armv7m_cpu_state", "metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["armv7m_cpu_state", b"armv7m_cpu_state", "logs", b"logs", "metadata", b"metadata", "related_snapshots", b"related_snapshots", "tags", b"tags", "threads", b"threads", "timestamps", b"timestamps", "trace_data", b"trace_data"]) -> None: ...

global___Snapshot = Snapshot
