"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class CpuArchitecture(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CpuArchitecture._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: CpuArchitecture._Enum.ValueType  # 0
        ARMV6M: CpuArchitecture._Enum.ValueType  # 1
        ARMV7M: CpuArchitecture._Enum.ValueType  # 2
        ARMV8M: CpuArchitecture._Enum.ValueType  # 3

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNKNOWN: CpuArchitecture.Enum.ValueType  # 0
    ARMV6M: CpuArchitecture.Enum.ValueType  # 1
    ARMV7M: CpuArchitecture.Enum.ValueType  # 2
    ARMV8M: CpuArchitecture.Enum.ValueType  # 3

    def __init__(
        self,
    ) -> None: ...

global___CpuArchitecture = CpuArchitecture

class Metadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REASON_FIELD_NUMBER: builtins.int
    FATAL_FIELD_NUMBER: builtins.int
    PROJECT_NAME_FIELD_NUMBER: builtins.int
    SOFTWARE_VERSION_FIELD_NUMBER: builtins.int
    SOFTWARE_BUILD_UUID_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    SNAPSHOT_UUID_FIELD_NUMBER: builtins.int
    CPU_ARCH_FIELD_NUMBER: builtins.int
    reason: builtins.bytes
    """A relatively unique descriptive reason for what triggered the snapshot
    capture. This should either be human readable text, or tokenized data
    (e.g. base-64 encoded or binary data).

    Examples:
      Null-pointer dereference
      [main.cc:22] True is not false!
      STACK_OVERFLOW
    """
    fatal: builtins.bool
    """Whether or not the snapshot was captured due to a crash of some kind."""
    project_name: builtins.bytes
    """Project name to assist in identifying where to redirect this snapshot. A
    single project might have multiple devices that can produce snapshots.
    """
    software_version: builtins.str
    """Version characters must be alphanumeric, punctuation, and space. This
    string is case-sensitive. This should always be human readable text, and
    does not support tokenization by design. If this field was tokenized, it's
    possible that the token could be lost (e.g. generated by a local developer
    build and not uploaded anywhere) and a firmware version running on a device
    in the field would be left entirely unidentifiable.

    Examples:
      "codename-local-[build_id]"
      "codename-release-193"
    """
    software_build_uuid: builtins.bytes
    """UUID associated with the build for the software version."""
    device_name: builtins.bytes
    """String containing the specific device name. This should be as specific as
    possible, detailing hardware revision, and distinguishing different cores
    in a multi-core device. Snapshots aggregated as related_snapshots should
    include information that distinguishes the source of the snapshot. This
    should either be human readable text, or tokenized data.

    Examples:
      "propellerhat-evk"
      "gshoe-sensor-core-pvt"
      "alarm-clock-dsp-p1"
    """
    snapshot_uuid: builtins.bytes
    """128-bit UUID for this snapshot, used to help with de-duplication."""
    cpu_arch: global___CpuArchitecture.Enum.ValueType
    """The architecture of the CPU that generated this report."""
    def __init__(
        self,
        *,
        reason: builtins.bytes = ...,
        fatal: builtins.bool = ...,
        project_name: builtins.bytes = ...,
        software_version: builtins.str = ...,
        software_build_uuid: builtins.bytes = ...,
        device_name: builtins.bytes = ...,
        snapshot_uuid: builtins.bytes = ...,
        cpu_arch: global___CpuArchitecture.Enum.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu_arch", b"cpu_arch", "device_name", b"device_name", "fatal", b"fatal", "project_name", b"project_name", "reason", b"reason", "snapshot_uuid", b"snapshot_uuid", "software_build_uuid", b"software_build_uuid", "software_version", b"software_version"]) -> None: ...

global___Metadata = Metadata

class SnapshotBasicInfo(google.protobuf.message.Message):
    """This message overlays the pw.snapshot.Snapshot proto. It's valid to encode
    this message to the same sink that a Snapshot proto is being written to.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class TagsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    METADATA_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___Metadata: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        metadata: global___Metadata | None = ...,
        tags: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "tags", b"tags"]) -> None: ...

global___SnapshotBasicInfo = SnapshotBasicInfo
