"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PacketType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PacketTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PacketType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REQUEST: _PacketType.ValueType  # 0
    """Client-to-server packets

    The client invokes an RPC. Always the first packet.
    """
    CLIENT_STREAM: _PacketType.ValueType  # 2
    """A message in a client stream. Always sent after a REQUEST and before a
    CLIENT_REQUEST_COMPLETION.
    """
    CLIENT_ERROR: _PacketType.ValueType  # 4
    """The client received a packet for an RPC it did not request."""
    CLIENT_REQUEST_COMPLETION: _PacketType.ValueType  # 8
    """Client has requested for call completion. In client streaming and
    bi-directional streaming RPCs, this also indicates that the client is done
    with sending requests.
    """
    RESPONSE: _PacketType.ValueType  # 1
    """Server-to-client packets

    The RPC has finished.
    """
    SERVER_ERROR: _PacketType.ValueType  # 5
    """The server was unable to process a request."""
    SERVER_STREAM: _PacketType.ValueType  # 7
    """A message in a server stream."""

class PacketType(_PacketType, metaclass=_PacketTypeEnumTypeWrapper):
    """To simplify identifying the origin of a packet, client-to-server packets
    use even numbers and server-to-client packets use odd numbers.
    """

REQUEST: PacketType.ValueType  # 0
"""Client-to-server packets

The client invokes an RPC. Always the first packet.
"""
CLIENT_STREAM: PacketType.ValueType  # 2
"""A message in a client stream. Always sent after a REQUEST and before a
CLIENT_REQUEST_COMPLETION.
"""
CLIENT_ERROR: PacketType.ValueType  # 4
"""The client received a packet for an RPC it did not request."""
CLIENT_REQUEST_COMPLETION: PacketType.ValueType  # 8
"""Client has requested for call completion. In client streaming and
bi-directional streaming RPCs, this also indicates that the client is done
with sending requests.
"""
RESPONSE: PacketType.ValueType  # 1
"""Server-to-client packets

The RPC has finished.
"""
SERVER_ERROR: PacketType.ValueType  # 5
"""The server was unable to process a request."""
SERVER_STREAM: PacketType.ValueType  # 7
"""A message in a server stream."""
global___PacketType = PacketType

class RpcPacket(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    SERVICE_ID_FIELD_NUMBER: builtins.int
    METHOD_ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CALL_ID_FIELD_NUMBER: builtins.int
    type: global___PacketType.ValueType
    """The type of packet. Determines which other fields are used."""
    channel_id: builtins.int
    """Channel through which the packet is sent."""
    service_id: builtins.int
    """Hash of the fully-qualified name of the service with which this packet is
    associated. For RPC packets, this is the service that processes the packet.
    """
    method_id: builtins.int
    """Hash of the name of the method which should process this packet."""
    payload: builtins.bytes
    """The packet's payload, which is an encoded protobuf."""
    status: builtins.int
    """Status code for the RPC response or error."""
    call_id: builtins.int
    """Unique identifier for the call that initiated this RPC. Optionally set by
    the client in the initial request and sent in all subsequent client
    packets; echoed by the server.
    """
    def __init__(
        self,
        *,
        type: global___PacketType.ValueType = ...,
        channel_id: builtins.int = ...,
        service_id: builtins.int = ...,
        method_id: builtins.int = ...,
        payload: builtins.bytes = ...,
        status: builtins.int = ...,
        call_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["call_id", b"call_id", "channel_id", b"channel_id", "method_id", b"method_id", "payload", b"payload", "service_id", b"service_id", "status", b"status", "type", b"type"]) -> None: ...

global___RpcPacket = RpcPacket
