"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Metric(google.protobuf.message.Message):
    """A metric, described by the name (path + name), and the value.

    This flattened representation, while more complicated than the obvious tree
    structure alternative, enables streaming metrics from the device in low
    memory or low compute situations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_PATH_FIELD_NUMBER: builtins.int
    STRING_PATH_FIELD_NUMBER: builtins.int
    AS_FLOAT_FIELD_NUMBER: builtins.int
    AS_INT_FIELD_NUMBER: builtins.int
    @property
    def token_path(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The token path from the root. The last token is the metric name, and
        previous tokens are the parent group names. This could be converted from
        the tokens into a string; for example the token path {0xfaff, 0xabcd}:

         - The group is 0xfaff (root, parent)
         - The metric is 0xabcd

        Given the token database, this might be converted into:

          /i2c_bus_1/failed_transactions

        Note: This uses a repeated fixed32 instead of a "Oneof" with the string
        path to reduce the encoded size. Using a repeated Oneof name { str,
        fixed32 } would cost approximately 6N bytes for N path elements, vs 2 + 4N
        bytes in the packed case.
        """
    @property
    def string_path(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The string path from the root. Similar to token path, but with strings.
        Note: This is currently unsupported.
        """
    as_float: builtins.float
    as_int: builtins.int
    def __init__(
        self,
        *,
        token_path: collections.abc.Iterable[builtins.int] | None = ...,
        string_path: collections.abc.Iterable[builtins.str] | None = ...,
        as_float: builtins.float = ...,
        as_int: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["as_float", b"as_float", "as_int", b"as_int", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["as_float", b"as_float", "as_int", b"as_int", "string_path", b"string_path", "token_path", b"token_path", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["as_float", "as_int"] | None: ...

global___Metric = Metric

class MetricRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METRICS_FIELD_NUMBER: builtins.int
    @property
    def metrics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Metric]:
        """Metrics or the groups matched to the given paths are returned.  The intent
        is to support matching semantics, with at least subsetting to e.g. collect
        all the metrics in a group and its children. We may also implement
        wildcard matchers.

        Value fields in the metrics will be ignored, since this is a query.

        Note: This is currently unsupported.
        """
    def __init__(
        self,
        *,
        metrics: collections.abc.Iterable[global___Metric] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metrics", b"metrics"]) -> None: ...

global___MetricRequest = MetricRequest

class MetricResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METRICS_FIELD_NUMBER: builtins.int
    @property
    def metrics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Metric]: ...
    def __init__(
        self,
        *,
        metrics: collections.abc.Iterable[global___Metric] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metrics", b"metrics"]) -> None: ...

global___MetricResponse = MetricResponse
