"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2022 The Pigweed Authors

Licensed under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License. You may obtain a copy of
the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations under
the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class EpochType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[EpochType._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: EpochType._Enum.ValueType  # 0
        TIME_SINCE_BOOT: EpochType._Enum.ValueType  # 1
        UTC_WALL_CLOCK: EpochType._Enum.ValueType  # 2
        """Time since 00:00:00 UTC, Thursday, 1 January 1970, including leap
        seconds.
        """
        GPS_WALL_CLOCK: EpochType._Enum.ValueType  # 3
        """Time since 00:00:00, 6 January 1980 UTC. Leap seconds are not inserted
        into GPS. Thus, every time a leap second is inserted into UTC, UTC
        falls another second behind GPS.
        """
        TAI_WALL_CLOCK: EpochType._Enum.ValueType  # 4
        """Time since 00:00:00, 1 January 1958, and is offset 10 seconds ahead of
        UTC at that date (i.e., its epoch, 1958-01-01 00:00:00 TAI, is
        1957-12-31 23:59:50 UTC). Leap seconds are not inserted into TAI. Thus,
        every time a leap second is inserted into UTC, UTC falls another second
        behind TAI.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNKNOWN: EpochType.Enum.ValueType  # 0
    TIME_SINCE_BOOT: EpochType.Enum.ValueType  # 1
    UTC_WALL_CLOCK: EpochType.Enum.ValueType  # 2
    """Time since 00:00:00 UTC, Thursday, 1 January 1970, including leap
    seconds.
    """
    GPS_WALL_CLOCK: EpochType.Enum.ValueType  # 3
    """Time since 00:00:00, 6 January 1980 UTC. Leap seconds are not inserted
    into GPS. Thus, every time a leap second is inserted into UTC, UTC
    falls another second behind GPS.
    """
    TAI_WALL_CLOCK: EpochType.Enum.ValueType  # 4
    """Time since 00:00:00, 1 January 1958, and is offset 10 seconds ahead of
    UTC at that date (i.e., its epoch, 1958-01-01 00:00:00 TAI, is
    1957-12-31 23:59:50 UTC). Leap seconds are not inserted into TAI. Thus,
    every time a leap second is inserted into UTC, UTC falls another second
    behind TAI.
    """

    def __init__(
        self,
    ) -> None: ...

global___EpochType = EpochType

class ClockParameters(google.protobuf.message.Message):
    """A representation of a clock's parameters.

    There are two major components to representing a steady, monotonic clock:

      1. A representation of the clock's period.
      2. A representation of the clock's epoch.

    To support a wide range of clock configurations, ClockParameters represents
    a clock's period as fractions of a second. Concretely:

      Clock period (seconds) =
          tick_period_seconds_numerator / tick_period_seconds_denominator

    So a simple 1KHz clock can be represented as:

      tick_period_seconds_numerator = 1
      tick_period_seconds_denominator = 1000
      Clock period = 1 / 1000 = 0.001 seconds
      Clock frequency = 1 / 0.001 = 1,000 Hz

    Failing to specify one or both of the period members of a ClockParameters
    message leaves the configuration specification incomplete and invalid.

    While clock period alone is enough to represent a duration if given a number
    of ticks, an epoch is required to make a clock represent a time point.
    EpochType optionally provides this information. Specifying an EpochType
    defines what a tick count of `0` represents. Some epoch types (e.g. UTC, GPS,
    TAI) allow the clock to resolve to real-world time points. If the EpochType
    is relative to boot or unknown, however, the clock is only sufficiently
    specified for relative time measurement without additional external
    information.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TICK_PERIOD_SECONDS_NUMERATOR_FIELD_NUMBER: builtins.int
    TICK_PERIOD_SECONDS_DENOMINATOR_FIELD_NUMBER: builtins.int
    EPOCH_TYPE_FIELD_NUMBER: builtins.int
    tick_period_seconds_numerator: builtins.int
    """Required"""
    tick_period_seconds_denominator: builtins.int
    """Required"""
    epoch_type: global___EpochType.Enum.ValueType
    def __init__(
        self,
        *,
        tick_period_seconds_numerator: builtins.int = ...,
        tick_period_seconds_denominator: builtins.int = ...,
        epoch_type: global___EpochType.Enum.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_epoch_type", b"_epoch_type", "epoch_type", b"epoch_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_epoch_type", b"_epoch_type", "epoch_type", b"epoch_type", "tick_period_seconds_denominator", b"tick_period_seconds_denominator", "tick_period_seconds_numerator", b"tick_period_seconds_numerator"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_epoch_type", b"_epoch_type"]) -> typing_extensions.Literal["epoch_type"] | None: ...

global___ClockParameters = ClockParameters

class TimePoint(google.protobuf.message.Message):
    """A point in time relative to a clock's epoch."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    CLOCK_PARAMETERS_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """The duration that has elapsed (number of clock ticks) since the epoch,
    where the tick period and epoch are specified by the clock parameters.

    The meaning of `timestamp` is unspecified without an associated
    ClockParameters.
    Required
    """
    @property
    def clock_parameters(self) -> global___ClockParameters:
        """Required"""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        clock_parameters: global___ClockParameters | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["clock_parameters", b"clock_parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["clock_parameters", b"clock_parameters", "timestamp", b"timestamp"]) -> None: ...

global___TimePoint = TimePoint

class SnapshotTimestamps(google.protobuf.message.Message):
    """The time of a snapshot capture. Supports multiple timestamps to
    cover multiple time bases or clocks (e.g. time since boot, time
    from epoch, etc).

    This is an overlay proto for Snapshot, see more details here:
    https://pigweed.dev/pw_snapshot/proto_format.html#module-specific-data
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMPS_FIELD_NUMBER: builtins.int
    @property
    def timestamps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TimePoint]: ...
    def __init__(
        self,
        *,
        timestamps: collections.abc.Iterable[global___TimePoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["timestamps", b"timestamps"]) -> None: ...

global___SnapshotTimestamps = SnapshotTimestamps
