# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotRepositoryArgs', 'SnapshotRepository']

@pulumi.input_type
class SnapshotRepositoryArgs:
    def __init__(__self__, *,
                 azure: Optional[pulumi.Input['SnapshotRepositoryAzureArgs']] = None,
                 elasticsearch_connection: Optional[pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs']] = None,
                 fs: Optional[pulumi.Input['SnapshotRepositoryFsArgs']] = None,
                 gcs: Optional[pulumi.Input['SnapshotRepositoryGcsArgs']] = None,
                 hdfs: Optional[pulumi.Input['SnapshotRepositoryHdfsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input['SnapshotRepositoryS3Args']] = None,
                 url: Optional[pulumi.Input['SnapshotRepositoryUrlArgs']] = None,
                 verify: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SnapshotRepository resource.
        :param pulumi.Input['SnapshotRepositoryAzureArgs'] azure: Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        :param pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input['SnapshotRepositoryFsArgs'] fs: Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        :param pulumi.Input['SnapshotRepositoryGcsArgs'] gcs: Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        :param pulumi.Input['SnapshotRepositoryHdfsArgs'] hdfs: Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        :param pulumi.Input[str] name: Name of the snapshot repository to register or update.
        :param pulumi.Input['SnapshotRepositoryS3Args'] s3: Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        :param pulumi.Input['SnapshotRepositoryUrlArgs'] url: URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        :param pulumi.Input[bool] verify: If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if fs is not None:
            pulumi.set(__self__, "fs", fs)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if hdfs is not None:
            pulumi.set(__self__, "hdfs", hdfs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['SnapshotRepositoryAzureArgs']]:
        """
        Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['SnapshotRepositoryAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def fs(self) -> Optional[pulumi.Input['SnapshotRepositoryFsArgs']]:
        """
        Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        """
        return pulumi.get(self, "fs")

    @fs.setter
    def fs(self, value: Optional[pulumi.Input['SnapshotRepositoryFsArgs']]):
        pulumi.set(self, "fs", value)

    @property
    @pulumi.getter
    def gcs(self) -> Optional[pulumi.Input['SnapshotRepositoryGcsArgs']]:
        """
        Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        """
        return pulumi.get(self, "gcs")

    @gcs.setter
    def gcs(self, value: Optional[pulumi.Input['SnapshotRepositoryGcsArgs']]):
        pulumi.set(self, "gcs", value)

    @property
    @pulumi.getter
    def hdfs(self) -> Optional[pulumi.Input['SnapshotRepositoryHdfsArgs']]:
        """
        Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        """
        return pulumi.get(self, "hdfs")

    @hdfs.setter
    def hdfs(self, value: Optional[pulumi.Input['SnapshotRepositoryHdfsArgs']]):
        pulumi.set(self, "hdfs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the snapshot repository to register or update.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['SnapshotRepositoryS3Args']]:
        """
        Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['SnapshotRepositoryS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input['SnapshotRepositoryUrlArgs']]:
        """
        URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input['SnapshotRepositoryUrlArgs']]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)


@pulumi.input_type
class _SnapshotRepositoryState:
    def __init__(__self__, *,
                 azure: Optional[pulumi.Input['SnapshotRepositoryAzureArgs']] = None,
                 elasticsearch_connection: Optional[pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs']] = None,
                 fs: Optional[pulumi.Input['SnapshotRepositoryFsArgs']] = None,
                 gcs: Optional[pulumi.Input['SnapshotRepositoryGcsArgs']] = None,
                 hdfs: Optional[pulumi.Input['SnapshotRepositoryHdfsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input['SnapshotRepositoryS3Args']] = None,
                 url: Optional[pulumi.Input['SnapshotRepositoryUrlArgs']] = None,
                 verify: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SnapshotRepository resources.
        :param pulumi.Input['SnapshotRepositoryAzureArgs'] azure: Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        :param pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input['SnapshotRepositoryFsArgs'] fs: Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        :param pulumi.Input['SnapshotRepositoryGcsArgs'] gcs: Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        :param pulumi.Input['SnapshotRepositoryHdfsArgs'] hdfs: Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        :param pulumi.Input[str] name: Name of the snapshot repository to register or update.
        :param pulumi.Input['SnapshotRepositoryS3Args'] s3: Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        :param pulumi.Input['SnapshotRepositoryUrlArgs'] url: URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        :param pulumi.Input[bool] verify: If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if fs is not None:
            pulumi.set(__self__, "fs", fs)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if hdfs is not None:
            pulumi.set(__self__, "hdfs", hdfs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['SnapshotRepositoryAzureArgs']]:
        """
        Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['SnapshotRepositoryAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SnapshotRepositoryElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def fs(self) -> Optional[pulumi.Input['SnapshotRepositoryFsArgs']]:
        """
        Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        """
        return pulumi.get(self, "fs")

    @fs.setter
    def fs(self, value: Optional[pulumi.Input['SnapshotRepositoryFsArgs']]):
        pulumi.set(self, "fs", value)

    @property
    @pulumi.getter
    def gcs(self) -> Optional[pulumi.Input['SnapshotRepositoryGcsArgs']]:
        """
        Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        """
        return pulumi.get(self, "gcs")

    @gcs.setter
    def gcs(self, value: Optional[pulumi.Input['SnapshotRepositoryGcsArgs']]):
        pulumi.set(self, "gcs", value)

    @property
    @pulumi.getter
    def hdfs(self) -> Optional[pulumi.Input['SnapshotRepositoryHdfsArgs']]:
        """
        Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        """
        return pulumi.get(self, "hdfs")

    @hdfs.setter
    def hdfs(self, value: Optional[pulumi.Input['SnapshotRepositoryHdfsArgs']]):
        pulumi.set(self, "hdfs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the snapshot repository to register or update.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['SnapshotRepositoryS3Args']]:
        """
        Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['SnapshotRepositoryS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input['SnapshotRepositoryUrlArgs']]:
        """
        URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input['SnapshotRepositoryUrlArgs']]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)


class SnapshotRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryAzureArgs']]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryElasticsearchConnectionArgs']]] = None,
                 fs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryFsArgs']]] = None,
                 gcs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryGcsArgs']]] = None,
                 hdfs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryHdfsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryS3Args']]] = None,
                 url: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryUrlArgs']]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Registers or updates a snapshot repository. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/put-snapshot-repo-api.html and https://www.elastic.co/guide/en/elasticsearch/reference/current/snapshots-register-repository.html

        ## Example Usage

        ```python
        import pulumi
        import pulumi_elasticstack as elasticstack

        my_url_repo = elasticstack.SnapshotRepository("myUrlRepo", url=elasticstack.SnapshotRepositoryUrlArgs(
            url="https://example.com/repo",
        ))
        my_fs_repo = elasticstack.SnapshotRepository("myFsRepo", fs=elasticstack.SnapshotRepositoryFsArgs(
            compress=True,
            location="/tmp",
            max_restore_bytes_per_sec="10mb",
        ))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/snapshotRepository:SnapshotRepository my_repository <cluster_uuid>/<repository name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryAzureArgs']] azure: Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryFsArgs']] fs: Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryGcsArgs']] gcs: Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryHdfsArgs']] hdfs: Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        :param pulumi.Input[str] name: Name of the snapshot repository to register or update.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryS3Args']] s3: Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryUrlArgs']] url: URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        :param pulumi.Input[bool] verify: If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SnapshotRepositoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Registers or updates a snapshot repository. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/put-snapshot-repo-api.html and https://www.elastic.co/guide/en/elasticsearch/reference/current/snapshots-register-repository.html

        ## Example Usage

        ```python
        import pulumi
        import pulumi_elasticstack as elasticstack

        my_url_repo = elasticstack.SnapshotRepository("myUrlRepo", url=elasticstack.SnapshotRepositoryUrlArgs(
            url="https://example.com/repo",
        ))
        my_fs_repo = elasticstack.SnapshotRepository("myFsRepo", fs=elasticstack.SnapshotRepositoryFsArgs(
            compress=True,
            location="/tmp",
            max_restore_bytes_per_sec="10mb",
        ))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/snapshotRepository:SnapshotRepository my_repository <cluster_uuid>/<repository name>
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryAzureArgs']]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryElasticsearchConnectionArgs']]] = None,
                 fs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryFsArgs']]] = None,
                 gcs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryGcsArgs']]] = None,
                 hdfs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryHdfsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryS3Args']]] = None,
                 url: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryUrlArgs']]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotRepositoryArgs.__new__(SnapshotRepositoryArgs)

            __props__.__dict__["azure"] = azure
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["fs"] = fs
            __props__.__dict__["gcs"] = gcs
            __props__.__dict__["hdfs"] = hdfs
            __props__.__dict__["name"] = name
            __props__.__dict__["s3"] = s3
            __props__.__dict__["url"] = url
            __props__.__dict__["verify"] = verify
        super(SnapshotRepository, __self__).__init__(
            'elasticstack:index/snapshotRepository:SnapshotRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryAzureArgs']]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryElasticsearchConnectionArgs']]] = None,
            fs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryFsArgs']]] = None,
            gcs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryGcsArgs']]] = None,
            hdfs: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryHdfsArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            s3: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryS3Args']]] = None,
            url: Optional[pulumi.Input[pulumi.InputType['SnapshotRepositoryUrlArgs']]] = None,
            verify: Optional[pulumi.Input[bool]] = None) -> 'SnapshotRepository':
        """
        Get an existing SnapshotRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryAzureArgs']] azure: Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryFsArgs']] fs: Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryGcsArgs']] gcs: Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryHdfsArgs']] hdfs: Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        :param pulumi.Input[str] name: Name of the snapshot repository to register or update.
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryS3Args']] s3: Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        :param pulumi.Input[pulumi.InputType['SnapshotRepositoryUrlArgs']] url: URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        :param pulumi.Input[bool] verify: If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotRepositoryState.__new__(_SnapshotRepositoryState)

        __props__.__dict__["azure"] = azure
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["fs"] = fs
        __props__.__dict__["gcs"] = gcs
        __props__.__dict__["hdfs"] = hdfs
        __props__.__dict__["name"] = name
        __props__.__dict__["s3"] = s3
        __props__.__dict__["url"] = url
        __props__.__dict__["verify"] = verify
        return SnapshotRepository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def azure(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryAzure']]:
        """
        Support for using Azure Blob storage as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-azure.html
        """
        return pulumi.get(self, "azure")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def fs(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryFs']]:
        """
        Shared filesystem repository. Repositories of this type use a shared filesystem to store snapshots. This filesystem must be accessible to all master and data nodes in the cluster.
        """
        return pulumi.get(self, "fs")

    @property
    @pulumi.getter
    def gcs(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryGcs']]:
        """
        Support for using the Google Cloud Storage service as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-gcs.html
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def hdfs(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryHdfs']]:
        """
        Support for using HDFS File System as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-hdfs.html
        """
        return pulumi.get(self, "hdfs")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the snapshot repository to register or update.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryS3']]:
        """
        Support for using AWS S3 as a repository for Snapshot/Restore. See: https://www.elastic.co/guide/en/elasticsearch/plugins/current/repository-s3-repository.html
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional['outputs.SnapshotRepositoryUrl']]:
        """
        URL repository. Repositories of this type are read-only for the cluster. This means the cluster can retrieve or restore snapshots from the repository but cannot write or create snapshots in it.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def verify(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the request verifies the repository is functional on all master and data nodes in the cluster.
        """
        return pulumi.get(self, "verify")

