# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityRoleArgs', 'SecurityRole']

@pulumi.input_type
class SecurityRoleArgs:
    def __init__(__self__, *,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['SecurityRoleElasticsearchConnectionArgs']] = None,
                 global_: Optional[pulumi.Input[str]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 run_as: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SecurityRole resource.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]] applications: A list of application privilege entries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusters: A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        :param pulumi.Input['SecurityRoleElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] global_: An object defining global privileges.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]] indices: A list of indices permissions entries.
        :param pulumi.Input[str] metadata: Optional meta-data.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] run_as: A list of users that the owners of this role can impersonate.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if run_as is not None:
            pulumi.set(__self__, "run_as", run_as)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]]]:
        """
        A list of application privilege entries.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "clusters", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SecurityRoleElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SecurityRoleElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input[str]]:
        """
        An object defining global privileges.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]]]:
        """
        A list of indices permissions entries.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional meta-data.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users that the owners of this role can impersonate.
        """
        return pulumi.get(self, "run_as")

    @run_as.setter
    def run_as(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "run_as", value)


@pulumi.input_type
class _SecurityRoleState:
    def __init__(__self__, *,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['SecurityRoleElasticsearchConnectionArgs']] = None,
                 global_: Optional[pulumi.Input[str]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 run_as: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SecurityRole resources.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]] applications: A list of application privilege entries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusters: A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        :param pulumi.Input['SecurityRoleElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] global_: An object defining global privileges.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]] indices: A list of indices permissions entries.
        :param pulumi.Input[str] metadata: Optional meta-data.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] run_as: A list of users that the owners of this role can impersonate.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if run_as is not None:
            pulumi.set(__self__, "run_as", run_as)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]]]:
        """
        A list of application privilege entries.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "clusters", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SecurityRoleElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SecurityRoleElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input[str]]:
        """
        An object defining global privileges.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]]]:
        """
        A list of indices permissions entries.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityRoleIndexArgs']]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional meta-data.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users that the owners of this role can impersonate.
        """
        return pulumi.get(self, "run_as")

    @run_as.setter
    def run_as(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "run_as", value)


class SecurityRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleApplicationArgs']]]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityRoleElasticsearchConnectionArgs']]] = None,
                 global_: Optional[pulumi.Input[str]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleIndexArgs']]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 run_as: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Adds and updates roles in the native realm. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-role.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        role_security_role = elasticstack.SecurityRole("roleSecurityRole",
            clusters=["all"],
            indices=[elasticstack.SecurityRoleIndexArgs(
                names=[
                    "index1",
                    "index2",
                ],
                privileges=["all"],
            )],
            applications=[elasticstack.SecurityRoleApplicationArgs(
                application="myapp",
                privileges=[
                    "admin",
                    "read",
                ],
                resources=["*"],
            )],
            run_as=["other_user"],
            metadata=json.dumps({
                "version": 1,
            }))
        pulumi.export("role", role_security_role)
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/securityRole:SecurityRole my_role <cluster_uuid>/<role name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleApplicationArgs']]]] applications: A list of application privilege entries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusters: A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        :param pulumi.Input[pulumi.InputType['SecurityRoleElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] global_: An object defining global privileges.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleIndexArgs']]]] indices: A list of indices permissions entries.
        :param pulumi.Input[str] metadata: Optional meta-data.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] run_as: A list of users that the owners of this role can impersonate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityRoleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds and updates roles in the native realm. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-put-role.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        role_security_role = elasticstack.SecurityRole("roleSecurityRole",
            clusters=["all"],
            indices=[elasticstack.SecurityRoleIndexArgs(
                names=[
                    "index1",
                    "index2",
                ],
                privileges=["all"],
            )],
            applications=[elasticstack.SecurityRoleApplicationArgs(
                application="myapp",
                privileges=[
                    "admin",
                    "read",
                ],
                resources=["*"],
            )],
            run_as=["other_user"],
            metadata=json.dumps({
                "version": 1,
            }))
        pulumi.export("role", role_security_role)
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/securityRole:SecurityRole my_role <cluster_uuid>/<role name>
        ```

        :param str resource_name: The name of the resource.
        :param SecurityRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleApplicationArgs']]]]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityRoleElasticsearchConnectionArgs']]] = None,
                 global_: Optional[pulumi.Input[str]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleIndexArgs']]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 run_as: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityRoleArgs.__new__(SecurityRoleArgs)

            __props__.__dict__["applications"] = applications
            __props__.__dict__["clusters"] = clusters
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["global_"] = global_
            __props__.__dict__["indices"] = indices
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["run_as"] = run_as
        super(SecurityRole, __self__).__init__(
            'elasticstack:index/securityRole:SecurityRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleApplicationArgs']]]]] = None,
            clusters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityRoleElasticsearchConnectionArgs']]] = None,
            global_: Optional[pulumi.Input[str]] = None,
            indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleIndexArgs']]]]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            run_as: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SecurityRole':
        """
        Get an existing SecurityRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleApplicationArgs']]]] applications: A list of application privilege entries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] clusters: A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        :param pulumi.Input[pulumi.InputType['SecurityRoleElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] global_: An object defining global privileges.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityRoleIndexArgs']]]] indices: A list of indices permissions entries.
        :param pulumi.Input[str] metadata: Optional meta-data.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] run_as: A list of users that the owners of this role can impersonate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityRoleState.__new__(_SecurityRoleState)

        __props__.__dict__["applications"] = applications
        __props__.__dict__["clusters"] = clusters
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["global_"] = global_
        __props__.__dict__["indices"] = indices
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["run_as"] = run_as
        return SecurityRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityRoleApplication']]]:
        """
        A list of application privilege entries.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def clusters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.SecurityRoleElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter(name="global")
    def global_(self) -> pulumi.Output[Optional[str]]:
        """
        An object defining global privileges.
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def indices(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityRoleIndex']]]:
        """
        A list of indices permissions entries.
        """
        return pulumi.get(self, "indices")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        Optional meta-data.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of users that the owners of this role can impersonate.
        """
        return pulumi.get(self, "run_as")

