# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityApiKeyArgs', 'SecurityApiKey']

@pulumi.input_type
class SecurityApiKeyArgs:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs']] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_descriptors: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityApiKey resource.
        :param pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] expiration: Expiration time for the API key. By default, API keys never expire.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the API key.
        :param pulumi.Input[str] name: Specifies the name for this API key.
        :param pulumi.Input[str] role_descriptors: Role descriptors for this API key.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_descriptors is not None:
            pulumi.set(__self__, "role_descriptors", role_descriptors)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration time for the API key. By default, API keys never expire.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary metadata that you want to associate with the API key.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name for this API key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleDescriptors")
    def role_descriptors(self) -> Optional[pulumi.Input[str]]:
        """
        Role descriptors for this API key.
        """
        return pulumi.get(self, "role_descriptors")

    @role_descriptors.setter
    def role_descriptors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_descriptors", value)


@pulumi.input_type
class _SecurityApiKeyState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs']] = None,
                 encoded: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 expiration_timestamp: Optional[pulumi.Input[int]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_descriptors: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityApiKey resources.
        :param pulumi.Input[str] api_key: Generated API Key.
        :param pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] encoded: API key credentials which is the Base64-encoding of the UTF-8 representation of the id and api_key joined by a colon (:).
        :param pulumi.Input[str] expiration: Expiration time for the API key. By default, API keys never expire.
        :param pulumi.Input[int] expiration_timestamp: Expiration time in milliseconds for the API key. By default, API keys never expire.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the API key.
        :param pulumi.Input[str] name: Specifies the name for this API key.
        :param pulumi.Input[str] role_descriptors: Role descriptors for this API key.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if encoded is not None:
            pulumi.set(__self__, "encoded", encoded)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if expiration_timestamp is not None:
            pulumi.set(__self__, "expiration_timestamp", expiration_timestamp)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_descriptors is not None:
            pulumi.set(__self__, "role_descriptors", role_descriptors)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        Generated API Key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['SecurityApiKeyElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def encoded(self) -> Optional[pulumi.Input[str]]:
        """
        API key credentials which is the Base64-encoding of the UTF-8 representation of the id and api_key joined by a colon (:).
        """
        return pulumi.get(self, "encoded")

    @encoded.setter
    def encoded(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration time for the API key. By default, API keys never expire.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter(name="expirationTimestamp")
    def expiration_timestamp(self) -> Optional[pulumi.Input[int]]:
        """
        Expiration time in milliseconds for the API key. By default, API keys never expire.
        """
        return pulumi.get(self, "expiration_timestamp")

    @expiration_timestamp.setter
    def expiration_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_timestamp", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary metadata that you want to associate with the API key.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name for this API key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleDescriptors")
    def role_descriptors(self) -> Optional[pulumi.Input[str]]:
        """
        Role descriptors for this API key.
        """
        return pulumi.get(self, "role_descriptors")

    @role_descriptors.setter
    def role_descriptors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_descriptors", value)


class SecurityApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityApiKeyElasticsearchConnectionArgs']]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_descriptors: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an API key for access without requiring basic authentication. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-create-api-key.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        api_key_security_api_key = elasticstack.SecurityApiKey("apiKeySecurityApiKey",
            role_descriptors=json.dumps({
                "role-a": {
                    "cluster": ["all"],
                    "indices": [{
                        "names": ["index-a*"],
                        "privileges": ["read"],
                    }],
                },
            }),
            expiration="1d",
            metadata=json.dumps({
                "env": "testing",
                "open": False,
                "number": 49,
            }))
        pulumi.export("apiKey", api_key_security_api_key)
        ```

        ## Import

        Import is not supported due to the generated API key only being visible on create.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SecurityApiKeyElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] expiration: Expiration time for the API key. By default, API keys never expire.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the API key.
        :param pulumi.Input[str] name: Specifies the name for this API key.
        :param pulumi.Input[str] role_descriptors: Role descriptors for this API key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityApiKeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an API key for access without requiring basic authentication. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-create-api-key.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        api_key_security_api_key = elasticstack.SecurityApiKey("apiKeySecurityApiKey",
            role_descriptors=json.dumps({
                "role-a": {
                    "cluster": ["all"],
                    "indices": [{
                        "names": ["index-a*"],
                        "privileges": ["read"],
                    }],
                },
            }),
            expiration="1d",
            metadata=json.dumps({
                "env": "testing",
                "open": False,
                "number": 49,
            }))
        pulumi.export("apiKey", api_key_security_api_key)
        ```

        ## Import

        Import is not supported due to the generated API key only being visible on create.

        :param str resource_name: The name of the resource.
        :param SecurityApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityApiKeyElasticsearchConnectionArgs']]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_descriptors: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityApiKeyArgs.__new__(SecurityApiKeyArgs)

            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["expiration"] = expiration
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["role_descriptors"] = role_descriptors
            __props__.__dict__["api_key"] = None
            __props__.__dict__["encoded"] = None
            __props__.__dict__["expiration_timestamp"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "encoded"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecurityApiKey, __self__).__init__(
            'elasticstack:index/securityApiKey:SecurityApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['SecurityApiKeyElasticsearchConnectionArgs']]] = None,
            encoded: Optional[pulumi.Input[str]] = None,
            expiration: Optional[pulumi.Input[str]] = None,
            expiration_timestamp: Optional[pulumi.Input[int]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            role_descriptors: Optional[pulumi.Input[str]] = None) -> 'SecurityApiKey':
        """
        Get an existing SecurityApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: Generated API Key.
        :param pulumi.Input[pulumi.InputType['SecurityApiKeyElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] encoded: API key credentials which is the Base64-encoding of the UTF-8 representation of the id and api_key joined by a colon (:).
        :param pulumi.Input[str] expiration: Expiration time for the API key. By default, API keys never expire.
        :param pulumi.Input[int] expiration_timestamp: Expiration time in milliseconds for the API key. By default, API keys never expire.
        :param pulumi.Input[str] metadata: Arbitrary metadata that you want to associate with the API key.
        :param pulumi.Input[str] name: Specifies the name for this API key.
        :param pulumi.Input[str] role_descriptors: Role descriptors for this API key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityApiKeyState.__new__(_SecurityApiKeyState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["encoded"] = encoded
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["expiration_timestamp"] = expiration_timestamp
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["role_descriptors"] = role_descriptors
        return SecurityApiKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        Generated API Key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.SecurityApiKeyElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def encoded(self) -> pulumi.Output[str]:
        """
        API key credentials which is the Base64-encoding of the UTF-8 representation of the id and api_key joined by a colon (:).
        """
        return pulumi.get(self, "encoded")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[Optional[str]]:
        """
        Expiration time for the API key. By default, API keys never expire.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="expirationTimestamp")
    def expiration_timestamp(self) -> pulumi.Output[int]:
        """
        Expiration time in milliseconds for the API key. By default, API keys never expire.
        """
        return pulumi.get(self, "expiration_timestamp")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        Arbitrary metadata that you want to associate with the API key.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name for this API key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleDescriptors")
    def role_descriptors(self) -> pulumi.Output[Optional[str]]:
        """
        Role descriptors for this API key.
        """
        return pulumi.get(self, "role_descriptors")

