# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorUriPartsResult',
    'AwaitableIngestProcessorUriPartsResult',
    'ingest_processor_uri_parts',
    'ingest_processor_uri_parts_output',
]

@pulumi.output_type
class IngestProcessorUriPartsResult:
    """
    A collection of values returned by IngestProcessorUriParts.
    """
    def __init__(__self__, description=None, field=None, id=None, if_=None, ignore_failure=None, json=None, keep_original=None, on_failures=None, remove_if_successful=None, tag=None, target_field=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if field and not isinstance(field, str):
            raise TypeError("Expected argument 'field' to be a str")
        pulumi.set(__self__, "field", field)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if if_ and not isinstance(if_, str):
            raise TypeError("Expected argument 'if_' to be a str")
        pulumi.set(__self__, "if_", if_)
        if ignore_failure and not isinstance(ignore_failure, bool):
            raise TypeError("Expected argument 'ignore_failure' to be a bool")
        pulumi.set(__self__, "ignore_failure", ignore_failure)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if keep_original and not isinstance(keep_original, bool):
            raise TypeError("Expected argument 'keep_original' to be a bool")
        pulumi.set(__self__, "keep_original", keep_original)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if remove_if_successful and not isinstance(remove_if_successful, bool):
            raise TypeError("Expected argument 'remove_if_successful' to be a bool")
        pulumi.set(__self__, "remove_if_successful", remove_if_successful)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if target_field and not isinstance(target_field, str):
            raise TypeError("Expected argument 'target_field' to be a str")
        pulumi.set(__self__, "target_field", target_field)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the processor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        Field containing the URI string.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="if")
    def if_(self) -> Optional[str]:
        """
        Conditionally execute the processor
        """
        return pulumi.get(self, "if_")

    @property
    @pulumi.getter(name="ignoreFailure")
    def ignore_failure(self) -> Optional[bool]:
        """
        Ignore failures for the processor.
        """
        return pulumi.get(self, "ignore_failure")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="keepOriginal")
    def keep_original(self) -> Optional[bool]:
        """
        If true, the processor copies the unparsed URI to `<target_field>.original.`
        """
        return pulumi.get(self, "keep_original")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[Sequence[str]]:
        """
        Handle failures for the processor.
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter(name="removeIfSuccessful")
    def remove_if_successful(self) -> Optional[bool]:
        """
        If `true`, the processor removes the `field` after parsing the URI string. If parsing fails, the processor does not remove the `field`.
        """
        return pulumi.get(self, "remove_if_successful")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Identifier for the processor.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="targetField")
    def target_field(self) -> Optional[str]:
        """
        Output field for the URI object.
        """
        return pulumi.get(self, "target_field")


class AwaitableIngestProcessorUriPartsResult(IngestProcessorUriPartsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorUriPartsResult(
            description=self.description,
            field=self.field,
            id=self.id,
            if_=self.if_,
            ignore_failure=self.ignore_failure,
            json=self.json,
            keep_original=self.keep_original,
            on_failures=self.on_failures,
            remove_if_successful=self.remove_if_successful,
            tag=self.tag,
            target_field=self.target_field)


def ingest_processor_uri_parts(description: Optional[str] = None,
                               field: Optional[str] = None,
                               if_: Optional[str] = None,
                               ignore_failure: Optional[bool] = None,
                               keep_original: Optional[bool] = None,
                               on_failures: Optional[Sequence[str]] = None,
                               remove_if_successful: Optional[bool] = None,
                               tag: Optional[str] = None,
                               target_field: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorUriPartsResult:
    """
    Parses a Uniform Resource Identifier (URI) string and extracts its components as an object. This URI object includes properties for the URI’s domain, path, fragment, port, query, scheme, user info, username, and password.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/uri-parts-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    parts = elasticstack.ingest_processor_uri_parts(field="input_field",
        target_field="url",
        keep_original=True,
        remove_if_successful=False)
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[parts.json])
    ```


    :param str description: Description of the processor.
    :param str field: Field containing the URI string.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool keep_original: If true, the processor copies the unparsed URI to `<target_field>.original.`
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param bool remove_if_successful: If `true`, the processor removes the `field` after parsing the URI string. If parsing fails, the processor does not remove the `field`.
    :param str tag: Identifier for the processor.
    :param str target_field: Output field for the URI object.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['field'] = field
    __args__['if'] = if_
    __args__['ignoreFailure'] = ignore_failure
    __args__['keepOriginal'] = keep_original
    __args__['onFailures'] = on_failures
    __args__['removeIfSuccessful'] = remove_if_successful
    __args__['tag'] = tag
    __args__['targetField'] = target_field
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorUriParts:IngestProcessorUriParts', __args__, opts=opts, typ=IngestProcessorUriPartsResult).value

    return AwaitableIngestProcessorUriPartsResult(
        description=__ret__.description,
        field=__ret__.field,
        id=__ret__.id,
        if_=__ret__.if_,
        ignore_failure=__ret__.ignore_failure,
        json=__ret__.json,
        keep_original=__ret__.keep_original,
        on_failures=__ret__.on_failures,
        remove_if_successful=__ret__.remove_if_successful,
        tag=__ret__.tag,
        target_field=__ret__.target_field)


@_utilities.lift_output_func(ingest_processor_uri_parts)
def ingest_processor_uri_parts_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                                      field: Optional[pulumi.Input[str]] = None,
                                      if_: Optional[pulumi.Input[Optional[str]]] = None,
                                      ignore_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                                      keep_original: Optional[pulumi.Input[Optional[bool]]] = None,
                                      on_failures: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      remove_if_successful: Optional[pulumi.Input[Optional[bool]]] = None,
                                      tag: Optional[pulumi.Input[Optional[str]]] = None,
                                      target_field: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorUriPartsResult]:
    """
    Parses a Uniform Resource Identifier (URI) string and extracts its components as an object. This URI object includes properties for the URI’s domain, path, fragment, port, query, scheme, user info, username, and password.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/uri-parts-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    parts = elasticstack.ingest_processor_uri_parts(field="input_field",
        target_field="url",
        keep_original=True,
        remove_if_successful=False)
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[parts.json])
    ```


    :param str description: Description of the processor.
    :param str field: Field containing the URI string.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool keep_original: If true, the processor copies the unparsed URI to `<target_field>.original.`
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param bool remove_if_successful: If `true`, the processor removes the `field` after parsing the URI string. If parsing fails, the processor does not remove the `field`.
    :param str tag: Identifier for the processor.
    :param str target_field: Output field for the URI object.
    """
    ...
