# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorKvResult',
    'AwaitableIngestProcessorKvResult',
    'ingest_processor_kv',
    'ingest_processor_kv_output',
]

@pulumi.output_type
class IngestProcessorKvResult:
    """
    A collection of values returned by IngestProcessorKv.
    """
    def __init__(__self__, description=None, exclude_keys=None, field=None, field_split=None, id=None, if_=None, ignore_failure=None, ignore_missing=None, include_keys=None, json=None, on_failures=None, prefix=None, strip_brackets=None, tag=None, target_field=None, trim_key=None, trim_value=None, value_split=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if exclude_keys and not isinstance(exclude_keys, list):
            raise TypeError("Expected argument 'exclude_keys' to be a list")
        pulumi.set(__self__, "exclude_keys", exclude_keys)
        if field and not isinstance(field, str):
            raise TypeError("Expected argument 'field' to be a str")
        pulumi.set(__self__, "field", field)
        if field_split and not isinstance(field_split, str):
            raise TypeError("Expected argument 'field_split' to be a str")
        pulumi.set(__self__, "field_split", field_split)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if if_ and not isinstance(if_, str):
            raise TypeError("Expected argument 'if_' to be a str")
        pulumi.set(__self__, "if_", if_)
        if ignore_failure and not isinstance(ignore_failure, bool):
            raise TypeError("Expected argument 'ignore_failure' to be a bool")
        pulumi.set(__self__, "ignore_failure", ignore_failure)
        if ignore_missing and not isinstance(ignore_missing, bool):
            raise TypeError("Expected argument 'ignore_missing' to be a bool")
        pulumi.set(__self__, "ignore_missing", ignore_missing)
        if include_keys and not isinstance(include_keys, list):
            raise TypeError("Expected argument 'include_keys' to be a list")
        pulumi.set(__self__, "include_keys", include_keys)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if strip_brackets and not isinstance(strip_brackets, bool):
            raise TypeError("Expected argument 'strip_brackets' to be a bool")
        pulumi.set(__self__, "strip_brackets", strip_brackets)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if target_field and not isinstance(target_field, str):
            raise TypeError("Expected argument 'target_field' to be a str")
        pulumi.set(__self__, "target_field", target_field)
        if trim_key and not isinstance(trim_key, str):
            raise TypeError("Expected argument 'trim_key' to be a str")
        pulumi.set(__self__, "trim_key", trim_key)
        if trim_value and not isinstance(trim_value, str):
            raise TypeError("Expected argument 'trim_value' to be a str")
        pulumi.set(__self__, "trim_value", trim_value)
        if value_split and not isinstance(value_split, str):
            raise TypeError("Expected argument 'value_split' to be a str")
        pulumi.set(__self__, "value_split", value_split)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the processor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludeKeys")
    def exclude_keys(self) -> Optional[Sequence[str]]:
        """
        List of keys to exclude from document
        """
        return pulumi.get(self, "exclude_keys")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The field to be parsed. Supports template snippets.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter(name="fieldSplit")
    def field_split(self) -> str:
        """
        Regex pattern to use for splitting key-value pairs.
        """
        return pulumi.get(self, "field_split")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="if")
    def if_(self) -> Optional[str]:
        """
        Conditionally execute the processor
        """
        return pulumi.get(self, "if_")

    @property
    @pulumi.getter(name="ignoreFailure")
    def ignore_failure(self) -> Optional[bool]:
        """
        Ignore failures for the processor.
        """
        return pulumi.get(self, "ignore_failure")

    @property
    @pulumi.getter(name="ignoreMissing")
    def ignore_missing(self) -> Optional[bool]:
        """
        If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
        """
        return pulumi.get(self, "ignore_missing")

    @property
    @pulumi.getter(name="includeKeys")
    def include_keys(self) -> Optional[Sequence[str]]:
        """
        List of keys to filter and insert into document. Defaults to including all keys
        """
        return pulumi.get(self, "include_keys")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[Sequence[str]]:
        """
        Handle failures for the processor.
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix to be added to extracted keys.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="stripBrackets")
    def strip_brackets(self) -> Optional[bool]:
        """
        If `true` strip brackets `()`, `<>`, `[]` as well as quotes `'` and `"` from extracted values.
        """
        return pulumi.get(self, "strip_brackets")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Identifier for the processor.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="targetField")
    def target_field(self) -> Optional[str]:
        """
        The field to insert the extracted keys into. Defaults to the root of the document.
        """
        return pulumi.get(self, "target_field")

    @property
    @pulumi.getter(name="trimKey")
    def trim_key(self) -> Optional[str]:
        """
        String of characters to trim from extracted keys.
        """
        return pulumi.get(self, "trim_key")

    @property
    @pulumi.getter(name="trimValue")
    def trim_value(self) -> Optional[str]:
        """
        String of characters to trim from extracted values.
        """
        return pulumi.get(self, "trim_value")

    @property
    @pulumi.getter(name="valueSplit")
    def value_split(self) -> str:
        """
        Regex pattern to use for splitting the key from the value within a key-value pair.
        """
        return pulumi.get(self, "value_split")


class AwaitableIngestProcessorKvResult(IngestProcessorKvResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorKvResult(
            description=self.description,
            exclude_keys=self.exclude_keys,
            field=self.field,
            field_split=self.field_split,
            id=self.id,
            if_=self.if_,
            ignore_failure=self.ignore_failure,
            ignore_missing=self.ignore_missing,
            include_keys=self.include_keys,
            json=self.json,
            on_failures=self.on_failures,
            prefix=self.prefix,
            strip_brackets=self.strip_brackets,
            tag=self.tag,
            target_field=self.target_field,
            trim_key=self.trim_key,
            trim_value=self.trim_value,
            value_split=self.value_split)


def ingest_processor_kv(description: Optional[str] = None,
                        exclude_keys: Optional[Sequence[str]] = None,
                        field: Optional[str] = None,
                        field_split: Optional[str] = None,
                        if_: Optional[str] = None,
                        ignore_failure: Optional[bool] = None,
                        ignore_missing: Optional[bool] = None,
                        include_keys: Optional[Sequence[str]] = None,
                        on_failures: Optional[Sequence[str]] = None,
                        prefix: Optional[str] = None,
                        strip_brackets: Optional[bool] = None,
                        tag: Optional[str] = None,
                        target_field: Optional[str] = None,
                        trim_key: Optional[str] = None,
                        trim_value: Optional[str] = None,
                        value_split: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorKvResult:
    """
    This processor helps automatically parse messages (or specific event fields) which are of the `foo=bar` variety.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/kv-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    kv = elasticstack.ingest_processor_kv(field="message",
        field_split=" ",
        value_split="=",
        exclude_keys=["tags"],
        prefix="setting_")
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[kv.json])
    ```


    :param str description: Description of the processor.
    :param Sequence[str] exclude_keys: List of keys to exclude from document
    :param str field: The field to be parsed. Supports template snippets.
    :param str field_split: Regex pattern to use for splitting key-value pairs.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param Sequence[str] include_keys: List of keys to filter and insert into document. Defaults to including all keys
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str prefix: Prefix to be added to extracted keys.
    :param bool strip_brackets: If `true` strip brackets `()`, `<>`, `[]` as well as quotes `'` and `"` from extracted values.
    :param str tag: Identifier for the processor.
    :param str target_field: The field to insert the extracted keys into. Defaults to the root of the document.
    :param str trim_key: String of characters to trim from extracted keys.
    :param str trim_value: String of characters to trim from extracted values.
    :param str value_split: Regex pattern to use for splitting the key from the value within a key-value pair.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['excludeKeys'] = exclude_keys
    __args__['field'] = field
    __args__['fieldSplit'] = field_split
    __args__['if'] = if_
    __args__['ignoreFailure'] = ignore_failure
    __args__['ignoreMissing'] = ignore_missing
    __args__['includeKeys'] = include_keys
    __args__['onFailures'] = on_failures
    __args__['prefix'] = prefix
    __args__['stripBrackets'] = strip_brackets
    __args__['tag'] = tag
    __args__['targetField'] = target_field
    __args__['trimKey'] = trim_key
    __args__['trimValue'] = trim_value
    __args__['valueSplit'] = value_split
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorKv:IngestProcessorKv', __args__, opts=opts, typ=IngestProcessorKvResult).value

    return AwaitableIngestProcessorKvResult(
        description=__ret__.description,
        exclude_keys=__ret__.exclude_keys,
        field=__ret__.field,
        field_split=__ret__.field_split,
        id=__ret__.id,
        if_=__ret__.if_,
        ignore_failure=__ret__.ignore_failure,
        ignore_missing=__ret__.ignore_missing,
        include_keys=__ret__.include_keys,
        json=__ret__.json,
        on_failures=__ret__.on_failures,
        prefix=__ret__.prefix,
        strip_brackets=__ret__.strip_brackets,
        tag=__ret__.tag,
        target_field=__ret__.target_field,
        trim_key=__ret__.trim_key,
        trim_value=__ret__.trim_value,
        value_split=__ret__.value_split)


@_utilities.lift_output_func(ingest_processor_kv)
def ingest_processor_kv_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                               exclude_keys: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                               field: Optional[pulumi.Input[str]] = None,
                               field_split: Optional[pulumi.Input[str]] = None,
                               if_: Optional[pulumi.Input[Optional[str]]] = None,
                               ignore_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                               ignore_missing: Optional[pulumi.Input[Optional[bool]]] = None,
                               include_keys: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                               on_failures: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                               prefix: Optional[pulumi.Input[Optional[str]]] = None,
                               strip_brackets: Optional[pulumi.Input[Optional[bool]]] = None,
                               tag: Optional[pulumi.Input[Optional[str]]] = None,
                               target_field: Optional[pulumi.Input[Optional[str]]] = None,
                               trim_key: Optional[pulumi.Input[Optional[str]]] = None,
                               trim_value: Optional[pulumi.Input[Optional[str]]] = None,
                               value_split: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorKvResult]:
    """
    This processor helps automatically parse messages (or specific event fields) which are of the `foo=bar` variety.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/kv-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    kv = elasticstack.ingest_processor_kv(field="message",
        field_split=" ",
        value_split="=",
        exclude_keys=["tags"],
        prefix="setting_")
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[kv.json])
    ```


    :param str description: Description of the processor.
    :param Sequence[str] exclude_keys: List of keys to exclude from document
    :param str field: The field to be parsed. Supports template snippets.
    :param str field_split: Regex pattern to use for splitting key-value pairs.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param Sequence[str] include_keys: List of keys to filter and insert into document. Defaults to including all keys
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str prefix: Prefix to be added to extracted keys.
    :param bool strip_brackets: If `true` strip brackets `()`, `<>`, `[]` as well as quotes `'` and `"` from extracted values.
    :param str tag: Identifier for the processor.
    :param str target_field: The field to insert the extracted keys into. Defaults to the root of the document.
    :param str trim_key: String of characters to trim from extracted keys.
    :param str trim_value: String of characters to trim from extracted values.
    :param str value_split: Regex pattern to use for splitting the key from the value within a key-value pair.
    """
    ...
