# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorEnrichResult',
    'AwaitableIngestProcessorEnrichResult',
    'ingest_processor_enrich',
    'ingest_processor_enrich_output',
]

@pulumi.output_type
class IngestProcessorEnrichResult:
    """
    A collection of values returned by IngestProcessorEnrich.
    """
    def __init__(__self__, description=None, field=None, id=None, if_=None, ignore_failure=None, ignore_missing=None, json=None, max_matches=None, on_failures=None, override=None, policy_name=None, shape_relation=None, tag=None, target_field=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if field and not isinstance(field, str):
            raise TypeError("Expected argument 'field' to be a str")
        pulumi.set(__self__, "field", field)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if if_ and not isinstance(if_, str):
            raise TypeError("Expected argument 'if_' to be a str")
        pulumi.set(__self__, "if_", if_)
        if ignore_failure and not isinstance(ignore_failure, bool):
            raise TypeError("Expected argument 'ignore_failure' to be a bool")
        pulumi.set(__self__, "ignore_failure", ignore_failure)
        if ignore_missing and not isinstance(ignore_missing, bool):
            raise TypeError("Expected argument 'ignore_missing' to be a bool")
        pulumi.set(__self__, "ignore_missing", ignore_missing)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if max_matches and not isinstance(max_matches, int):
            raise TypeError("Expected argument 'max_matches' to be a int")
        pulumi.set(__self__, "max_matches", max_matches)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if override and not isinstance(override, bool):
            raise TypeError("Expected argument 'override' to be a bool")
        pulumi.set(__self__, "override", override)
        if policy_name and not isinstance(policy_name, str):
            raise TypeError("Expected argument 'policy_name' to be a str")
        pulumi.set(__self__, "policy_name", policy_name)
        if shape_relation and not isinstance(shape_relation, str):
            raise TypeError("Expected argument 'shape_relation' to be a str")
        pulumi.set(__self__, "shape_relation", shape_relation)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if target_field and not isinstance(target_field, str):
            raise TypeError("Expected argument 'target_field' to be a str")
        pulumi.set(__self__, "target_field", target_field)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the processor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The field in the input document that matches the policies match_field used to retrieve the enrichment data.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="if")
    def if_(self) -> Optional[str]:
        """
        Conditionally execute the processor
        """
        return pulumi.get(self, "if_")

    @property
    @pulumi.getter(name="ignoreFailure")
    def ignore_failure(self) -> Optional[bool]:
        """
        Ignore failures for the processor.
        """
        return pulumi.get(self, "ignore_failure")

    @property
    @pulumi.getter(name="ignoreMissing")
    def ignore_missing(self) -> Optional[bool]:
        """
        If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
        """
        return pulumi.get(self, "ignore_missing")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="maxMatches")
    def max_matches(self) -> Optional[int]:
        """
        The maximum number of matched documents to include under the configured target field.
        """
        return pulumi.get(self, "max_matches")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[Sequence[str]]:
        """
        Handle failures for the processor.
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter
    def override(self) -> Optional[bool]:
        """
        If processor will update fields with pre-existing non-null-valued field.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the enrich policy to use.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="shapeRelation")
    def shape_relation(self) -> Optional[str]:
        """
        A spatial relation operator used to match the geoshape of incoming documents to documents in the enrich index.
        """
        return pulumi.get(self, "shape_relation")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Identifier for the processor.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="targetField")
    def target_field(self) -> str:
        """
        Field added to incoming documents to contain enrich data.
        """
        return pulumi.get(self, "target_field")


class AwaitableIngestProcessorEnrichResult(IngestProcessorEnrichResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorEnrichResult(
            description=self.description,
            field=self.field,
            id=self.id,
            if_=self.if_,
            ignore_failure=self.ignore_failure,
            ignore_missing=self.ignore_missing,
            json=self.json,
            max_matches=self.max_matches,
            on_failures=self.on_failures,
            override=self.override,
            policy_name=self.policy_name,
            shape_relation=self.shape_relation,
            tag=self.tag,
            target_field=self.target_field)


def ingest_processor_enrich(description: Optional[str] = None,
                            field: Optional[str] = None,
                            if_: Optional[str] = None,
                            ignore_failure: Optional[bool] = None,
                            ignore_missing: Optional[bool] = None,
                            max_matches: Optional[int] = None,
                            on_failures: Optional[Sequence[str]] = None,
                            override: Optional[bool] = None,
                            policy_name: Optional[str] = None,
                            shape_relation: Optional[str] = None,
                            tag: Optional[str] = None,
                            target_field: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorEnrichResult:
    """
    The enrich processor can enrich documents with data from another index. See enrich data section for more information about how to set this up.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest-enriching-data.html and https://www.elastic.co/guide/en/elasticsearch/reference/current/enrich-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    enrich = elasticstack.ingest_processor_enrich(policy_name="users-policy",
        field="email",
        target_field="user",
        max_matches=1)
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[enrich.json])
    ```


    :param str description: Description of the processor.
    :param str field: The field in the input document that matches the policies match_field used to retrieve the enrichment data.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param int max_matches: The maximum number of matched documents to include under the configured target field.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param bool override: If processor will update fields with pre-existing non-null-valued field.
    :param str policy_name: The name of the enrich policy to use.
    :param str shape_relation: A spatial relation operator used to match the geoshape of incoming documents to documents in the enrich index.
    :param str tag: Identifier for the processor.
    :param str target_field: Field added to incoming documents to contain enrich data.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['field'] = field
    __args__['if'] = if_
    __args__['ignoreFailure'] = ignore_failure
    __args__['ignoreMissing'] = ignore_missing
    __args__['maxMatches'] = max_matches
    __args__['onFailures'] = on_failures
    __args__['override'] = override
    __args__['policyName'] = policy_name
    __args__['shapeRelation'] = shape_relation
    __args__['tag'] = tag
    __args__['targetField'] = target_field
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorEnrich:IngestProcessorEnrich', __args__, opts=opts, typ=IngestProcessorEnrichResult).value

    return AwaitableIngestProcessorEnrichResult(
        description=__ret__.description,
        field=__ret__.field,
        id=__ret__.id,
        if_=__ret__.if_,
        ignore_failure=__ret__.ignore_failure,
        ignore_missing=__ret__.ignore_missing,
        json=__ret__.json,
        max_matches=__ret__.max_matches,
        on_failures=__ret__.on_failures,
        override=__ret__.override,
        policy_name=__ret__.policy_name,
        shape_relation=__ret__.shape_relation,
        tag=__ret__.tag,
        target_field=__ret__.target_field)


@_utilities.lift_output_func(ingest_processor_enrich)
def ingest_processor_enrich_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                                   field: Optional[pulumi.Input[str]] = None,
                                   if_: Optional[pulumi.Input[Optional[str]]] = None,
                                   ignore_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                                   ignore_missing: Optional[pulumi.Input[Optional[bool]]] = None,
                                   max_matches: Optional[pulumi.Input[Optional[int]]] = None,
                                   on_failures: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   override: Optional[pulumi.Input[Optional[bool]]] = None,
                                   policy_name: Optional[pulumi.Input[str]] = None,
                                   shape_relation: Optional[pulumi.Input[Optional[str]]] = None,
                                   tag: Optional[pulumi.Input[Optional[str]]] = None,
                                   target_field: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorEnrichResult]:
    """
    The enrich processor can enrich documents with data from another index. See enrich data section for more information about how to set this up.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest-enriching-data.html and https://www.elastic.co/guide/en/elasticsearch/reference/current/enrich-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    enrich = elasticstack.ingest_processor_enrich(policy_name="users-policy",
        field="email",
        target_field="user",
        max_matches=1)
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[enrich.json])
    ```


    :param str description: Description of the processor.
    :param str field: The field in the input document that matches the policies match_field used to retrieve the enrichment data.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param int max_matches: The maximum number of matched documents to include under the configured target field.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param bool override: If processor will update fields with pre-existing non-null-valued field.
    :param str policy_name: The name of the enrich policy to use.
    :param str shape_relation: A spatial relation operator used to match the geoshape of incoming documents to documents in the enrich index.
    :param str tag: Identifier for the processor.
    :param str target_field: Field added to incoming documents to contain enrich data.
    """
    ...
