# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IngestPipelineArgs', 'IngestPipeline']

@pulumi.input_type
class IngestPipelineArgs:
    def __init__(__self__, *,
                 processors: pulumi.Input[Sequence[pulumi.Input[str]]],
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['IngestPipelineElasticsearchConnectionArgs']] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IngestPipeline resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] processors: Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        :param pulumi.Input[str] description: Description of the ingest pipeline.
        :param pulumi.Input['IngestPipelineElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: The name of the ingest pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_failures: Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        """
        pulumi.set(__self__, "processors", processors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_failures is not None:
            pulumi.set(__self__, "on_failures", on_failures)

    @property
    @pulumi.getter
    def processors(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        """
        return pulumi.get(self, "processors")

    @processors.setter
    def processors(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "processors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the ingest pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['IngestPipelineElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['IngestPipelineElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional user metadata about the index template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ingest pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        """
        return pulumi.get(self, "on_failures")

    @on_failures.setter
    def on_failures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "on_failures", value)


@pulumi.input_type
class _IngestPipelineState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['IngestPipelineElasticsearchConnectionArgs']] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering IngestPipeline resources.
        :param pulumi.Input[str] description: Description of the ingest pipeline.
        :param pulumi.Input['IngestPipelineElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: The name of the ingest pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_failures: Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        :param pulumi.Input[Sequence[pulumi.Input[str]]] processors: Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_failures is not None:
            pulumi.set(__self__, "on_failures", on_failures)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the ingest pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['IngestPipelineElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['IngestPipelineElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional user metadata about the index template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ingest pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        """
        return pulumi.get(self, "on_failures")

    @on_failures.setter
    def on_failures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "on_failures", value)

    @property
    @pulumi.getter
    def processors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        """
        return pulumi.get(self, "processors")

    @processors.setter
    def processors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "processors", value)


class IngestPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IngestPipelineElasticsearchConnectionArgs']]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
         $ pulumi import elasticstack:index/ingestPipeline:IngestPipeline my_ingest_pipeline <cluster_uuid>/<ingest pipeline name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the ingest pipeline.
        :param pulumi.Input[pulumi.InputType['IngestPipelineElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: The name of the ingest pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_failures: Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        :param pulumi.Input[Sequence[pulumi.Input[str]]] processors: Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IngestPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
         $ pulumi import elasticstack:index/ingestPipeline:IngestPipeline my_ingest_pipeline <cluster_uuid>/<ingest pipeline name>
        ```

        :param str resource_name: The name of the resource.
        :param IngestPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngestPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IngestPipelineElasticsearchConnectionArgs']]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngestPipelineArgs.__new__(IngestPipelineArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["on_failures"] = on_failures
            if processors is None and not opts.urn:
                raise TypeError("Missing required property 'processors'")
            __props__.__dict__["processors"] = processors
        super(IngestPipeline, __self__).__init__(
            'elasticstack:index/ingestPipeline:IngestPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IngestPipelineElasticsearchConnectionArgs']]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            on_failures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            processors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'IngestPipeline':
        """
        Get an existing IngestPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the ingest pipeline.
        :param pulumi.Input[pulumi.InputType['IngestPipelineElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: The name of the ingest pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_failures: Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        :param pulumi.Input[Sequence[pulumi.Input[str]]] processors: Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IngestPipelineState.__new__(_IngestPipelineState)

        __props__.__dict__["description"] = description
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["on_failures"] = on_failures
        __props__.__dict__["processors"] = processors
        return IngestPipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the ingest pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.IngestPipelineElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[str]]:
        """
        Optional user metadata about the index template.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ingest pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Processors to run immediately after a processor failure. Each processor supports a processor-level `on_failure` value. If a processor without an `on_failure` value fails, Elasticsearch uses this pipeline-level parameter as a fallback. The processors in this parameter run sequentially in the order specified. Elasticsearch will not attempt to run the pipeline’s remaining processors. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter
    def processors(self) -> pulumi.Output[Sequence[str]]:
        """
        Processors used to perform transformations on documents before indexing. Processors run sequentially in the order specified. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/processors.html. Each record must be a valid JSON document.
        """
        return pulumi.get(self, "processors")

