# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'DataSecurityRoleMappingResult',
    'AwaitableDataSecurityRoleMappingResult',
    'data_security_role_mapping',
    'data_security_role_mapping_output',
]

@pulumi.output_type
class DataSecurityRoleMappingResult:
    """
    A collection of values returned by DataSecurityRoleMapping.
    """
    def __init__(__self__, elasticsearch_connection=None, enabled=None, id=None, metadata=None, name=None, role_templates=None, roles=None, rules=None):
        if elasticsearch_connection and not isinstance(elasticsearch_connection, dict):
            raise TypeError("Expected argument 'elasticsearch_connection' to be a dict")
        pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if role_templates and not isinstance(role_templates, str):
            raise TypeError("Expected argument 'role_templates' to be a str")
        pulumi.set(__self__, "role_templates", role_templates)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if rules and not isinstance(rules, str):
            raise TypeError("Expected argument 'rules' to be a str")
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional['outputs.DataSecurityRoleMappingElasticsearchConnectionResult']:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Mappings that have `enabled` set to `false` are ignored when role mapping is performed.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        Additional metadata that helps define which roles are assigned to each user. Keys beginning with `_` are reserved for system usage.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The distinct name that identifies the role mapping, used solely as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleTemplates")
    def role_templates(self) -> str:
        """
        A list of mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
        """
        return pulumi.get(self, "role_templates")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        A list of role names that are granted to the users that match the role mapping rules.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def rules(self) -> str:
        """
        The rules that determine which users should be matched by the mapping. A rule is a logical condition that is expressed by using a JSON DSL.
        """
        return pulumi.get(self, "rules")


class AwaitableDataSecurityRoleMappingResult(DataSecurityRoleMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return DataSecurityRoleMappingResult(
            elasticsearch_connection=self.elasticsearch_connection,
            enabled=self.enabled,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            role_templates=self.role_templates,
            roles=self.roles,
            rules=self.rules)


def data_security_role_mapping(elasticsearch_connection: Optional[pulumi.InputType['DataSecurityRoleMappingElasticsearchConnectionArgs']] = None,
                               name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableDataSecurityRoleMappingResult:
    """
    Retrieves role mappings. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-get-role-mapping.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    mapping = elasticstack.data_security_role_mapping(name="my_mapping")
    pulumi.export("user", mapping.name)
    ```


    :param pulumi.InputType['DataSecurityRoleMappingElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
    :param str name: The distinct name that identifies the role mapping, used solely as an identifier.
    """
    __args__ = dict()
    __args__['elasticsearchConnection'] = elasticsearch_connection
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/dataSecurityRoleMapping:DataSecurityRoleMapping', __args__, opts=opts, typ=DataSecurityRoleMappingResult).value

    return AwaitableDataSecurityRoleMappingResult(
        elasticsearch_connection=__ret__.elasticsearch_connection,
        enabled=__ret__.enabled,
        id=__ret__.id,
        metadata=__ret__.metadata,
        name=__ret__.name,
        role_templates=__ret__.role_templates,
        roles=__ret__.roles,
        rules=__ret__.rules)


@_utilities.lift_output_func(data_security_role_mapping)
def data_security_role_mapping_output(elasticsearch_connection: Optional[pulumi.Input[Optional[pulumi.InputType['DataSecurityRoleMappingElasticsearchConnectionArgs']]]] = None,
                                      name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[DataSecurityRoleMappingResult]:
    """
    Retrieves role mappings. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-get-role-mapping.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    mapping = elasticstack.data_security_role_mapping(name="my_mapping")
    pulumi.export("user", mapping.name)
    ```


    :param pulumi.InputType['DataSecurityRoleMappingElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
    :param str name: The distinct name that identifies the role mapping, used solely as an identifier.
    """
    ...
