# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'DataSecurityRoleResult',
    'AwaitableDataSecurityRoleResult',
    'data_security_role',
    'data_security_role_output',
]

@pulumi.output_type
class DataSecurityRoleResult:
    """
    A collection of values returned by DataSecurityRole.
    """
    def __init__(__self__, applications=None, clusters=None, elasticsearch_connection=None, global_=None, id=None, indices=None, metadata=None, name=None, run_as=None):
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if elasticsearch_connection and not isinstance(elasticsearch_connection, dict):
            raise TypeError("Expected argument 'elasticsearch_connection' to be a dict")
        pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if global_ and not isinstance(global_, str):
            raise TypeError("Expected argument 'global_' to be a str")
        pulumi.set(__self__, "global_", global_)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if indices and not isinstance(indices, list):
            raise TypeError("Expected argument 'indices' to be a list")
        pulumi.set(__self__, "indices", indices)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if run_as and not isinstance(run_as, list):
            raise TypeError("Expected argument 'run_as' to be a list")
        pulumi.set(__self__, "run_as", run_as)

    @property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.DataSecurityRoleApplicationResult']:
        """
        A list of application privilege entries.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def clusters(self) -> Sequence[str]:
        """
        A list of cluster privileges. These privileges define the cluster level actions that users with this role are able to execute.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional['outputs.DataSecurityRoleElasticsearchConnectionResult']:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter(name="global")
    def global_(self) -> str:
        """
        An object defining global privileges.
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def indices(self) -> Sequence['outputs.DataSecurityRoleIndexResult']:
        """
        A list of indices permissions entries.
        """
        return pulumi.get(self, "indices")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        Optional meta-data.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> Optional[Sequence[str]]:
        """
        A list of users that the owners of this role can impersonate.
        """
        return pulumi.get(self, "run_as")


class AwaitableDataSecurityRoleResult(DataSecurityRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return DataSecurityRoleResult(
            applications=self.applications,
            clusters=self.clusters,
            elasticsearch_connection=self.elasticsearch_connection,
            global_=self.global_,
            id=self.id,
            indices=self.indices,
            metadata=self.metadata,
            name=self.name,
            run_as=self.run_as)


def data_security_role(elasticsearch_connection: Optional[pulumi.InputType['DataSecurityRoleElasticsearchConnectionArgs']] = None,
                       name: Optional[str] = None,
                       run_as: Optional[Sequence[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableDataSecurityRoleResult:
    """
    Use this data source to get information about an existing Elasticsearch role. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-get-role.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    role_data_security_role = elasticstack.data_security_role(name="testrole")
    pulumi.export("role", role_data_security_role.name)
    ```


    :param pulumi.InputType['DataSecurityRoleElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
    :param str name: The name of the role.
    :param Sequence[str] run_as: A list of users that the owners of this role can impersonate.
    """
    __args__ = dict()
    __args__['elasticsearchConnection'] = elasticsearch_connection
    __args__['name'] = name
    __args__['runAs'] = run_as
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/dataSecurityRole:DataSecurityRole', __args__, opts=opts, typ=DataSecurityRoleResult).value

    return AwaitableDataSecurityRoleResult(
        applications=__ret__.applications,
        clusters=__ret__.clusters,
        elasticsearch_connection=__ret__.elasticsearch_connection,
        global_=__ret__.global_,
        id=__ret__.id,
        indices=__ret__.indices,
        metadata=__ret__.metadata,
        name=__ret__.name,
        run_as=__ret__.run_as)


@_utilities.lift_output_func(data_security_role)
def data_security_role_output(elasticsearch_connection: Optional[pulumi.Input[Optional[pulumi.InputType['DataSecurityRoleElasticsearchConnectionArgs']]]] = None,
                              name: Optional[pulumi.Input[str]] = None,
                              run_as: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[DataSecurityRoleResult]:
    """
    Use this data source to get information about an existing Elasticsearch role. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-get-role.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    role_data_security_role = elasticstack.data_security_role(name="testrole")
    pulumi.export("role", role_data_security_role.name)
    ```


    :param pulumi.InputType['DataSecurityRoleElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
    :param str name: The name of the role.
    :param Sequence[str] run_as: A list of users that the owners of this role can impersonate.
    """
    ...
