# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComponentTemplateArgs', 'ComponentTemplate']

@pulumi.input_type
class ComponentTemplateArgs:
    def __init__(__self__, *,
                 template: pulumi.Input['ComponentTemplateTemplateArgs'],
                 elasticsearch_connection: Optional[pulumi.Input['ComponentTemplateElasticsearchConnectionArgs']] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ComponentTemplate resource.
        :param pulumi.Input['ComponentTemplateTemplateArgs'] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input['ComponentTemplateElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the component template.
        :param pulumi.Input[str] name: Name of the component template to create.
        :param pulumi.Input[int] version: Version number used to manage component templates externally.
        """
        pulumi.set(__self__, "template", template)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['ComponentTemplateTemplateArgs']:
        """
        Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['ComponentTemplateTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['ComponentTemplateElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['ComponentTemplateElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional user metadata about the component template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the component template to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        Version number used to manage component templates externally.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ComponentTemplateState:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['ComponentTemplateElasticsearchConnectionArgs']] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['ComponentTemplateTemplateArgs']] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ComponentTemplate resources.
        :param pulumi.Input['ComponentTemplateElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the component template.
        :param pulumi.Input[str] name: Name of the component template to create.
        :param pulumi.Input['ComponentTemplateTemplateArgs'] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage component templates externally.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['ComponentTemplateElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['ComponentTemplateElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional user metadata about the component template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the component template to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ComponentTemplateTemplateArgs']]:
        """
        Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ComponentTemplateTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        Version number used to manage component templates externally.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class ComponentTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ComponentTemplateElasticsearchConnectionArgs']]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ComponentTemplateTemplateArgs']]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates or updates a component template. Component templates are building blocks for constructing index templates that specify index mappings, settings, and aliases. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-component-template.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        my_template_component_template = elasticstack.ComponentTemplate("myTemplateComponentTemplate", template=elasticstack.ComponentTemplateTemplateArgs(
            aliases=[elasticstack.ComponentTemplateTemplateAliasArgs(
                name="my_template_test",
            )],
            settings=json.dumps({
                "number_of_shards": "3",
            }),
        ))
        my_template_index_template = elasticstack.IndexTemplate("myTemplateIndexTemplate",
            index_patterns=["stream*"],
            composed_ofs=[my_template_component_template.name])
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/componentTemplate:ComponentTemplate my_template <cluster_uuid>/<component_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ComponentTemplateElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the component template.
        :param pulumi.Input[str] name: Name of the component template to create.
        :param pulumi.Input[pulumi.InputType['ComponentTemplateTemplateArgs']] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage component templates externally.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComponentTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or updates a component template. Component templates are building blocks for constructing index templates that specify index mappings, settings, and aliases. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-component-template.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        my_template_component_template = elasticstack.ComponentTemplate("myTemplateComponentTemplate", template=elasticstack.ComponentTemplateTemplateArgs(
            aliases=[elasticstack.ComponentTemplateTemplateAliasArgs(
                name="my_template_test",
            )],
            settings=json.dumps({
                "number_of_shards": "3",
            }),
        ))
        my_template_index_template = elasticstack.IndexTemplate("myTemplateIndexTemplate",
            index_patterns=["stream*"],
            composed_ofs=[my_template_component_template.name])
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/componentTemplate:ComponentTemplate my_template <cluster_uuid>/<component_name>
        ```

        :param str resource_name: The name of the resource.
        :param ComponentTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComponentTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ComponentTemplateElasticsearchConnectionArgs']]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ComponentTemplateTemplateArgs']]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComponentTemplateArgs.__new__(ComponentTemplateArgs)

            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["version"] = version
        super(ComponentTemplate, __self__).__init__(
            'elasticstack:index/componentTemplate:ComponentTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ComponentTemplateElasticsearchConnectionArgs']]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['ComponentTemplateTemplateArgs']]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'ComponentTemplate':
        """
        Get an existing ComponentTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ComponentTemplateElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the component template.
        :param pulumi.Input[str] name: Name of the component template to create.
        :param pulumi.Input[pulumi.InputType['ComponentTemplateTemplateArgs']] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage component templates externally.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComponentTemplateState.__new__(_ComponentTemplateState)

        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["template"] = template
        __props__.__dict__["version"] = version
        return ComponentTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.ComponentTemplateElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[str]]:
        """
        Optional user metadata about the component template.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the component template to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.ComponentTemplateTemplate']:
        """
        Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[int]]:
        """
        Version number used to manage component templates externally.
        """
        return pulumi.get(self, "version")

