# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterSettingsArgs', 'ClusterSettings']

@pulumi.input_type
class ClusterSettingsArgs:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['ClusterSettingsElasticsearchConnectionArgs']] = None,
                 persistent: Optional[pulumi.Input['ClusterSettingsPersistentArgs']] = None,
                 transient: Optional[pulumi.Input['ClusterSettingsTransientArgs']] = None):
        """
        The set of arguments for constructing a ClusterSettings resource.
        :param pulumi.Input['ClusterSettingsElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input['ClusterSettingsPersistentArgs'] persistent: Settings will apply across restarts.
        :param pulumi.Input['ClusterSettingsTransientArgs'] transient: Settings do not survive a full cluster restart.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if persistent is not None:
            pulumi.set(__self__, "persistent", persistent)
        if transient is not None:
            pulumi.set(__self__, "transient", transient)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['ClusterSettingsElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['ClusterSettingsElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def persistent(self) -> Optional[pulumi.Input['ClusterSettingsPersistentArgs']]:
        """
        Settings will apply across restarts.
        """
        return pulumi.get(self, "persistent")

    @persistent.setter
    def persistent(self, value: Optional[pulumi.Input['ClusterSettingsPersistentArgs']]):
        pulumi.set(self, "persistent", value)

    @property
    @pulumi.getter
    def transient(self) -> Optional[pulumi.Input['ClusterSettingsTransientArgs']]:
        """
        Settings do not survive a full cluster restart.
        """
        return pulumi.get(self, "transient")

    @transient.setter
    def transient(self, value: Optional[pulumi.Input['ClusterSettingsTransientArgs']]):
        pulumi.set(self, "transient", value)


@pulumi.input_type
class _ClusterSettingsState:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['ClusterSettingsElasticsearchConnectionArgs']] = None,
                 persistent: Optional[pulumi.Input['ClusterSettingsPersistentArgs']] = None,
                 transient: Optional[pulumi.Input['ClusterSettingsTransientArgs']] = None):
        """
        Input properties used for looking up and filtering ClusterSettings resources.
        :param pulumi.Input['ClusterSettingsElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input['ClusterSettingsPersistentArgs'] persistent: Settings will apply across restarts.
        :param pulumi.Input['ClusterSettingsTransientArgs'] transient: Settings do not survive a full cluster restart.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if persistent is not None:
            pulumi.set(__self__, "persistent", persistent)
        if transient is not None:
            pulumi.set(__self__, "transient", transient)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['ClusterSettingsElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['ClusterSettingsElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def persistent(self) -> Optional[pulumi.Input['ClusterSettingsPersistentArgs']]:
        """
        Settings will apply across restarts.
        """
        return pulumi.get(self, "persistent")

    @persistent.setter
    def persistent(self, value: Optional[pulumi.Input['ClusterSettingsPersistentArgs']]):
        pulumi.set(self, "persistent", value)

    @property
    @pulumi.getter
    def transient(self) -> Optional[pulumi.Input['ClusterSettingsTransientArgs']]:
        """
        Settings do not survive a full cluster restart.
        """
        return pulumi.get(self, "transient")

    @transient.setter
    def transient(self, value: Optional[pulumi.Input['ClusterSettingsTransientArgs']]):
        pulumi.set(self, "transient", value)


class ClusterSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsElasticsearchConnectionArgs']]] = None,
                 persistent: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsPersistentArgs']]] = None,
                 transient: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsTransientArgs']]] = None,
                 __props__=None):
        """
        Updates cluster-wide settings. If the Elasticsearch security features are enabled, you must have the manage cluster privilege to use this API. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/cluster-update-settings.html

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterSettingsElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[pulumi.InputType['ClusterSettingsPersistentArgs']] persistent: Settings will apply across restarts.
        :param pulumi.Input[pulumi.InputType['ClusterSettingsTransientArgs']] transient: Settings do not survive a full cluster restart.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Updates cluster-wide settings. If the Elasticsearch security features are enabled, you must have the manage cluster privilege to use this API. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/cluster-update-settings.html

        :param str resource_name: The name of the resource.
        :param ClusterSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsElasticsearchConnectionArgs']]] = None,
                 persistent: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsPersistentArgs']]] = None,
                 transient: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsTransientArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterSettingsArgs.__new__(ClusterSettingsArgs)

            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["persistent"] = persistent
            __props__.__dict__["transient"] = transient
        super(ClusterSettings, __self__).__init__(
            'elasticstack:index/clusterSettings:ClusterSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsElasticsearchConnectionArgs']]] = None,
            persistent: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsPersistentArgs']]] = None,
            transient: Optional[pulumi.Input[pulumi.InputType['ClusterSettingsTransientArgs']]] = None) -> 'ClusterSettings':
        """
        Get an existing ClusterSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterSettingsElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[pulumi.InputType['ClusterSettingsPersistentArgs']] persistent: Settings will apply across restarts.
        :param pulumi.Input[pulumi.InputType['ClusterSettingsTransientArgs']] transient: Settings do not survive a full cluster restart.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterSettingsState.__new__(_ClusterSettingsState)

        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["persistent"] = persistent
        __props__.__dict__["transient"] = transient
        return ClusterSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.ClusterSettingsElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def persistent(self) -> pulumi.Output[Optional['outputs.ClusterSettingsPersistent']]:
        """
        Settings will apply across restarts.
        """
        return pulumi.get(self, "persistent")

    @property
    @pulumi.getter
    def transient(self) -> pulumi.Output[Optional['outputs.ClusterSettingsTransient']]:
        """
        Settings do not survive a full cluster restart.
        """
        return pulumi.get(self, "transient")

