# -*- coding: utf-8 -*-

"""
coingeckoapiv3testing

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3testing.api_helper import APIHelper
from coingeckoapiv3testing.configuration import Server
from coingeckoapiv3testing.controllers.base_controller import BaseController


class SimpleController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3testing API."""

    def __init__(self, config, call_back=None):
        super(SimpleController, self).__init__(config, call_back)

    def getthecurrentpriceofanycryptocurrenciesinanyothersupportedcurrenciesthatyouneed(self,
                                                                                        ids,
                                                                                        vs_currencies,
                                                                                        include_market_cap=None,
                                                                                        include_24_hr_vol=None,
                                                                                        include_24_hr_change=None,
                                                                                        include_last_updated_at=None):
        """Does a GET request to /simple/price.

        Get the current price of any cryptocurrencies in any other supported
        currencies that you need.

        Args:
            ids (string): id of coins, comma-separated if querying more than 1
                coin *refers to <b>`coins/list`</b>
            vs_currencies (string): vs_currency of coins, comma-separated if
                querying more than 1 vs_currency *refers to
                <b>`simple/supported_vs_currencies`</b>
            include_market_cap (string, optional): <b>true/false</b> to
                include market_cap, <b>default: false</b>
            include_24_hr_vol (string, optional): <b>true/false</b> to include
                24hr_vol, <b>default: false</b>
            include_24_hr_change (string, optional): <b>true/false</b> to
                include 24hr_change, <b>default: false</b>
            include_last_updated_at (string, optional): <b>true/false</b> to
                include last_updated_at of price, <b>default: false</b>

        Returns:
            void: Response from the API. price(s) of cryptocurrency

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/simple/price'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'ids': ids,
            'vs_currencies': vs_currencies,
            'include_market_cap': include_market_cap,
            'include_24hr_vol': include_24_hr_vol,
            'include_24hr_change': include_24_hr_change,
            'include_last_updated_at': include_last_updated_at
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getcurrentpriceoftokens_usingcontractaddresses_foragivenplatforminanyothercurrencythatyouneed(self,
                                                                                                      id,
                                                                                                      contract_addresses,
                                                                                                      vs_currencies,
                                                                                                      include_market_cap=None,
                                                                                                      include_24_hr_vol=None,
                                                                                                      include_24_hr_change=None,
                                                                                                      include_last_updated_at=None):
        """Does a GET request to /simple/token_price/{id}.

        Get current price of tokens (using contract addresses) for a given
        platform in any other currency that you need.

        Args:
            id (string): The id of the platform issuing tokens (See
                asset_platforms endpoint for list of options)
            contract_addresses (string): The contract address of tokens, comma
                separated
            vs_currencies (string): vs_currency of coins, comma-separated if
                querying more than 1 vs_currency *refers to
                <b>`simple/supported_vs_currencies`</b>
            include_market_cap (string, optional): <b>true/false</b> to
                include market_cap, <b>default: false</b>
            include_24_hr_vol (string, optional): <b>true/false</b> to include
                24hr_vol, <b>default: false</b>
            include_24_hr_change (string, optional): <b>true/false</b> to
                include 24hr_change, <b>default: false</b>
            include_last_updated_at (string, optional): <b>true/false</b> to
                include last_updated_at of price, <b>default: false</b>

        Returns:
            void: Response from the API. price(s) of cryptocurrency

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/simple/token_price/{id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'contract_addresses': contract_addresses,
            'vs_currencies': vs_currencies,
            'include_market_cap': include_market_cap,
            'include_24hr_vol': include_24_hr_vol,
            'include_24hr_change': include_24_hr_change,
            'include_last_updated_at': include_last_updated_at
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getlistofsupported_vs_currencies(self):
        """Does a GET request to /simple/supported_vs_currencies.

        Get list of supported_vs_currencies.

        Returns:
            void: Response from the API. list of supported_vs_currencies

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/simple/supported_vs_currencies'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
