# -*- coding: utf-8 -*-

"""
coingeckoapiv3testing

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3testing.api_helper import APIHelper
from coingeckoapiv3testing.configuration import Server
from coingeckoapiv3testing.controllers.base_controller import BaseController


class EventsController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3testing API."""

    def __init__(self, config, call_back=None):
        super(EventsController, self).__init__(config, call_back)

    def getevents_paginatedby_100(self,
                                  country_code=None,
                                  mtype=None,
                                  page=None,
                                  upcoming_events_only=None,
                                  from_date=None,
                                  to_date=None):
        """Does a GET request to /events.

        Get events, paginated by 100

        Args:
            country_code (string, optional): country_code of event (eg. 'US').
                use <b>/api/v3/events/countries</b> for list of country_codes
            mtype (string, optional): type of event (eg. 'Conference'). use
                <b>/api/v3/events/types</b> for list of types
            page (string, optional): page of results (paginated by 100)
            upcoming_events_only (string, optional): lists only upcoming
                events. <br>true, false</br> (defaults to true, set to false
                to list all events)
            from_date (string, optional): lists events after this date
                yyyy-mm-dd
            to_date (string, optional): lists events before this date
                yyyy-mm-dd (set upcoming_events_only to false if fetching past
                events)

        Returns:
            void: Response from the API. List events

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/events'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'country_code': country_code,
            'type': mtype,
            'page': page,
            'upcoming_events_only': upcoming_events_only,
            'from_date': from_date,
            'to_date': to_date
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getlistofeventcountries(self):
        """Does a GET request to /events/countries.

        Get list of event countries

        Returns:
            void: Response from the API. List event countries

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/events/countries'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getlistofeventstypes(self):
        """Does a GET request to /events/types.

        Get list of event types

        Returns:
            void: Response from the API. List event types

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/events/types'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
