# -*- coding: utf-8 -*-

"""
coingeckoapiv3testing

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3testing.api_helper import APIHelper
from coingeckoapiv3testing.configuration import Server
from coingeckoapiv3testing.controllers.base_controller import BaseController


class DerivativesController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3testing API."""

    def __init__(self, config, call_back=None):
        super(DerivativesController, self).__init__(config, call_back)

    def listallderivativetickers(self,
                                 include_tickers=None):
        """Does a GET request to /derivatives.

        List all derivative tickers

        Args:
            include_tickers (string, optional): ['all', 'unexpired'] - expired
                to show unexpired tickers, all to list all tickers, defaults
                to unexpired

        Returns:
            void: Response from the API. List all derivative tickers

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/derivatives'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'include_tickers': include_tickers
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listallderivativeexchanges(self,
                                   order=None,
                                   per_page=None,
                                   page=None):
        """Does a GET request to /derivatives/exchanges.

        List all derivative exchanges

        Args:
            order (string, optional): order results using following params
                name_asc，name_desc，open_interest_btc_asc，open_interest_btc_desc
                ，trade_volume_24h_btc_asc，trade_volume_24h_btc_desc
            per_page (int, optional): Total results per page
            page (int, optional): Page through results

        Returns:
            void: Response from the API. List all derivative exchanges

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/derivatives/exchanges'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'order': order,
            'per_page': per_page,
            'page': page
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def showderivativeexchangedata(self,
                                   id,
                                   include_tickers=None):
        """Does a GET request to /derivatives/exchanges/{id}.

        show derivative exchange data

        Args:
            id (string): pass the exchange id (can be obtained from
                derivatives/exchanges/list) eg. bitmex
            include_tickers (string, optional): ['all', 'unexpired'] - expired
                to show unexpired tickers, all to list all tickers, leave
                blank to omit tickers data in response

        Returns:
            void: Response from the API. show derivative exchange data

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/derivatives/exchanges/{id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'include_tickers': include_tickers
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listallderivativeexchangesnameandidentifier(self):
        """Does a GET request to /derivatives/exchanges/list.

        List all derivative exchanges name and identifier

        Returns:
            void: Response from the API. List all derivative exchanges name
                and identifier

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/derivatives/exchanges/list'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
