# -*- coding: utf-8 -*-

"""
coingeckoapiv3testing

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3testing.api_helper import APIHelper
from coingeckoapiv3testing.configuration import Server
from coingeckoapiv3testing.controllers.base_controller import BaseController


class ContractController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3testing API."""

    def __init__(self, config, call_back=None):
        super(ContractController, self).__init__(config, call_back)

    def getcoininfofromcontractaddress(self,
                                       id,
                                       contract_address):
        """Does a GET request to /coins/{id}/contract/{contract_address}.

        Get coin info from contract address

        Args:
            id (string): Asset platform (See asset_platforms endpoint for list
                of options)
            contract_address (string): Token's contract address

        Returns:
            void: Response from the API. Get current data for a coin

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/contract/{contract_address}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True},
            'contract_address': {'value': contract_address, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def gethistoricalmarketdataincludeprice_marketcap_and_24_hvolume_granularityauto_fromacontractaddress(self,
                                                                                                          id,
                                                                                                          contract_address,
                                                                                                          vs_currency,
                                                                                                          days):
        """Does a GET request to /coins/{id}/contract/{contract_address}/market_chart/.

        Get historical market data include price, market cap, and 24h volume
        (granularity auto)

        Args:
            id (string): The id of the platform issuing tokens (See
                asset_platforms endpoint for list of options)
            contract_address (string): Token's contract address
            vs_currency (string): The target currency of market data (usd,
                eur, jpy, etc.)
            days (string): Data up to number of days ago (eg. 1,14,30,max)

        Returns:
            void: Response from the API. Get historical market data include
                price, market cap, and 24h volume

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/contract/{contract_address}/market_chart/'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True},
            'contract_address': {'value': contract_address, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'vs_currency': vs_currency,
            'days': days
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def gethistoricalmarketdataincludeprice_marketcap_and_24_hvolumewithinarangeoftimestamp_granularityauto_fromacontractaddress(self,
                                                                                                                                 id,
                                                                                                                                 contract_address,
                                                                                                                                 vs_currency,
                                                                                                                                 mfrom,
                                                                                                                                 to):
        """Does a GET request to /coins/{id}/contract/{contract_address}/market_chart/range.

        Get historical market data include price, market cap, and 24h volume
        within a range of timestamp (granularity auto)

        Args:
            id (string): The id of the platform issuing tokens (See
                asset_platforms endpoint for list of options)
            contract_address (string): Token's contract address
            vs_currency (string): The target currency of market data (usd,
                eur, jpy, etc.)
            mfrom (string): From date in UNIX Timestamp (eg. 1392577232)
            to (string): To date in UNIX Timestamp (eg. 1422577232)

        Returns:
            void: Response from the API. Get historical market data include
                price, market cap, and 24h volume

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/contract/{contract_address}/market_chart/range'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True},
            'contract_address': {'value': contract_address, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'vs_currency': vs_currency,
            'from': mfrom,
            'to': to
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
