# -*- coding: utf-8 -*-

"""
coingeckoapiv3testing

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3testing.api_helper import APIHelper
from coingeckoapiv3testing.configuration import Server
from coingeckoapiv3testing.controllers.base_controller import BaseController


class CoinsController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3testing API."""

    def __init__(self, config, call_back=None):
        super(CoinsController, self).__init__(config, call_back)

    def listallsupportedcoinsid_nameandsymbol_nopaginationrequired(self,
                                                                   include_platform=None):
        """Does a GET request to /coins/list.

        Use this to obtain all the coins' id in order to make API calls

        Args:
            include_platform (bool, optional): flag to include platform
                contract addresses (eg. 0x.... for Ethereum based tokens).  
                valid values: true, false

        Returns:
            void: Response from the API. List all coins with id, name, and
                symbol

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/list'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'include_platform': include_platform
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listallsupportedcoinsprice_marketcap_volume_andmarketrelateddata(self,
                                                                         vs_currency,
                                                                         ids=None,
                                                                         category=None,
                                                                         order='market_cap_desc',
                                                                         per_page=100,
                                                                         page=1,
                                                                         sparkline=False,
                                                                         price_change_percentage=None):
        """Does a GET request to /coins/markets.

        Use this to obtain all the coins market data (price, market cap,
        volume)

        Args:
            vs_currency (string): The target currency of market data (usd,
                eur, jpy, etc.)
            ids (string, optional): The ids of the coin, comma separated
                crytocurrency symbols (base). refers to `/coins/list`. <b>When
                left empty, returns numbers the coins observing the params
                `limit` and `start`</b>
            category (string, optional): filter by coin category. Refer to
                /coin/categories/list
            order (string, optional): valid values: <b>market_cap_desc,
                gecko_desc, gecko_asc, market_cap_asc, market_cap_desc,
                volume_asc, volume_desc, id_asc, id_desc</b> sort results by
                field.
            per_page (int, optional): valid values: 1..250  Total results per
                page
            page (int, optional): Page through results
            sparkline (bool, optional): Include sparkline 7 days data (eg.
                true, false)
            price_change_percentage (string, optional): Include price change
                percentage in <b>1h, 24h, 7d, 14d, 30d, 200d, 1y</b> (eg.
                '`1h,24h,7d`' comma-separated, invalid values will be
                discarded)

        Returns:
            void: Response from the API. List all coins with market data

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/markets'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'vs_currency': vs_currency,
            'ids': ids,
            'category': category,
            'order': order,
            'per_page': per_page,
            'page': page,
            'sparkline': sparkline,
            'price_change_percentage': price_change_percentage
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getcurrentdata_name_price_market_includingexchangetickers_foracoin(self,
                                                                           id,
                                                                           localization=None,
                                                                           tickers=None,
                                                                           market_data=None,
                                                                           community_data=None,
                                                                           developer_data=None,
                                                                           sparkline=None):
        """Does a GET request to /coins/{id}.

        Get current data (name, price, market, ... including exchange tickers)
        for a coin.<br><br> **IMPORTANT**:
         Ticker object is limited to 100 items, to get more tickers, use
         `/coins/{id}/tickers`
         Ticker `is_stale` is true when ticker that has not been
         updated/unchanged from the exchange for a while.
         Ticker `is_anomaly` is true if ticker's price is outliered by our
         system.
         You are responsible for managing how you want to display these
         information (e.g. footnote, different background, change opacity,
         hide)

        Args:
            id (string): pass the coin id (can be obtained from /coins) eg.
                bitcoin
            localization (string, optional): Include all localized languages
                in response (true/false) <b>[default: true]</b>
            tickers (bool, optional): Include tickers data (true/false)
                <b>[default: true]</b>
            market_data (bool, optional): Include market_data (true/false)
                <b>[default: true]</b>
            community_data (bool, optional): Include community_data data
                (true/false) <b>[default: true]</b>
            developer_data (bool, optional): Include developer_data data
                (true/false) <b>[default: true]</b>
            sparkline (bool, optional): Include sparkline 7 days data (eg.
                true, false) <b>[default: false]</b>

        Returns:
            void: Response from the API. Get current data for a coin

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'localization': localization,
            'tickers': tickers,
            'market_data': market_data,
            'community_data': community_data,
            'developer_data': developer_data,
            'sparkline': sparkline
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getcointickers_paginatedto_100_items(self,
                                             id,
                                             exchange_ids=None,
                                             include_exchange_logo=None,
                                             page=None,
                                             order=None,
                                             depth=None):
        """Does a GET request to /coins/{id}/tickers.

        Get coin tickers (paginated to 100 items)<br><br> **IMPORTANT**:
         Ticker `is_stale` is true when ticker that has not been
         updated/unchanged from the exchange for a while.
         Ticker `is_anomaly` is true if ticker's price is outliered by our
         system.
         You are responsible for managing how you want to display these
         information (e.g. footnote, different background, change opacity,
         hide)

        Args:
            id (string): pass the coin id (can be obtained from /coins/list)
                eg. bitcoin
            exchange_ids (string, optional): filter results by exchange_ids
                (ref: v3/exchanges/list)
            include_exchange_logo (string, optional): flag to show
                exchange_logo
            page (int, optional): Page through results
            order (string, optional): valid values: <b>trust_score_desc
                (default), trust_score_asc and volume_desc</b>
            depth (string, optional): flag to show 2% orderbook depth. valid
                values: true, false

        Returns:
            void: Response from the API. Get coin tickers

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/tickers'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'exchange_ids': exchange_ids,
            'include_exchange_logo': include_exchange_logo,
            'page': page,
            'order': order,
            'depth': depth
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def gethistoricaldata_name_price_market_stats_atagivendateforacoin(self,
                                                                       id,
                                                                       date,
                                                                       localization=None):
        """Does a GET request to /coins/{id}/history.

        Get historical data (name, price, market, stats) at a given date for a
        coin

        Args:
            id (string): pass the coin id (can be obtained from /coins) eg.
                bitcoin
            date (string): The date of data snapshot in dd-mm-yyyy eg.
                30-12-2017
            localization (string, optional): Set to false to exclude localized
                languages in response

        Returns:
            void: Response from the API. Get historical data at a given date
                for a coin

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/history'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'date': date,
            'localization': localization
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def gethistoricalmarketdataincludeprice_marketcap_and_24_hvolume_granularityauto(self,
                                                                                     id,
                                                                                     vs_currency,
                                                                                     days,
                                                                                     interval=None):
        """Does a GET request to /coins/{id}/market_chart.

        Get historical market data include price, market cap, and 24h volume
        (granularity auto)
         <b>Minutely data will be used for duration within 1 day, Hourly data
         will be used for duration between 1 day and 90 days, Daily data will
         be used for duration above 90 days.</b>

        Args:
            id (string): pass the coin id (can be obtained from /coins) eg.
                bitcoin
            vs_currency (string): The target currency of market data (usd,
                eur, jpy, etc.)
            days (string): Data up to number of days ago (eg. 1,14,30,max)
            interval (string, optional): Data interval. Possible value: daily

        Returns:
            void: Response from the API. Get historical market data include
                price, market cap, and 24h volume

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/market_chart'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'vs_currency': vs_currency,
            'days': days,
            'interval': interval
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def gethistoricalmarketdataincludeprice_marketcap_and_24_hvolumewithinarangeoftimestamp_granularityauto(self,
                                                                                                            id,
                                                                                                            vs_currency,
                                                                                                            mfrom,
                                                                                                            to):
        """Does a GET request to /coins/{id}/market_chart/range.

        Get historical market data include price, market cap, and 24h volume
        within a range of timestamp (granularity auto)
         <b><ul><li>Data granularity is automatic (cannot be
         adjusted)</li><li>1 day from query time = 5 minute interval
         data</li><li>1 - 90 days from query time = hourly data</li><li>above
         90 days from query time = daily data (00:00 UTC)</li></ul> </b>

        Args:
            id (string): pass the coin id (can be obtained from /coins) eg.
                bitcoin
            vs_currency (string): The target currency of market data (usd,
                eur, jpy, etc.)
            mfrom (string): From date in UNIX Timestamp (eg. 1392577232)
            to (string): To date in UNIX Timestamp (eg. 1422577232)

        Returns:
            void: Response from the API. Get historical market data include
                price, market cap, and 24h volume

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/market_chart/range'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'vs_currency': vs_currency,
            'from': mfrom,
            'to': to
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getstatusupdatesforagivencoin(self,
                                      id,
                                      per_page=None,
                                      page=None):
        """Does a GET request to /coins/{id}/status_updates.

        Get status updates for a given coin

        Args:
            id (string): pass the coin id (can be obtained from /coins) eg.
                bitcoin
            per_page (int, optional): Total results per page
            page (int, optional): Page through results

        Returns:
            void: Response from the API. Get paginated status updates for a
                given coin

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/status_updates'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'per_page': per_page,
            'page': page
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getcoin_s_ohlc(self,
                       id,
                       vs_currency,
                       days):
        """Does a GET request to /coins/{id}/ohlc.

        Candle's body:
        1 - 2 days: 30 minutes
        3 - 30 days: 4 hours
        31 and before: 4 days

        Args:
            id (string): pass the coin id (can be obtained from /coins/list)
                eg. bitcoin
            vs_currency (string): The target currency of market data (usd,
                eur, jpy, etc.)
            days (int): Data up to number of days ago
                (1/7/14/30/90/180/365/max)

        Returns:
            list of float: Response from the API. successful
                operation

[
1594382400000 (time),
1.1 (open),
 2.2 (high),

                3.3 (low),
 4.4 (close)
]

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/{id}/ohlc'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'vs_currency': vs_currency,
            'days': days
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text)

        return decoded
