# -*- coding: utf-8 -*-

"""
coingeckoapiv3testing

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3testing.api_helper import APIHelper
from coingeckoapiv3testing.configuration import Server
from coingeckoapiv3testing.controllers.base_controller import BaseController


class CategoriesController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3testing API."""

    def __init__(self, config, call_back=None):
        super(CategoriesController, self).__init__(config, call_back)

    def listallcategories(self):
        """Does a GET request to /coins/categories/list.

        List all categories

        Returns:
            void: Response from the API. List all categories

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/categories/list'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listallcategorieswithmarketdata(self,
                                        order=None):
        """Does a GET request to /coins/categories.

        List all categories with market data

        Args:
            order (string, optional): valid values: <b>market_cap_desc
                (default), market_cap_asc, name_desc, name_asc,
                market_cap_change_24h_desc and market_cap_change_24h_asc</b>

        Returns:
            void: Response from the API. List all categories with market data

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/coins/categories'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'order': order
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
