# -*- coding: utf-8 -*-
# *** FORMAT PARAMS ***
# *** SKIP AUTOPEP8 ***






METHODS = [
    'settings', 'setup', 'draw', 'pre_draw', 'post_draw',
    'key_pressed', 'key_typed', 'key_released',
    'mouse_clicked', 'mouse_dragged', 'mouse_moved', 'mouse_entered',
    'mouse_exited', 'mouse_pressed', 'mouse_released', 'mouse_wheel',
    'exiting'
]

FILE_CLASS_LOOKUP = dict([
    (('font.py',), 'Py5Font'),
    (('graphics.py',), 'Py5Graphics'),
    (('image.py',), 'Py5Image'),
    (('shader.py',), 'Py5Shader'),
    (('shape.py',), 'Py5Shape'),
    (('sketch.py',), 'Sketch'),
    (('surface.py',), 'Py5Surface'),
    (('mixins', 'data.py'), 'Sketch'),
    (('mixins', 'math.py'), 'Sketch'),
    (('mixins', 'pixels.py'), 'Sketch'),
    (('mixins', 'threads.py'), 'Sketch'),
])

METHOD_SIGNATURES_LOOKUP = dict([
    (('Sketch', 'alpha'), ['(rgb: int, /) -> float']),
    (('Sketch', 'ambient'), ['(gray: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(rgb: int, /) -> None']),
    (('Sketch', 'ambient_light'), ['(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'apply_matrix'), ['(n00: float, n01: float, n02: float, n10: float, n11: float, n12: float, /) -> None', '(n00: float, n01: float, n02: float, n03: float, n10: float, n11: float, n12: float, n13: float, n20: float, n21: float, n22: float, n23: float, n30: float, n31: float, n32: float, n33: float, /) -> None', '(source: NDArray[(2, 3), Float], /) -> None', '(source: NDArray[(4, 4), Float], /) -> None']),
    (('Sketch', 'arc'), ['(a: float, b: float, c: float, d: float, start: float, stop: float, /) -> None', '(a: float, b: float, c: float, d: float, start: float, stop: float, mode: int, /) -> None']),
    (('Sketch', 'background'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None', '(image: Py5Image, /) -> None']),
    (('Sketch', 'begin_camera'), ['() -> None']),
    (('Sketch', 'begin_contour'), ['() -> None']),
    (('Sketch', 'begin_raw'), ['(renderer: str, filename: str, /) -> Py5Graphics', '(raw_graphics: Py5Graphics, /) -> None']),
    (('Sketch', 'begin_record'), ['(renderer: str, filename: str, /) -> Py5Graphics', '(recorder: Py5Graphics, /) -> None']),
    (('Sketch', 'begin_shape'), ['() -> None', '(kind: int, /) -> None']),
    (('Sketch', 'bezier'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None', '(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, x4: float, y4: float, z4: float, /) -> None']),
    (('Sketch', 'bezier_detail'), ['(detail: int, /) -> None']),
    (('Sketch', 'bezier_point'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Sketch', 'bezier_tangent'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Sketch', 'bezier_vertex'), ['(x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None', '(x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, x4: float, y4: float, z4: float, /) -> None']),
    (('Sketch', 'bezier_vertices'), ['(coordinates: NDArray[(Any, Any), Float], /) -> None']),
    (('Sketch', 'blend'), ['(sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, mode: int, /) -> None', '(src: Py5Image, sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, mode: int, /) -> None']),
    (('Sketch', 'blend_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'blue'), ['(rgb: int, /) -> float']),
    (('Sketch', 'box'), ['(size: float, /) -> None', '(w: float, h: float, d: float, /) -> None']),
    (('Sketch', 'brightness'), ['(rgb: int, /) -> float']),
    (('Sketch', 'camera'), ['() -> None', '(eye_x: float, eye_y: float, eye_z: float, center_x: float, center_y: float, center_z: float, up_x: float, up_y: float, up_z: float, /) -> None']),
    (('Sketch', 'circle'), ['(x: float, y: float, extent: float, /) -> None']),
    (('Sketch', 'clear'), ['() -> None']),
    (('Sketch', 'clip'), ['(a: float, b: float, c: float, d: float, /) -> None']),
    (('Sketch', 'color'), ['(fgray: float, /) -> int', '(fgray: float, falpha: float, /) -> int', '(v1: float, v2: float, v3: float, /) -> int', '(v1: float, v2: float, v3: float, alpha: float, /) -> int', '(gray: int, /) -> int', '(gray: int, alpha: int, /) -> int', '(v1: int, v2: int, v3: int, /) -> int', '(v1: int, v2: int, v3: int, alpha: int, /) -> int']),
    (('Sketch', 'color_mode'), ['(mode: int, /) -> None', '(mode: int, max: float, /) -> None', '(mode: int, max1: float, max2: float, max3: float, /) -> None', '(mode: int, max1: float, max2: float, max3: float, max_a: float, /) -> None']),
    (('Sketch', 'copy'), ['() -> Py5Image', '(sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, /) -> None', '(src: Py5Image, sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, /) -> None']),
    (('Sketch', 'create_font'), ['(name: str, size: float, /) -> Py5Font', '(name: str, size: float, smooth: bool, /) -> Py5Font', '(name: str, size: float, smooth: bool, charset: List[chr], /) -> Py5Font']),
    (('Sketch', 'create_graphics'), ['(w: int, h: int, /) -> Py5Graphics', '(w: int, h: int, renderer: str, /) -> Py5Graphics', '(w: int, h: int, renderer: str, path: str, /) -> Py5Graphics']),
    (('Sketch', 'create_image'), ['(w: int, h: int, format: int, /) -> Py5Image']),
    (('Sketch', 'create_shape'), ['() -> Py5Shape', '(type: int, /) -> Py5Shape', '(kind: int, /, *p: float) -> Py5Shape']),
    (('Sketch', 'cursor'), ['() -> None', '(kind: int, /) -> None', '(img: Py5Image, /) -> None', '(img: Py5Image, x: int, y: int, /) -> None']),
    (('Sketch', 'curve'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None', '(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, x4: float, y4: float, z4: float, /) -> None']),
    (('Sketch', 'curve_detail'), ['(detail: int, /) -> None']),
    (('Sketch', 'curve_point'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Sketch', 'curve_tangent'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Sketch', 'curve_tightness'), ['(tightness: float, /) -> None']),
    (('Sketch', 'curve_vertex'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'curve_vertices'), ['(coordinates: NDArray[(Any, Any), Float], /) -> None']),
    (('Sketch', 'day'), ['() -> int']),
    (('Sketch', 'directional_light'), ['(v1: float, v2: float, v3: float, nx: float, ny: float, nz: float, /) -> None']),
    (('Sketch', 'display_density'), ['() -> int', '(display: int, /) -> int']),
    (('Sketch', 'ellipse'), ['(a: float, b: float, c: float, d: float, /) -> None']),
    (('Sketch', 'ellipse_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'emissive'), ['(gray: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(rgb: int, /) -> None']),
    (('Sketch', 'end_camera'), ['() -> None']),
    (('Sketch', 'end_contour'), ['() -> None']),
    (('Sketch', 'end_raw'), ['() -> None']),
    (('Sketch', 'end_record'), ['() -> None']),
    (('Sketch', 'end_shape'), ['() -> None', '(mode: int, /) -> None']),
    (('Sketch', 'exit_sketch'), ['() -> None']),
    (('Sketch', 'fill'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None']),
    (('Sketch', 'apply_filter'), ['(kind: int, /) -> None', '(kind: int, param: float, /) -> None', '(shader: Py5Shader, /) -> None']),
    (('Sketch', 'frame_rate'), ['(fps: float, /) -> None']),
    (('Sketch', 'frustum'), ['(left: float, right: float, bottom: float, top: float, near: float, far: float, /) -> None']),
    (('Sketch', 'full_screen'), ['() -> None', '(display: int, /) -> None', '(renderer: str, /) -> None', '(renderer: str, display: int, /) -> None']),
    (('Sketch', 'get'), ['() -> Py5Image', '(x: int, y: int, /) -> int', '(x: int, y: int, w: int, h: int, /) -> Py5Image']),
    (('Sketch', 'get_frame_rate'), ['() -> float']),
    (('Sketch', 'get_graphics'), ['() -> Py5Graphics']),
    (('Sketch', 'get_matrix'), ['() -> NDArray[(Any, Any), Float]', '(target: NDArray[(2, 3), Float], /) -> NDArray[(2, 3), Float]', '(target: NDArray[(4, 4), Float], /) -> NDArray[(4, 4), Float]']),
    (('Sketch', 'get_surface'), ['() -> Py5Surface']),
    (('Sketch', 'green'), ['(rgb: int, /) -> float']),
    (('Sketch', 'hint'), ['(which: int, /) -> None']),
    (('Sketch', 'hour'), ['() -> int']),
    (('Sketch', 'hue'), ['(rgb: int, /) -> float']),
    (('Sketch', 'image'), ['(img: Py5Image, a: float, b: float, /) -> None', '(img: Py5Image, a: float, b: float, c: float, d: float, /) -> None', '(img: Py5Image, a: float, b: float, c: float, d: float, u1: int, v1: int, u2: int, v2: int, /) -> None']),
    (('Sketch', 'image_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'is_key_pressed'), ['() -> bool']),
    (('Sketch', 'is_mouse_pressed'), ['() -> bool']),
    (('Sketch', 'lerp_color'), ['(c1: int, c2: int, amt: float, /) -> int', '(c1: int, c2: int, amt: float, mode: int, /) -> int']),
    (('Sketch', 'light_falloff'), ['(constant: float, linear: float, quadratic: float, /) -> None']),
    (('Sketch', 'light_specular'), ['(v1: float, v2: float, v3: float, /) -> None']),
    (('Sketch', 'lights'), ['() -> None']),
    (('Sketch', 'line'), ['(x1: float, y1: float, x2: float, y2: float, /) -> None', '(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, /) -> None']),
    (('Sketch', 'lines'), ['(coordinates: NDArray[(Any, Any), Float], /) -> None']),
    (('Sketch', 'load_font'), ['(filename: str, /) -> Py5Font']),
    (('Sketch', 'load_pixels'), ['() -> None']),
    (('Sketch', 'load_shader'), ['(frag_filename: str, /) -> Py5Shader', '(frag_filename: str, vert_filename: str, /) -> Py5Shader']),
    (('Sketch', 'load_shape'), ['(filename: str, /) -> Py5Shape', '(filename: str, options: str, /) -> Py5Shape']),
    (('Sketch', 'loop'), ['() -> None']),
    (('Sketch', 'millis'), ['() -> int']),
    (('Sketch', 'minute'), ['() -> int']),
    (('Sketch', 'model_x'), ['(x: float, y: float, z: float, /) -> float']),
    (('Sketch', 'model_y'), ['(x: float, y: float, z: float, /) -> float']),
    (('Sketch', 'model_z'), ['(x: float, y: float, z: float, /) -> float']),
    (('Sketch', 'month'), ['() -> int']),
    (('Sketch', 'no_clip'), ['() -> None']),
    (('Sketch', 'no_cursor'), ['() -> None']),
    (('Sketch', 'no_fill'), ['() -> None']),
    (('Sketch', 'no_lights'), ['() -> None']),
    (('Sketch', 'no_loop'), ['() -> None']),
    (('Sketch', 'no_smooth'), ['() -> None']),
    (('Sketch', 'no_stroke'), ['() -> None']),
    (('Sketch', 'no_texture'), ['() -> None']),
    (('Sketch', 'no_tint'), ['() -> None']),
    (('Sketch', 'normal'), ['(nx: float, ny: float, nz: float, /) -> None']),
    (('Sketch', 'ortho'), ['() -> None', '(left: float, right: float, bottom: float, top: float, /) -> None', '(left: float, right: float, bottom: float, top: float, near: float, far: float, /) -> None']),
    (('Sketch', 'pause'), ['() -> None']),
    (('Sketch', 'perspective'), ['() -> None', '(fovy: float, aspect: float, z_near: float, z_far: float, /) -> None']),
    (('Sketch', 'pixel_density'), ['(density: int, /) -> None']),
    (('Sketch', 'point'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'point_light'), ['(v1: float, v2: float, v3: float, x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'points'), ['(coordinates: NDArray[(Any, Any), Float], /) -> None']),
    (('Sketch', 'pop'), ['() -> None']),
    (('Sketch', 'pop_matrix'), ['() -> None']),
    (('Sketch', 'pop_style'), ['() -> None']),
    (('Sketch', 'print_camera'), ['() -> None']),
    (('Sketch', 'print_matrix'), ['() -> None']),
    (('Sketch', 'print_projection'), ['() -> None']),
    (('Sketch', 'push'), ['() -> None']),
    (('Sketch', 'push_matrix'), ['() -> None']),
    (('Sketch', 'push_style'), ['() -> None']),
    (('Sketch', 'quad'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None']),
    (('Sketch', 'quadratic_vertex'), ['(cx: float, cy: float, x3: float, y3: float, /) -> None', '(cx: float, cy: float, cz: float, x3: float, y3: float, z3: float, /) -> None']),
    (('Sketch', 'quadratic_vertices'), ['(coordinates: NDArray[(Any, Any), Float], /) -> None']),
    (('Sketch', 'rect'), ['(a: float, b: float, c: float, d: float, /) -> None', '(a: float, b: float, c: float, d: float, r: float, /) -> None', '(a: float, b: float, c: float, d: float, tl: float, tr: float, br: float, bl: float, /) -> None']),
    (('Sketch', 'rect_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'red'), ['(rgb: int, /) -> float']),
    (('Sketch', 'redraw'), ['() -> None']),
    (('Sketch', 'reset_matrix'), ['() -> None']),
    (('Sketch', 'reset_shader'), ['() -> None', '(kind: int, /) -> None']),
    (('Sketch', 'resume'), ['() -> None']),
    (('Sketch', 'rotate'), ['(angle: float, /) -> None', '(angle: float, x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'rotate_x'), ['(angle: float, /) -> None']),
    (('Sketch', 'rotate_y'), ['(angle: float, /) -> None']),
    (('Sketch', 'rotate_z'), ['(angle: float, /) -> None']),
    (('Sketch', 'saturation'), ['(rgb: int, /) -> float']),
    (('Sketch', 'scale'), ['(s: float, /) -> None', '(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'screen_x'), ['(x: float, y: float, /) -> float', '(x: float, y: float, z: float, /) -> float']),
    (('Sketch', 'screen_y'), ['(x: float, y: float, /) -> float', '(x: float, y: float, z: float, /) -> float']),
    (('Sketch', 'screen_z'), ['(x: float, y: float, z: float, /) -> float']),
    (('Sketch', 'second'), ['() -> int']),
    (('Sketch', 'set_matrix'), ['(source: NDArray[(2, 3), Float], /) -> None', '(source: NDArray[(4, 4), Float], /) -> None']),
    (('Sketch', 'shader'), ['(shader: Py5Shader, /) -> None', '(shader: Py5Shader, kind: int, /) -> None']),
    (('Sketch', 'shape'), ['(shape: Py5Shape, /) -> None', '(shape: Py5Shape, x: float, y: float, /) -> None', '(shape: Py5Shape, a: float, b: float, c: float, d: float, /) -> None']),
    (('Sketch', 'shape_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'shear_x'), ['(angle: float, /) -> None']),
    (('Sketch', 'shear_y'), ['(angle: float, /) -> None']),
    (('Sketch', 'shininess'), ['(shine: float, /) -> None']),
    (('Sketch', 'size'), ['(width: int, height: int, /) -> None', '(width: int, height: int, renderer: str, /) -> None', '(width: int, height: int, renderer: str, path: str, /) -> None']),
    (('Sketch', 'sketch_path'), ['() -> str', '(where: str, /) -> str']),
    (('Sketch', 'smooth'), ['() -> None', '(level: int, /) -> None']),
    (('Sketch', 'specular'), ['(gray: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(rgb: int, /) -> None']),
    (('Sketch', 'sphere'), ['(r: float, /) -> None']),
    (('Sketch', 'sphere_detail'), ['(res: int, /) -> None', '(ures: int, vres: int, /) -> None']),
    (('Sketch', 'spot_light'), ['(v1: float, v2: float, v3: float, x: float, y: float, z: float, nx: float, ny: float, nz: float, angle: float, concentration: float, /) -> None']),
    (('Sketch', 'square'), ['(x: float, y: float, extent: float, /) -> None']),
    (('Sketch', 'start'), ['() -> None']),
    (('Sketch', 'stop'), ['() -> None']),
    (('Sketch', 'stroke'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None']),
    (('Sketch', 'stroke_cap'), ['(cap: int, /) -> None']),
    (('Sketch', 'stroke_join'), ['(join: int, /) -> None']),
    (('Sketch', 'stroke_weight'), ['(weight: float, /) -> None']),
    (('Sketch', 'text'), ['(c: chr, x: float, y: float, /) -> None', '(c: chr, x: float, y: float, z: float, /) -> None', '(chars: List[chr], start: int, stop: int, x: float, y: float, /) -> None', '(chars: List[chr], start: int, stop: int, x: float, y: float, z: float, /) -> None', '(num: float, x: float, y: float, /) -> None', '(num: float, x: float, y: float, z: float, /) -> None', '(num: int, x: float, y: float, /) -> None', '(num: int, x: float, y: float, z: float, /) -> None', '(str: str, x: float, y: float, /) -> None', '(str: str, x: float, y: float, z: float, /) -> None', '(str: str, x1: float, y1: float, x2: float, y2: float, /) -> None']),
    (('Sketch', 'text_align'), ['(align_x: int, /) -> None', '(align_x: int, align_y: int, /) -> None']),
    (('Sketch', 'text_ascent'), ['() -> float']),
    (('Sketch', 'text_descent'), ['() -> float']),
    (('Sketch', 'text_font'), ['(which: Py5Font, /) -> None', '(which: Py5Font, size: float, /) -> None']),
    (('Sketch', 'text_leading'), ['(leading: float, /) -> None']),
    (('Sketch', 'text_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'text_size'), ['(size: float, /) -> None']),
    (('Sketch', 'text_width'), ['(c: chr, /) -> float', '(chars: List[chr], start: int, length: int, /) -> float', '(str: str, /) -> float']),
    (('Sketch', 'texture'), ['(image: Py5Image, /) -> None']),
    (('Sketch', 'texture_mode'), ['(mode: int, /) -> None']),
    (('Sketch', 'texture_wrap'), ['(wrap: int, /) -> None']),
    (('Sketch', 'tint'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None']),
    (('Sketch', 'translate'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Sketch', 'triangle'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, /) -> None']),
    (('Sketch', 'update_pixels'), ['() -> None', '(x1: int, y1: int, x2: int, y2: int, /) -> None']),
    (('Sketch', 'vertex'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None', '(x: float, y: float, u: float, v: float, /) -> None', '(x: float, y: float, z: float, u: float, v: float, /) -> None', '(v: NDArray[(Any,), Float], /) -> None']),
    (('Sketch', 'vertices'), ['(coordinates: NDArray[(Any, Any), Float], /) -> None']),
    (('Sketch', 'year'), ['() -> int']),
    (('Sketch', 'load_json'), ['(filename: Union[str, Path], kwargs: Dict[str, Any]) -> Any']),
    (('Sketch', 'save_json'), ['(json_data: Any, filename: Union[str, Path], kwargs: Dict[str, Any]) -> None']),
    (('Sketch', 'parse_json'), ['(serialized_json: Any, kwargs: Dict[str, Any]) -> Any']),
    (('Sketch', 'sin'), ['(angle: float) -> float']),
    (('Sketch', 'cos'), ['(angle: float) -> float']),
    (('Sketch', 'tan'), ['(angle: float) -> float']),
    (('Sketch', 'asin'), ['(value: float) -> float']),
    (('Sketch', 'acos'), ['(value: float) -> float']),
    (('Sketch', 'atan'), ['(value: float) -> float']),
    (('Sketch', 'atan2'), ['(y: float, x: float) -> float']),
    (('Sketch', 'degrees'), ['(radians: float) -> float']),
    (('Sketch', 'radians'), ['(degrees: float) -> float']),
    (('Sketch', 'constrain'), ['(amt: float, low: float, high: float) -> float']),
    (('Sketch', 'remap'), ['(value: float, start1: float, stop1: float, start2: float, stop2: float) -> float']),
    (('Sketch', 'dist'), ['(args: float) -> float']),
    (('Sketch', 'lerp'), ['(start: float, stop: float, amt: float) -> float']),
    (('Sketch', 'mag'), ['(args: float) -> float']),
    (('Sketch', 'norm'), ['(value: float, start: float, stop: float) -> float']),
    (('Sketch', 'sq'), ['(value: float) -> float']),
    (('Sketch', 'sqrt'), ['(value: float) -> Union[float, complex]']),
    (('Sketch', 'floor'), ['(value: float) -> int']),
    (('Sketch', 'ceil'), ['(value: float) -> int']),
    (('Sketch', 'exp'), ['(value: float) -> float']),
    (('Sketch', 'log'), ['(value: float) -> float']),
    (('Sketch', 'random'), ['(high: float) -> float', '(low: float, high: float) -> float']),
    (('Sketch', 'random_seed'), ['(seed: int) -> None']),
    (('Sketch', 'random_gaussian'), ['() -> float']),
    (('Sketch', 'noise'), ['(x, **kwargs) -> float', '(x, y, **kwargs) -> float', '(x, y, z, **kwargs) -> float', '(x, y, z, w, **kwargs) -> float']),
    (('Sketch', 'noise_mode'), ['(mode: int) -> None']),
    (('Sketch', 'noise_detail'), ['(octaves: float, persistence: float, lacunarity: float) -> None']),
    (('Sketch', 'noise_seed'), ['(seed: float) -> None']),
    (('Sketch', 'launch_thread'), ['(f: Callable, name: str, daemon: bool, args: Tuple, kwargs: Dict) -> str']),
    (('Sketch', 'launch_promise_thread'), ['(f: Callable, name: str, daemon: bool, args: Tuple, kwargs: Dict) -> Py5Promise']),
    (('Sketch', 'launch_repeating_thread'), ['(f: Callable, name: str, time_delay: float, daemon: bool, args: Tuple, kwargs: Dict) -> str']),
    (('Sketch', 'has_thread'), ['(name: str) -> None']),
    (('Sketch', 'stop_thread'), ['(name: str, wait: bool) -> None']),
    (('Sketch', 'stop_all_threads'), ['(wait: bool) -> None']),
    (('Sketch', 'list_threads'), ['() -> None']),
    (('Sketch', 'load_np_pixels'), ['() -> None']),
    (('Sketch', 'update_np_pixels'), ['() -> None']),
    (('Sketch', 'set_np_pixels'), ['(array: np.ndarray, bands: str) -> None']),
    (('Sketch', 'save'), ['(filename: Union[str, Path], format: str, drop_alpha: bool, params) -> None']),
    (('Sketch', 'hot_reload_draw'), ['(draw: Callable) -> None']),
    (('Sketch', 'profile_functions'), ['(function_names: List[str]) -> None']),
    (('Sketch', 'profile_draw'), ['() -> None']),
    (('Sketch', 'print_line_profiler_stats'), ['() -> None']),
    (('Sketch', 'save_frame'), ['(filename: Union[str, Path], format: str, drop_alpha: bool, params) -> None']),
    (('Sketch', 'create_image_from_numpy'), ['(numpy_image: NumpyImageArray, dst: Py5Image) -> Py5Image']),
    (('Sketch', 'convert_image'), ['(obj: Any, dst: Py5Image) -> Py5Image']),
    (('Sketch', 'load_image'), ['(filename: Union[str, Path], dst: Py5Image) -> Py5Image']),
    (('Sketch', 'request_image'), ['(filename: Union[str, Path]) -> Py5Promise']),
    (('Py5Shader', 'set'), ['(name: str, x: bool, /) -> None', '(name: str, x: bool, y: bool, /) -> None', '(name: str, x: bool, y: bool, z: bool, /) -> None', '(name: str, x: bool, y: bool, z: bool, w: bool, /) -> None', '(name: str, vec: JArray(JBoolean), /) -> None', '(name: str, boolvec: JArray(JBoolean), ncoords: int, /) -> None', '(name: str, x: float, /) -> None', '(name: str, x: float, y: float, /) -> None', '(name: str, x: float, y: float, z: float, /) -> None', '(name: str, x: float, y: float, z: float, w: float, /) -> None', '(name: str, vec: NDArray[(Any,), Float], /) -> None', '(name: str, vec: NDArray[(Any,), Float], ncoords: int, /) -> None', '(name: str, x: int, /) -> None', '(name: str, x: int, y: int, /) -> None', '(name: str, x: int, y: int, z: int, /) -> None', '(name: str, x: int, y: int, z: int, w: int, /) -> None', '(name: str, vec: JArray(JInt), /) -> None', '(name: str, vec: JArray(JInt), ncoords: int, /) -> None', '(name: str, tex: Py5Image, /) -> None', '(name: str, mat: NDArray[(2, 3), Float], /) -> None', '(name: str, mat: NDArray[(4, 4), Float], /) -> None', '(name: str, mat: NDArray[(4, 4), Float], use3x3: bool, /) -> None']),
    (('Py5Shape', 'add_child'), ['(who: Py5Shape, /) -> None', '(who: Py5Shape, idx: int, /) -> None']),
    (('Py5Shape', 'add_name'), ['(nom: str, shape: Py5Shape, /) -> None']),
    (('Py5Shape', 'apply_matrix'), ['(n00: float, n01: float, n02: float, n10: float, n11: float, n12: float, /) -> None', '(n00: float, n01: float, n02: float, n03: float, n10: float, n11: float, n12: float, n13: float, n20: float, n21: float, n22: float, n23: float, n30: float, n31: float, n32: float, n33: float, /) -> None', '(source: NDArray[(2, 3), Float], /) -> None', '(source: NDArray[(4, 4), Float], /) -> None']),
    (('Py5Shape', 'attrib'), ['(name: str, /, *values: bool) -> None', '(name: str, /, *values: float) -> None', '(name: str, /, *values: int) -> None']),
    (('Py5Shape', 'attrib_color'), ['(name: str, color: int, /) -> None']),
    (('Py5Shape', 'attrib_normal'), ['(name: str, nx: float, ny: float, nz: float, /) -> None']),
    (('Py5Shape', 'attrib_position'), ['(name: str, x: float, y: float, z: float, /) -> None']),
    (('Py5Shape', 'begin_shape'), ['() -> None', '(kind: int, /) -> None']),
    (('Py5Shape', 'bezier_detail'), ['(detail: int, /) -> None']),
    (('Py5Shape', 'contains'), ['(x: float, y: float, /) -> bool']),
    (('Py5Shape', 'disable_style'), ['() -> None']),
    (('Py5Shape', 'enable_style'), ['() -> None']),
    (('Py5Shape', 'end_shape'), ['() -> None', '(mode: int, /) -> None']),
    (('Py5Shape', 'find_child'), ['(target: str, /) -> Py5Shape']),
    (('Py5Shape', 'get_ambient'), ['(index: int, /) -> int']),
    (('Py5Shape', 'get_child'), ['(index: int, /) -> Py5Shape', '(target: str, /) -> Py5Shape']),
    (('Py5Shape', 'get_child_count'), ['() -> int']),
    (('Py5Shape', 'get_child_index'), ['(who: Py5Shape, /) -> int']),
    (('Py5Shape', 'get_children'), ['() -> List[Py5Shape]']),
    (('Py5Shape', 'get_depth'), ['() -> float']),
    (('Py5Shape', 'get_emissive'), ['(index: int, /) -> int']),
    (('Py5Shape', 'get_family'), ['() -> int']),
    (('Py5Shape', 'get_fill'), ['(index: int, /) -> int']),
    (('Py5Shape', 'get_height'), ['() -> float']),
    (('Py5Shape', 'get_kind'), ['() -> int']),
    (('Py5Shape', 'get_name'), ['() -> str']),
    (('Py5Shape', 'get_normal'), ['(index: int, /) -> NDArray[(Any,), Float]', '(index: int, vec: NDArray[(Any,), Float], /) -> NDArray[(Any,), Float]']),
    (('Py5Shape', 'get_normal_x'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_normal_y'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_normal_z'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_parent'), ['() -> Py5Shape']),
    (('Py5Shape', 'get_shininess'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_specular'), ['(index: int, /) -> int']),
    (('Py5Shape', 'get_stroke'), ['(index: int, /) -> int']),
    (('Py5Shape', 'get_stroke_weight'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_tessellation'), ['() -> Py5Shape']),
    (('Py5Shape', 'get_texture_u'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_texture_v'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_tint'), ['(index: int, /) -> int']),
    (('Py5Shape', 'get_vertex'), ['(index: int, /) -> NDArray[(Any,), Float]', '(index: int, vec: NDArray[(Any,), Float], /) -> NDArray[(Any,), Float]']),
    (('Py5Shape', 'get_vertex_count'), ['() -> int']),
    (('Py5Shape', 'get_vertex_x'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_vertex_y'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_vertex_z'), ['(index: int, /) -> float']),
    (('Py5Shape', 'get_width'), ['() -> float']),
    (('Py5Shape', 'is2d'), ['() -> bool']),
    (('Py5Shape', 'is3d'), ['() -> bool']),
    (('Py5Shape', 'is_closed'), ['() -> bool']),
    (('Py5Shape', 'is_visible'), ['() -> bool']),
    (('Py5Shape', 'remove_child'), ['(idx: int, /) -> None']),
    (('Py5Shape', 'reset_matrix'), ['() -> None']),
    (('Py5Shape', 'rotate'), ['(angle: float, /) -> None', '(angle: float, v0: float, v1: float, v2: float, /) -> None']),
    (('Py5Shape', 'rotate_x'), ['(angle: float, /) -> None']),
    (('Py5Shape', 'rotate_y'), ['(angle: float, /) -> None']),
    (('Py5Shape', 'rotate_z'), ['(angle: float, /) -> None']),
    (('Py5Shape', 'scale'), ['(s: float, /) -> None', '(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Py5Shape', 'set_ambient'), ['(ambient: int, /) -> None', '(index: int, ambient: int, /) -> None']),
    (('Py5Shape', 'set_attrib'), ['(name: str, index: int, /, *values: bool) -> None', '(name: str, index: int, /, *values: float) -> None', '(name: str, index: int, /, *values: int) -> None']),
    (('Py5Shape', 'set_emissive'), ['(emissive: int, /) -> None', '(index: int, emissive: int, /) -> None']),
    (('Py5Shape', 'set_fill'), ['(fill: bool, /) -> None', '(fill: int, /) -> None', '(index: int, fill: int, /) -> None']),
    (('Py5Shape', 'set_name'), ['(name: str, /) -> None']),
    (('Py5Shape', 'set_normal'), ['(index: int, nx: float, ny: float, nz: float, /) -> None']),
    (('Py5Shape', 'set_shininess'), ['(shine: float, /) -> None', '(index: int, shine: float, /) -> None']),
    (('Py5Shape', 'set_specular'), ['(specular: int, /) -> None', '(index: int, specular: int, /) -> None']),
    (('Py5Shape', 'set_stroke'), ['(stroke: bool, /) -> None', '(stroke: int, /) -> None', '(index: int, stroke: int, /) -> None']),
    (('Py5Shape', 'set_stroke_cap'), ['(cap: int, /) -> None']),
    (('Py5Shape', 'set_stroke_join'), ['(join: int, /) -> None']),
    (('Py5Shape', 'set_stroke_weight'), ['(weight: float, /) -> None', '(index: int, weight: float, /) -> None']),
    (('Py5Shape', 'set_texture'), ['(tex: Py5Image, /) -> None']),
    (('Py5Shape', 'set_texture_mode'), ['(mode: int, /) -> None']),
    (('Py5Shape', 'set_texture_uv'), ['(index: int, u: float, v: float, /) -> None']),
    (('Py5Shape', 'set_tint'), ['(tint: bool, /) -> None', '(fill: int, /) -> None', '(index: int, tint: int, /) -> None']),
    (('Py5Shape', 'set_vertex'), ['(index: int, x: float, y: float, /) -> None', '(index: int, x: float, y: float, z: float, /) -> None', '(index: int, vec: NDArray[(Any,), Float], /) -> None']),
    (('Py5Shape', 'set_visible'), ['(visible: bool, /) -> None']),
    (('Py5Shape', 'translate'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Py5Font', 'ascent'), ['() -> float']),
    (('Py5Font', 'descent'), ['() -> float']),
    (('Py5Font', 'get_default_size'), ['() -> int']),
    (('Py5Font', 'get_glyph_count'), ['() -> int']),
    (('Py5Font', 'get_name'), ['() -> str']),
    (('Py5Font', 'get_post_script_name'), ['() -> str']),
    (('Py5Font', 'get_shape'), ['(ch: chr, /) -> Py5Shape', '(ch: chr, detail: float, /) -> Py5Shape']),
    (('Py5Font', 'get_size'), ['() -> int']),
    (('Py5Font', 'is_smooth'), ['() -> bool']),
    (('Py5Font', 'is_stream'), ['() -> bool']),
    (('Py5Font', 'list'), ['() -> List[str]']),
    (('Py5Font', 'set_subsetting'), ['() -> None']),
    (('Py5Font', 'width'), ['(c: chr, /) -> float']),
    (('Py5Surface', 'get_native'), ['() -> Any']),
    (('Py5Surface', 'is_stopped'), ['() -> bool']),
    (('Py5Surface', 'open_link'), ['(url: str, /) -> bool']),
    (('Py5Surface', 'pause_thread'), ['() -> None']),
    (('Py5Surface', 'resume_thread'), ['() -> None']),
    (('Py5Surface', 'set_always_on_top'), ['(always: bool, /) -> None']),
    (('Py5Surface', 'set_icon'), ['(icon: Py5Image, /) -> None']),
    (('Py5Surface', 'set_location'), ['(x: int, y: int, /) -> None']),
    (('Py5Surface', 'set_resizable'), ['(resizable: bool, /) -> None']),
    (('Py5Surface', 'set_size'), ['(width: int, height: int, /) -> None']),
    (('Py5Surface', 'set_title'), ['(title: str, /) -> None']),
    (('Py5Surface', 'set_visible'), ['(visible: bool, /) -> None']),
    (('Py5Surface', 'stop_thread'), ['() -> bool']),
    (('Py5Graphics', 'alpha'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'ambient'), ['(gray: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(rgb: int, /) -> None']),
    (('Py5Graphics', 'ambient_light'), ['(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'apply_matrix'), ['(n00: float, n01: float, n02: float, n10: float, n11: float, n12: float, /) -> None', '(n00: float, n01: float, n02: float, n03: float, n10: float, n11: float, n12: float, n13: float, n20: float, n21: float, n22: float, n23: float, n30: float, n31: float, n32: float, n33: float, /) -> None', '(source: NDArray[(2, 3), Float], /) -> None', '(source: NDArray[(4, 4), Float], /) -> None']),
    (('Py5Graphics', 'arc'), ['(a: float, b: float, c: float, d: float, start: float, stop: float, /) -> None', '(a: float, b: float, c: float, d: float, start: float, stop: float, mode: int, /) -> None']),
    (('Py5Graphics', 'background'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None', '(image: Py5Image, /) -> None']),
    (('Py5Graphics', 'begin_camera'), ['() -> None']),
    (('Py5Graphics', 'begin_contour'), ['() -> None']),
    (('Py5Graphics', 'begin_draw'), ['() -> None']),
    (('Py5Graphics', 'begin_raw'), ['(raw_graphics: Py5Graphics, /) -> None']),
    (('Py5Graphics', 'begin_shape'), ['() -> None', '(kind: int, /) -> None']),
    (('Py5Graphics', 'bezier'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None', '(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, x4: float, y4: float, z4: float, /) -> None']),
    (('Py5Graphics', 'bezier_detail'), ['(detail: int, /) -> None']),
    (('Py5Graphics', 'bezier_point'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Py5Graphics', 'bezier_tangent'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Py5Graphics', 'bezier_vertex'), ['(x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None', '(x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, x4: float, y4: float, z4: float, /) -> None']),
    (('Py5Graphics', 'blend'), ['(sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, mode: int, /) -> None', '(src: Py5Image, sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, mode: int, /) -> None']),
    (('Py5Graphics', 'blend_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'blue'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'box'), ['(size: float, /) -> None', '(w: float, h: float, d: float, /) -> None']),
    (('Py5Graphics', 'brightness'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'camera'), ['() -> None', '(eye_x: float, eye_y: float, eye_z: float, center_x: float, center_y: float, center_z: float, up_x: float, up_y: float, up_z: float, /) -> None']),
    (('Py5Graphics', 'circle'), ['(x: float, y: float, extent: float, /) -> None']),
    (('Py5Graphics', 'clear'), ['() -> None']),
    (('Py5Graphics', 'clip'), ['(a: float, b: float, c: float, d: float, /) -> None']),
    (('Py5Graphics', 'color'), ['(gray: float, /) -> int', '(gray: float, alpha: float, /) -> int', '(v1: float, v2: float, v3: float, /) -> int', '(v1: float, v2: float, v3: float, a: float, /) -> int', '(c: int, /) -> int', '(c: int, alpha: float, /) -> int', '(c: int, alpha: int, /) -> int', '(v1: int, v2: int, v3: int, /) -> int', '(v1: int, v2: int, v3: int, a: int, /) -> int']),
    (('Py5Graphics', 'color_mode'), ['(mode: int, /) -> None', '(mode: int, max: float, /) -> None', '(mode: int, max1: float, max2: float, max3: float, /) -> None', '(mode: int, max1: float, max2: float, max3: float, max_a: float, /) -> None']),
    (('Py5Graphics', 'copy'), ['() -> Py5Image', '(sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, /) -> None', '(src: Py5Image, sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, /) -> None']),
    (('Py5Graphics', 'create_shape'), ['() -> Py5Shape', '(type: int, /) -> Py5Shape', '(kind: int, /, *p: float) -> Py5Shape']),
    (('Py5Graphics', 'curve'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None', '(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, x4: float, y4: float, z4: float, /) -> None']),
    (('Py5Graphics', 'curve_detail'), ['(detail: int, /) -> None']),
    (('Py5Graphics', 'curve_point'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Py5Graphics', 'curve_tangent'), ['(a: float, b: float, c: float, d: float, t: float, /) -> float']),
    (('Py5Graphics', 'curve_tightness'), ['(tightness: float, /) -> None']),
    (('Py5Graphics', 'curve_vertex'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'directional_light'), ['(v1: float, v2: float, v3: float, nx: float, ny: float, nz: float, /) -> None']),
    (('Py5Graphics', 'ellipse'), ['(a: float, b: float, c: float, d: float, /) -> None']),
    (('Py5Graphics', 'ellipse_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'emissive'), ['(gray: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(rgb: int, /) -> None']),
    (('Py5Graphics', 'end_camera'), ['() -> None']),
    (('Py5Graphics', 'end_contour'), ['() -> None']),
    (('Py5Graphics', 'end_draw'), ['() -> None']),
    (('Py5Graphics', 'end_raw'), ['() -> None']),
    (('Py5Graphics', 'end_shape'), ['() -> None', '(mode: int, /) -> None']),
    (('Py5Graphics', 'fill'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None']),
    (('Py5Graphics', 'apply_filter'), ['(kind: int, /) -> None', '(kind: int, param: float, /) -> None', '(shader: Py5Shader, /) -> None']),
    (('Py5Graphics', 'frustum'), ['(left: float, right: float, bottom: float, top: float, near: float, far: float, /) -> None']),
    (('Py5Graphics', 'get'), ['() -> Py5Image', '(x: int, y: int, /) -> int', '(x: int, y: int, w: int, h: int, /) -> Py5Image']),
    (('Py5Graphics', 'get_matrix'), ['() -> NDArray[(Any, Any), Float]', '(target: NDArray[(2, 3), Float], /) -> NDArray[(2, 3), Float]', '(target: NDArray[(4, 4), Float], /) -> NDArray[(4, 4), Float]']),
    (('Py5Graphics', 'green'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'hint'), ['(which: int, /) -> None']),
    (('Py5Graphics', 'hue'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'image'), ['(img: Py5Image, a: float, b: float, /) -> None', '(img: Py5Image, a: float, b: float, c: float, d: float, /) -> None', '(img: Py5Image, a: float, b: float, c: float, d: float, u1: int, v1: int, u2: int, v2: int, /) -> None']),
    (('Py5Graphics', 'image_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'lerp_color'), ['(c1: int, c2: int, amt: float, /) -> int', '(c1: int, c2: int, amt: float, mode: int, /) -> int']),
    (('Py5Graphics', 'light_falloff'), ['(constant: float, linear: float, quadratic: float, /) -> None']),
    (('Py5Graphics', 'light_specular'), ['(v1: float, v2: float, v3: float, /) -> None']),
    (('Py5Graphics', 'lights'), ['() -> None']),
    (('Py5Graphics', 'line'), ['(x1: float, y1: float, x2: float, y2: float, /) -> None', '(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, /) -> None']),
    (('Py5Graphics', 'load_pixels'), ['() -> None']),
    (('Py5Graphics', 'load_shader'), ['(frag_filename: str, /) -> Py5Shader', '(frag_filename: str, vert_filename: str, /) -> Py5Shader']),
    (('Py5Graphics', 'load_shape'), ['(filename: str, /) -> Py5Shape', '(filename: str, options: str, /) -> Py5Shape']),
    (('Py5Graphics', 'mask'), ['(mask_array: JArray(JInt), /) -> None', '(img: Py5Image, /) -> None']),
    (('Py5Graphics', 'model_x'), ['(x: float, y: float, z: float, /) -> float']),
    (('Py5Graphics', 'model_y'), ['(x: float, y: float, z: float, /) -> float']),
    (('Py5Graphics', 'model_z'), ['(x: float, y: float, z: float, /) -> float']),
    (('Py5Graphics', 'no_clip'), ['() -> None']),
    (('Py5Graphics', 'no_fill'), ['() -> None']),
    (('Py5Graphics', 'no_lights'), ['() -> None']),
    (('Py5Graphics', 'no_smooth'), ['() -> None']),
    (('Py5Graphics', 'no_stroke'), ['() -> None']),
    (('Py5Graphics', 'no_texture'), ['() -> None']),
    (('Py5Graphics', 'no_tint'), ['() -> None']),
    (('Py5Graphics', 'normal'), ['(nx: float, ny: float, nz: float, /) -> None']),
    (('Py5Graphics', 'ortho'), ['() -> None', '(left: float, right: float, bottom: float, top: float, /) -> None', '(left: float, right: float, bottom: float, top: float, near: float, far: float, /) -> None']),
    (('Py5Graphics', 'perspective'), ['() -> None', '(fovy: float, aspect: float, z_near: float, z_far: float, /) -> None']),
    (('Py5Graphics', 'point'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'point_light'), ['(v1: float, v2: float, v3: float, x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'pop'), ['() -> None']),
    (('Py5Graphics', 'pop_matrix'), ['() -> None']),
    (('Py5Graphics', 'pop_style'), ['() -> None']),
    (('Py5Graphics', 'print_camera'), ['() -> None']),
    (('Py5Graphics', 'print_matrix'), ['() -> None']),
    (('Py5Graphics', 'print_projection'), ['() -> None']),
    (('Py5Graphics', 'push'), ['() -> None']),
    (('Py5Graphics', 'push_matrix'), ['() -> None']),
    (('Py5Graphics', 'push_style'), ['() -> None']),
    (('Py5Graphics', 'quad'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float, /) -> None']),
    (('Py5Graphics', 'quadratic_vertex'), ['(cx: float, cy: float, x3: float, y3: float, /) -> None', '(cx: float, cy: float, cz: float, x3: float, y3: float, z3: float, /) -> None']),
    (('Py5Graphics', 'rect'), ['(a: float, b: float, c: float, d: float, /) -> None', '(a: float, b: float, c: float, d: float, r: float, /) -> None', '(a: float, b: float, c: float, d: float, tl: float, tr: float, br: float, bl: float, /) -> None']),
    (('Py5Graphics', 'rect_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'red'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'reset_matrix'), ['() -> None']),
    (('Py5Graphics', 'reset_shader'), ['() -> None', '(kind: int, /) -> None']),
    (('Py5Graphics', 'rotate'), ['(angle: float, /) -> None', '(angle: float, x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'rotate_x'), ['(angle: float, /) -> None']),
    (('Py5Graphics', 'rotate_y'), ['(angle: float, /) -> None']),
    (('Py5Graphics', 'rotate_z'), ['(angle: float, /) -> None']),
    (('Py5Graphics', 'saturation'), ['(rgb: int, /) -> float']),
    (('Py5Graphics', 'scale'), ['(s: float, /) -> None', '(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'screen_x'), ['(x: float, y: float, /) -> float', '(x: float, y: float, z: float, /) -> float']),
    (('Py5Graphics', 'screen_y'), ['(x: float, y: float, /) -> float', '(x: float, y: float, z: float, /) -> float']),
    (('Py5Graphics', 'screen_z'), ['(x: float, y: float, z: float, /) -> float']),
    (('Py5Graphics', 'set_matrix'), ['(source: NDArray[(2, 3), Float], /) -> None', '(source: NDArray[(4, 4), Float], /) -> None']),
    (('Py5Graphics', 'shader'), ['(shader: Py5Shader, /) -> None', '(shader: Py5Shader, kind: int, /) -> None']),
    (('Py5Graphics', 'shape'), ['(shape: Py5Shape, /) -> None', '(shape: Py5Shape, x: float, y: float, /) -> None', '(shape: Py5Shape, a: float, b: float, c: float, d: float, /) -> None']),
    (('Py5Graphics', 'shape_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'shear_x'), ['(angle: float, /) -> None']),
    (('Py5Graphics', 'shear_y'), ['(angle: float, /) -> None']),
    (('Py5Graphics', 'shininess'), ['(shine: float, /) -> None']),
    (('Py5Graphics', 'smooth'), ['() -> None', '(quality: int, /) -> None']),
    (('Py5Graphics', 'specular'), ['(gray: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(rgb: int, /) -> None']),
    (('Py5Graphics', 'sphere'), ['(r: float, /) -> None']),
    (('Py5Graphics', 'sphere_detail'), ['(res: int, /) -> None', '(ures: int, vres: int, /) -> None']),
    (('Py5Graphics', 'spot_light'), ['(v1: float, v2: float, v3: float, x: float, y: float, z: float, nx: float, ny: float, nz: float, angle: float, concentration: float, /) -> None']),
    (('Py5Graphics', 'square'), ['(x: float, y: float, extent: float, /) -> None']),
    (('Py5Graphics', 'stroke'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None']),
    (('Py5Graphics', 'stroke_cap'), ['(cap: int, /) -> None']),
    (('Py5Graphics', 'stroke_join'), ['(join: int, /) -> None']),
    (('Py5Graphics', 'stroke_weight'), ['(weight: float, /) -> None']),
    (('Py5Graphics', 'text'), ['(c: chr, x: float, y: float, /) -> None', '(c: chr, x: float, y: float, z: float, /) -> None', '(chars: List[chr], start: int, stop: int, x: float, y: float, /) -> None', '(chars: List[chr], start: int, stop: int, x: float, y: float, z: float, /) -> None', '(num: float, x: float, y: float, /) -> None', '(num: float, x: float, y: float, z: float, /) -> None', '(num: int, x: float, y: float, /) -> None', '(num: int, x: float, y: float, z: float, /) -> None', '(str: str, x: float, y: float, /) -> None', '(str: str, x: float, y: float, z: float, /) -> None', '(str: str, x1: float, y1: float, x2: float, y2: float, /) -> None']),
    (('Py5Graphics', 'text_align'), ['(align_x: int, /) -> None', '(align_x: int, align_y: int, /) -> None']),
    (('Py5Graphics', 'text_ascent'), ['() -> float']),
    (('Py5Graphics', 'text_descent'), ['() -> float']),
    (('Py5Graphics', 'text_font'), ['(which: Py5Font, /) -> None', '(which: Py5Font, size: float, /) -> None']),
    (('Py5Graphics', 'text_leading'), ['(leading: float, /) -> None']),
    (('Py5Graphics', 'text_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'text_size'), ['(size: float, /) -> None']),
    (('Py5Graphics', 'text_width'), ['(c: chr, /) -> float', '(chars: List[chr], start: int, length: int, /) -> float', '(str: str, /) -> float']),
    (('Py5Graphics', 'texture'), ['(image: Py5Image, /) -> None']),
    (('Py5Graphics', 'texture_mode'), ['(mode: int, /) -> None']),
    (('Py5Graphics', 'texture_wrap'), ['(wrap: int, /) -> None']),
    (('Py5Graphics', 'tint'), ['(gray: float, /) -> None', '(gray: float, alpha: float, /) -> None', '(v1: float, v2: float, v3: float, /) -> None', '(v1: float, v2: float, v3: float, alpha: float, /) -> None', '(rgb: int, /) -> None', '(rgb: int, alpha: float, /) -> None']),
    (('Py5Graphics', 'translate'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None']),
    (('Py5Graphics', 'triangle'), ['(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, /) -> None']),
    (('Py5Graphics', 'update_pixels'), ['() -> None', '(x: int, y: int, w: int, h: int, /) -> None']),
    (('Py5Graphics', 'vertex'), ['(x: float, y: float, /) -> None', '(x: float, y: float, z: float, /) -> None', '(x: float, y: float, u: float, v: float, /) -> None', '(x: float, y: float, z: float, u: float, v: float, /) -> None', '(v: NDArray[(Any,), Float], /) -> None']),
    (('Py5Image', 'blend'), ['(sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, mode: int, /) -> None', '(src: Py5Image, sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, mode: int, /) -> None']),
    (('Py5Image', 'copy'), ['() -> Py5Image', '(sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, /) -> None', '(src: Py5Image, sx: int, sy: int, sw: int, sh: int, dx: int, dy: int, dw: int, dh: int, /) -> None']),
    (('Py5Image', 'apply_filter'), ['(kind: int, /) -> None', '(kind: int, param: float, /) -> None']),
    (('Py5Image', 'get'), ['() -> Py5Image', '(x: int, y: int, /) -> int', '(x: int, y: int, w: int, h: int, /) -> Py5Image']),
    (('Py5Image', 'load_pixels'), ['() -> None']),
    (('Py5Image', 'mask'), ['(mask_array: JArray(JInt), /) -> None', '(img: Py5Image, /) -> None']),
    (('Py5Image', 'update_pixels'), ['() -> None', '(x: int, y: int, w: int, h: int, /) -> None']),
    (('Sketch', 'run_sketch'), ['(block: bool = False, py5_options: List = None, sketch_args: List = None) -> None']),
])

PY5_DIR_STR = [
    'acos',
    'ADD',
    'ALPHA',
    'alpha',
    'ALT',
    'AMBIENT',
    'ambient',
    'ambient_light',
    'apply_filter',
    'apply_matrix',
    'ARC',
    'arc',
    'ARGB',
    'args',
    'ARGS_BGCOLOR',
    'ARGS_DENSITY',
    'ARGS_DISABLE_AWT',
    'ARGS_DISPLAY',
    'ARGS_EDITOR_LOCATION',
    'ARGS_EXTERNAL',
    'ARGS_FULL_SCREEN',
    'ARGS_HIDE_STOP',
    'ARGS_LOCATION',
    'ARGS_PRESENT',
    'ARGS_SKETCH_FOLDER',
    'ARGS_STOP_COLOR',
    'ARGS_WINDOW_COLOR',
    'ARROW',
    'asin',
    'atan',
    'atan2',
    'background',
    'BACKSPACE',
    'BASELINE',
    'begin_camera',
    'begin_contour',
    'begin_raw',
    'begin_record',
    'begin_shape',
    'BEVEL',
    'bezier',
    'bezier_detail',
    'bezier_point',
    'bezier_tangent',
    'BEZIER_VERTEX',
    'bezier_vertex',
    'bezier_vertices',
    'BLEND',
    'blend',
    'blend_mode',
    'blue',
    'BLUR',
    'BOTTOM',
    'BOX',
    'box',
    'BREAK',
    'brightness',
    'BURN',
    'camera',
    'ceil',
    'CENTER',
    'CHATTER',
    'CHORD',
    'circle',
    'CLAMP',
    'clear',
    'clip',
    'CLOSE',
    'CODED',
    'color',
    'color_mode',
    'COMPLAINT',
    'constrain',
    'CONTROL',
    'convert_image',
    'copy',
    'CORNER',
    'CORNERS',
    'cos',
    'create_font',
    'create_font_file',
    'create_graphics',
    'create_image',
    'create_image_from_numpy',
    'create_shape',
    'CROSS',
    'cursor',
    'curve',
    'curve_detail',
    'curve_point',
    'curve_tangent',
    'curve_tightness',
    'CURVE_VERTEX',
    'curve_vertex',
    'curve_vertices',
    'CUSTOM',
    'DARKEST',
    'day',
    'DEFAULT_HEIGHT',
    'DEFAULT_WIDTH',
    'DEG_TO_RAD',
    'degrees',
    'DELETE',
    'DIAMETER',
    'DIFFERENCE',
    'DILATE',
    'DIRECTIONAL',
    'directional_light',
    'DISABLE_ASYNC_SAVEFRAME',
    'DISABLE_BUFFER_READING',
    'DISABLE_DEPTH_MASK',
    'DISABLE_DEPTH_SORT',
    'DISABLE_DEPTH_TEST',
    'DISABLE_KEY_REPEAT',
    'DISABLE_NATIVE_FONTS',
    'DISABLE_OPENGL_ERRORS',
    'DISABLE_OPTIMIZED_STROKE',
    'DISABLE_STROKE_PERSPECTIVE',
    'DISABLE_STROKE_PURE',
    'DISABLE_TEXTURE_MIPMAPS',
    'display_density',
    'display_height',
    'display_width',
    'dist',
    'DODGE',
    'DOWN',
    'DXF',
    'ELLIPSE',
    'ellipse',
    'ellipse_mode',
    'emissive',
    'ENABLE_ASYNC_SAVEFRAME',
    'ENABLE_BUFFER_READING',
    'ENABLE_DEPTH_MASK',
    'ENABLE_DEPTH_SORT',
    'ENABLE_DEPTH_TEST',
    'ENABLE_KEY_REPEAT',
    'ENABLE_NATIVE_FONTS',
    'ENABLE_OPENGL_ERRORS',
    'ENABLE_OPTIMIZED_STROKE',
    'ENABLE_STROKE_PERSPECTIVE',
    'ENABLE_STROKE_PURE',
    'ENABLE_TEXTURE_MIPMAPS',
    'end_camera',
    'end_contour',
    'end_raw',
    'end_record',
    'end_shape',
    'ENTER',
    'EPSILON',
    'ERODE',
    'ESC',
    'EXCLUSION',
    'exit_sketch',
    'exp',
    'EXTERNAL_MOVE',
    'EXTERNAL_STOP',
    'fill',
    'finished',
    'floor',
    'focused',
    'frame_count',
    'frame_rate',
    'frustum',
    'full_screen',
    'FX2D',
    'get',
    'get_current_sketch',
    'get_frame_rate',
    'get_graphics',
    'get_matrix',
    'get_surface',
    'GIF',
    'GRAY',
    'green',
    'GROUP',
    'HALF_PI',
    'HAND',
    'HARD_LIGHT',
    'has_thread',
    'height',
    'HIDDEN',
    'hint',
    'HINT_COUNT',
    'hot_reload_draw',
    'hour',
    'HSB',
    'hue',
    'IMAGE',
    'image',
    'image_mode',
    'INVERT',
    'is_dead',
    'is_dead_from_error',
    'is_key_pressed',
    'is_mouse_pressed',
    'is_ready',
    'is_running',
    'JAVA2D',
    'java_platform',
    'java_version',
    'java_version_name',
    'JClass',
    'JPEG',
    'key',
    'key_code',
    'LANDSCAPE',
    'launch_promise_thread',
    'launch_repeating_thread',
    'launch_thread',
    'LEFT',
    'lerp',
    'lerp_color',
    'light_falloff',
    'light_specular',
    'LIGHTEST',
    'lights',
    'LINE',
    'line',
    'LINE_LOOP',
    'LINE_STRIP',
    'LINES',
    'lines',
    'LINUX',
    'list_threads',
    'load_font',
    'load_image',
    'load_json',
    'load_np_pixels',
    'load_pixels',
    'load_shader',
    'load_shape',
    'log',
    'loop',
    'MACOS',
    'mag',
    'MAX_FLOAT',
    'MAX_INT',
    'millis',
    'MIN_FLOAT',
    'MIN_INT',
    'minute',
    'MITER',
    'MODEL',
    'model_x',
    'model_y',
    'model_z',
    'MODELVIEW',
    'month',
    'mouse_button',
    'mouse_x',
    'mouse_y',
    'MOVE',
    'MULTIPLY',
    'no_clip',
    'no_cursor',
    'no_fill',
    'no_lights',
    'no_loop',
    'no_smooth',
    'no_stroke',
    'no_texture',
    'no_tint',
    'noise',
    'noise_detail',
    'noise_mode',
    'noise_seed',
    'norm',
    'NORMAL',
    'normal',
    'np_pixels',
    'OPAQUE',
    'OPEN',
    'OPENGL',
    'ortho',
    'ORTHOGRAPHIC',
    'OTHER',
    'OVERLAY',
    'P2D',
    'P3D',
    'parse_json',
    'PATH',
    'pause',
    'PDF',
    'PERLIN_NOISE',
    'PERSPECTIVE',
    'perspective',
    'PI',
    'PIE',
    'pixel_density',
    'pixel_height',
    'pixel_width',
    'pixels',
    'pmouse_x',
    'pmouse_y',
    'POINT',
    'point',
    'point_light',
    'POINTS',
    'points',
    'POLYGON',
    'pop',
    'pop_matrix',
    'pop_style',
    'PORTRAIT',
    'POSTERIZE',
    'print_camera',
    'print_line_profiler_stats',
    'print_matrix',
    'print_projection',
    'PROBLEM',
    'profile_draw',
    'profile_functions',
    'PROJECT',
    'PROJECTION',
    'prune_tracebacks',
    'push',
    'push_matrix',
    'push_style',
    'Py5Font',
    'Py5Graphics',
    'Py5Image',
    'Py5Shader',
    'Py5Shape',
    'Py5Surface',
    'QUAD',
    'quad',
    'QUAD_BEZIER_VERTEX',
    'QUAD_STRIP',
    'QUADRATIC_VERTEX',
    'quadratic_vertex',
    'quadratic_vertices',
    'QUADS',
    'QUARTER_PI',
    'RAD_TO_DEG',
    'radians',
    'RADIUS',
    'random',
    'random_gaussian',
    'random_seed',
    'RECT',
    'rect',
    'rect_mode',
    'red',
    'redraw',
    'register_exception_msg',
    'register_image_conversion',
    'remap',
    'REPEAT',
    'REPLACE',
    'request_image',
    'reset_matrix',
    'reset_py5',
    'reset_shader',
    'resume',
    'RETURN',
    'RGB',
    'RIGHT',
    'rotate',
    'rotate_x',
    'rotate_y',
    'rotate_z',
    'ROUND',
    'run_sketch',
    'saturation',
    'save',
    'save_frame',
    'save_json',
    'scale',
    'SCREEN',
    'screen_x',
    'screen_y',
    'screen_z',
    'second',
    'set_matrix',
    'set_np_pixels',
    'set_stackprinter_style',
    'shader',
    'SHAPE',
    'shape',
    'shape_mode',
    'shear_x',
    'shear_y',
    'SHIFT',
    'shininess',
    'SIMPLEX_NOISE',
    'sin',
    'size',
    'Sketch',
    'sketch_path',
    'smooth',
    'SOFT_LIGHT',
    'SPAN',
    'specular',
    'SPHERE',
    'sphere',
    'sphere_detail',
    'SPOT',
    'spot_light',
    'sq',
    'sqrt',
    'SQUARE',
    'square',
    'start',
    'stop',
    'stop_all_threads',
    'stop_thread',
    'stroke',
    'stroke_cap',
    'stroke_join',
    'stroke_weight',
    'SUBTRACT',
    'SVG',
    'TAB',
    'tan',
    'TARGA',
    'TAU',
    'TEXT',
    'text',
    'text_align',
    'text_ascent',
    'text_descent',
    'text_font',
    'text_leading',
    'text_mode',
    'text_size',
    'text_width',
    'texture',
    'texture_mode',
    'texture_wrap',
    'THIRD_PI',
    'THRESHOLD',
    'TIFF',
    'tint',
    'TOP',
    'translate',
    'TRIANGLE',
    'triangle',
    'TRIANGLE_FAN',
    'TRIANGLE_STRIP',
    'TRIANGLES',
    'TWO_PI',
    'UP',
    'update_np_pixels',
    'update_pixels',
    'VERTEX',
    'vertex',
    'vertices',
    'WAIT',
    'WHITESPACE',
    'width',
    'WINDOWS',
    'X',
    'Y',
    'year',
    'Z'
]

PY5_ALL_STR = [
    'acos',
    'ADD',
    'ALPHA',
    'alpha',
    'ALT',
    'AMBIENT',
    'ambient',
    'ambient_light',
    'apply_filter',
    'apply_matrix',
    'ARC',
    'arc',
    'ARGB',
    'ARGS_BGCOLOR',
    'ARGS_DENSITY',
    'ARGS_DISABLE_AWT',
    'ARGS_DISPLAY',
    'ARGS_EDITOR_LOCATION',
    'ARGS_EXTERNAL',
    'ARGS_FULL_SCREEN',
    'ARGS_HIDE_STOP',
    'ARGS_LOCATION',
    'ARGS_PRESENT',
    'ARGS_SKETCH_FOLDER',
    'ARGS_STOP_COLOR',
    'ARGS_WINDOW_COLOR',
    'ARROW',
    'asin',
    'atan',
    'atan2',
    'background',
    'BACKSPACE',
    'BASELINE',
    'begin_camera',
    'begin_contour',
    'begin_raw',
    'begin_record',
    'begin_shape',
    'BEVEL',
    'bezier',
    'bezier_detail',
    'bezier_point',
    'bezier_tangent',
    'BEZIER_VERTEX',
    'bezier_vertex',
    'bezier_vertices',
    'BLEND',
    'blend',
    'blend_mode',
    'blue',
    'BLUR',
    'BOTTOM',
    'BOX',
    'box',
    'BREAK',
    'brightness',
    'BURN',
    'camera',
    'ceil',
    'CENTER',
    'CHATTER',
    'CHORD',
    'circle',
    'CLAMP',
    'clear',
    'clip',
    'CLOSE',
    'CODED',
    'color',
    'color_mode',
    'COMPLAINT',
    'constrain',
    'CONTROL',
    'convert_image',
    'copy',
    'CORNER',
    'CORNERS',
    'cos',
    'create_font',
    'create_font_file',
    'create_graphics',
    'create_image',
    'create_image_from_numpy',
    'create_shape',
    'CROSS',
    'cursor',
    'curve',
    'curve_detail',
    'curve_point',
    'curve_tangent',
    'curve_tightness',
    'CURVE_VERTEX',
    'curve_vertex',
    'curve_vertices',
    'CUSTOM',
    'DARKEST',
    'day',
    'DEFAULT_HEIGHT',
    'DEFAULT_WIDTH',
    'DEG_TO_RAD',
    'degrees',
    'DELETE',
    'DIAMETER',
    'DIFFERENCE',
    'DILATE',
    'DIRECTIONAL',
    'directional_light',
    'DISABLE_ASYNC_SAVEFRAME',
    'DISABLE_BUFFER_READING',
    'DISABLE_DEPTH_MASK',
    'DISABLE_DEPTH_SORT',
    'DISABLE_DEPTH_TEST',
    'DISABLE_KEY_REPEAT',
    'DISABLE_NATIVE_FONTS',
    'DISABLE_OPENGL_ERRORS',
    'DISABLE_OPTIMIZED_STROKE',
    'DISABLE_STROKE_PERSPECTIVE',
    'DISABLE_STROKE_PURE',
    'DISABLE_TEXTURE_MIPMAPS',
    'display_density',
    'dist',
    'DODGE',
    'DOWN',
    'DXF',
    'ELLIPSE',
    'ellipse',
    'ellipse_mode',
    'emissive',
    'ENABLE_ASYNC_SAVEFRAME',
    'ENABLE_BUFFER_READING',
    'ENABLE_DEPTH_MASK',
    'ENABLE_DEPTH_SORT',
    'ENABLE_DEPTH_TEST',
    'ENABLE_KEY_REPEAT',
    'ENABLE_NATIVE_FONTS',
    'ENABLE_OPENGL_ERRORS',
    'ENABLE_OPTIMIZED_STROKE',
    'ENABLE_STROKE_PERSPECTIVE',
    'ENABLE_STROKE_PURE',
    'ENABLE_TEXTURE_MIPMAPS',
    'end_camera',
    'end_contour',
    'end_raw',
    'end_record',
    'end_shape',
    'ENTER',
    'EPSILON',
    'ERODE',
    'ESC',
    'EXCLUSION',
    'exit_sketch',
    'exp',
    'EXTERNAL_MOVE',
    'EXTERNAL_STOP',
    'fill',
    'floor',
    'frame_rate',
    'frustum',
    'full_screen',
    'FX2D',
    'get',
    'get_current_sketch',
    'get_frame_rate',
    'get_graphics',
    'get_matrix',
    'get_surface',
    'GIF',
    'GRAY',
    'green',
    'GROUP',
    'HALF_PI',
    'HAND',
    'HARD_LIGHT',
    'has_thread',
    'HIDDEN',
    'hint',
    'HINT_COUNT',
    'hot_reload_draw',
    'hour',
    'HSB',
    'hue',
    'IMAGE',
    'image',
    'image_mode',
    'INVERT',
    'is_key_pressed',
    'is_mouse_pressed',
    'JAVA2D',
    'JClass',
    'JPEG',
    'LANDSCAPE',
    'launch_promise_thread',
    'launch_repeating_thread',
    'launch_thread',
    'LEFT',
    'lerp',
    'lerp_color',
    'light_falloff',
    'light_specular',
    'LIGHTEST',
    'lights',
    'LINE',
    'line',
    'LINE_LOOP',
    'LINE_STRIP',
    'LINES',
    'lines',
    'LINUX',
    'list_threads',
    'load_font',
    'load_image',
    'load_json',
    'load_np_pixels',
    'load_pixels',
    'load_shader',
    'load_shape',
    'log',
    'loop',
    'MACOS',
    'mag',
    'MAX_FLOAT',
    'MAX_INT',
    'millis',
    'MIN_FLOAT',
    'MIN_INT',
    'minute',
    'MITER',
    'MODEL',
    'model_x',
    'model_y',
    'model_z',
    'MODELVIEW',
    'month',
    'MOVE',
    'MULTIPLY',
    'no_clip',
    'no_cursor',
    'no_fill',
    'no_lights',
    'no_loop',
    'no_smooth',
    'no_stroke',
    'no_texture',
    'no_tint',
    'noise',
    'noise_detail',
    'noise_mode',
    'noise_seed',
    'norm',
    'NORMAL',
    'normal',
    'OPAQUE',
    'OPEN',
    'OPENGL',
    'ortho',
    'ORTHOGRAPHIC',
    'OTHER',
    'OVERLAY',
    'P2D',
    'P3D',
    'parse_json',
    'PATH',
    'pause',
    'PDF',
    'PERLIN_NOISE',
    'PERSPECTIVE',
    'perspective',
    'PI',
    'PIE',
    'pixel_density',
    'POINT',
    'point',
    'point_light',
    'POINTS',
    'points',
    'POLYGON',
    'pop',
    'pop_matrix',
    'pop_style',
    'PORTRAIT',
    'POSTERIZE',
    'print_camera',
    'print_line_profiler_stats',
    'print_matrix',
    'print_projection',
    'PROBLEM',
    'profile_draw',
    'profile_functions',
    'PROJECT',
    'PROJECTION',
    'prune_tracebacks',
    'push',
    'push_matrix',
    'push_style',
    'Py5Font',
    'Py5Graphics',
    'Py5Image',
    'Py5Shader',
    'Py5Shape',
    'Py5Surface',
    'QUAD',
    'quad',
    'QUAD_BEZIER_VERTEX',
    'QUAD_STRIP',
    'QUADRATIC_VERTEX',
    'quadratic_vertex',
    'quadratic_vertices',
    'QUADS',
    'QUARTER_PI',
    'RAD_TO_DEG',
    'radians',
    'RADIUS',
    'random',
    'random_gaussian',
    'random_seed',
    'RECT',
    'rect',
    'rect_mode',
    'red',
    'redraw',
    'register_exception_msg',
    'register_image_conversion',
    'remap',
    'REPEAT',
    'REPLACE',
    'request_image',
    'reset_matrix',
    'reset_py5',
    'reset_shader',
    'resume',
    'RETURN',
    'RGB',
    'RIGHT',
    'rotate',
    'rotate_x',
    'rotate_y',
    'rotate_z',
    'ROUND',
    'run_sketch',
    'saturation',
    'save',
    'save_frame',
    'save_json',
    'scale',
    'SCREEN',
    'screen_x',
    'screen_y',
    'screen_z',
    'second',
    'set_matrix',
    'set_np_pixels',
    'set_stackprinter_style',
    'shader',
    'SHAPE',
    'shape',
    'shape_mode',
    'shear_x',
    'shear_y',
    'SHIFT',
    'shininess',
    'SIMPLEX_NOISE',
    'sin',
    'size',
    'Sketch',
    'sketch_path',
    'smooth',
    'SOFT_LIGHT',
    'SPAN',
    'specular',
    'SPHERE',
    'sphere',
    'sphere_detail',
    'SPOT',
    'spot_light',
    'sq',
    'sqrt',
    'SQUARE',
    'square',
    'start',
    'stop',
    'stop_all_threads',
    'stop_thread',
    'stroke',
    'stroke_cap',
    'stroke_join',
    'stroke_weight',
    'SUBTRACT',
    'SVG',
    'TAB',
    'tan',
    'TARGA',
    'TAU',
    'TEXT',
    'text',
    'text_align',
    'text_ascent',
    'text_descent',
    'text_font',
    'text_leading',
    'text_mode',
    'text_size',
    'text_width',
    'texture',
    'texture_mode',
    'texture_wrap',
    'THIRD_PI',
    'THRESHOLD',
    'TIFF',
    'tint',
    'TOP',
    'translate',
    'TRIANGLE',
    'triangle',
    'TRIANGLE_FAN',
    'TRIANGLE_STRIP',
    'TRIANGLES',
    'TWO_PI',
    'UP',
    'update_np_pixels',
    'update_pixels',
    'VERTEX',
    'vertex',
    'vertices',
    'WAIT',
    'WHITESPACE',
    'WINDOWS',
    'X',
    'Y',
    'year',
    'Z'
]
