/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractText;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractParentNode
extends AbstractNode {
    protected ChildNodes childNodes;

    @Override
    public NodeList getChildNodes() {
        return this.childNodes == null ? (this.childNodes = new ChildNodes()) : this.childNodes;
    }

    @Override
    public Node getFirstChild() {
        return this.childNodes == null ? null : this.childNodes.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.childNodes == null ? null : this.childNodes.lastChild;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (node2 != null && (this.childNodes == null || node2.getParentNode() != this)) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(node2.getNodeType()), node2.getNodeName()});
        }
        this.checkAndRemove(node, false);
        if (node.getNodeType() == 11) {
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                this.insertBefore(node3, node2);
                node3 = node4;
            }
            return node;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode extendedNode = this.childNodes.insert((ExtendedNode)node, (ExtendedNode)node2);
        extendedNode.setParentNode(this);
        this.nodeAdded(extendedNode);
        this.fireDOMNodeInsertedEvent(extendedNode);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.childNodes == null || node2.getParentNode() != this) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(node2.getNodeType()), node2.getNodeName()});
        }
        this.checkAndRemove(node, true);
        if (node.getNodeType() == 11) {
            Node node3 = node.getLastChild();
            if (node3 == null) {
                return node;
            }
            Node node4 = node3.getPreviousSibling();
            this.replaceChild(node3, node2);
            Node node5 = node3;
            node3 = node4;
            while (node3 != null) {
                node4 = node3.getPreviousSibling();
                this.insertBefore(node3, node5);
                node5 = node3;
                node3 = node4;
            }
            return node;
        }
        this.fireDOMNodeRemovedEvent(node2);
        this.getCurrentDocument().nodeToBeRemoved(node2);
        this.nodeToBeRemoved(node2);
        ExtendedNode extendedNode = (ExtendedNode)node;
        ExtendedNode extendedNode2 = this.childNodes.replace(extendedNode, (ExtendedNode)node2);
        extendedNode.setParentNode(this);
        extendedNode2.setParentNode(null);
        this.nodeAdded(extendedNode);
        this.fireDOMNodeInsertedEvent(extendedNode);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        if (this.childNodes == null || node.getParentNode() != this) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
        }
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.fireDOMNodeRemovedEvent(node);
        this.getCurrentDocument().nodeToBeRemoved(node);
        this.nodeToBeRemoved(node);
        ExtendedNode extendedNode = this.childNodes.remove((ExtendedNode)node);
        extendedNode.setParentNode(null);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        this.checkAndRemove(node, false);
        if (node.getNodeType() == 11) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2.getNextSibling();
                this.appendChild(node2);
                node2 = node3;
            }
            return node;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode extendedNode = this.childNodes.append((ExtendedNode)node);
        extendedNode.setParentNode(this);
        this.nodeAdded(extendedNode);
        this.fireDOMNodeInsertedEvent(extendedNode);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    @Override
    public boolean hasChildNodes() {
        return this.childNodes != null && this.childNodes.getLength() != 0;
    }

    @Override
    public void normalize() {
        Node node = this.getFirstChild();
        if (node != null) {
            node.normalize();
            Node node2 = node.getNextSibling();
            while (node2 != null) {
                if (node.getNodeType() == 3 && node2.getNodeType() == 3) {
                    String string = node.getNodeValue() + node2.getNodeValue();
                    AbstractText abstractText = (AbstractText)node;
                    abstractText.setNodeValue(string);
                    this.removeChild(node2);
                    node2 = node.getNextSibling();
                    continue;
                }
                node2.normalize();
                node = node2;
                node2 = node2.getNextSibling();
            }
        }
    }

    public NodeList getElementsByTagName(String string) {
        if (string == null) {
            return EMPTY_NODE_LIST;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(this, string);
        if (elementsByTagName == null) {
            elementsByTagName = new ElementsByTagName(string);
            abstractDocument.putElementsByTagName(this, string, elementsByTagName);
        }
        return elementsByTagName;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        AbstractDocument abstractDocument;
        ElementsByTagNameNS elementsByTagNameNS;
        if (string2 == null) {
            return EMPTY_NODE_LIST;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if ((elementsByTagNameNS = (abstractDocument = this.getCurrentDocument()).getElementsByTagNameNS(this, string, string2)) == null) {
            elementsByTagNameNS = new ElementsByTagNameNS(string, string2);
            abstractDocument.putElementsByTagNameNS(this, string, string2, elementsByTagNameNS);
        }
        return elementsByTagNameNS;
    }

    @Override
    public String getTextContent() {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 7: 
                case 8: {
                    continue block3;
                }
                default: {
                    stringBuffer.append(((AbstractNode)node).getTextContent());
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            super.fireDOMNodeInsertedIntoDocumentEvent();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                ((AbstractNode)node).fireDOMNodeInsertedIntoDocumentEvent();
            }
        }
    }

    @Override
    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            super.fireDOMNodeRemovedFromDocumentEvent();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                ((AbstractNode)node).fireDOMNodeRemovedFromDocumentEvent();
            }
        }
    }

    protected void nodeAdded(Node node) {
    }

    protected void nodeToBeRemoved(Node node) {
    }

    @Override
    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = ((AbstractNode)node2).deepExport(node2.cloneNode(false), abstractDocument);
            node.appendChild(node3);
        }
        return node;
    }

    @Override
    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2.cloneNode(true);
            node.appendChild(node3);
        }
        return node;
    }

    protected void fireDOMSubtreeModifiedEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", true, false, null, null, null, null, (short)1);
            this.dispatchEvent(dOMMutationEvent);
        }
    }

    protected void fireDOMNodeInsertedEvent(Node node) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", true, false, this, null, null, null, (short)2);
            AbstractNode abstractNode = (AbstractNode)node;
            abstractNode.dispatchEvent(dOMMutationEvent);
            abstractNode.fireDOMNodeInsertedIntoDocumentEvent();
        }
    }

    protected void fireDOMNodeRemovedEvent(Node node) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", true, false, this, null, null, null, (short)3);
            AbstractNode abstractNode = (AbstractNode)node;
            abstractNode.dispatchEvent(dOMMutationEvent);
            abstractNode.fireDOMNodeRemovedFromDocumentEvent();
        }
    }

    protected void checkAndRemove(Node node, boolean bl) {
        this.checkChildType(node, bl);
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (node.getOwnerDocument() != this.getCurrentDocument()) {
            throw this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (this == node) {
            throw this.createDOMException((short)3, "add.self", new Object[]{this.getNodeName()});
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return;
        }
        for (Node node3 = this; node3 != null; node3 = node3.getParentNode()) {
            if (node3 != node) continue;
            throw this.createDOMException((short)3, "add.ancestor", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        node2.removeChild(node);
    }

    protected class ChildNodes
    implements NodeList,
    Serializable {
        protected ExtendedNode firstChild;
        protected ExtendedNode lastChild;
        protected int children;
        protected int elementChildren;

        @Override
        public Node item(int n) {
            if (n < 0 || n >= this.children) {
                return null;
            }
            if (n < this.children >> 1) {
                Node node = this.firstChild;
                for (int i = 0; i < n; ++i) {
                    node = node.getNextSibling();
                }
                return node;
            }
            Node node = this.lastChild;
            for (int i = this.children - 1; i > n; --i) {
                node = node.getPreviousSibling();
            }
            return node;
        }

        @Override
        public int getLength() {
            return this.children;
        }

        public ExtendedNode append(ExtendedNode extendedNode) {
            if (this.lastChild == null) {
                this.firstChild = extendedNode;
            } else {
                this.lastChild.setNextSibling(extendedNode);
                extendedNode.setPreviousSibling(this.lastChild);
            }
            this.lastChild = extendedNode;
            ++this.children;
            if (extendedNode.getNodeType() == 1) {
                ++this.elementChildren;
            }
            return extendedNode;
        }

        public ExtendedNode insert(ExtendedNode extendedNode, ExtendedNode extendedNode2) {
            if (extendedNode2 == null) {
                return this.append(extendedNode);
            }
            if (extendedNode2 == this.firstChild) {
                this.firstChild.setPreviousSibling(extendedNode);
                extendedNode.setNextSibling(this.firstChild);
                this.firstChild = extendedNode;
                ++this.children;
                if (extendedNode.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return extendedNode;
            }
            if (extendedNode2 == this.lastChild) {
                ExtendedNode extendedNode3 = (ExtendedNode)extendedNode2.getPreviousSibling();
                extendedNode3.setNextSibling(extendedNode);
                extendedNode2.setPreviousSibling(extendedNode);
                extendedNode.setNextSibling(extendedNode2);
                extendedNode.setPreviousSibling(extendedNode3);
                ++this.children;
                if (extendedNode.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return extendedNode;
            }
            ExtendedNode extendedNode4 = (ExtendedNode)extendedNode2.getPreviousSibling();
            if (extendedNode4.getNextSibling() == extendedNode2 && extendedNode4.getParentNode() == extendedNode2.getParentNode()) {
                extendedNode4.setNextSibling(extendedNode);
                extendedNode.setPreviousSibling(extendedNode4);
                extendedNode.setNextSibling(extendedNode2);
                extendedNode2.setPreviousSibling(extendedNode);
                ++this.children;
                if (extendedNode.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return extendedNode;
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(extendedNode2.getNodeType()), extendedNode2.getNodeName()});
        }

        public ExtendedNode replace(ExtendedNode extendedNode, ExtendedNode extendedNode2) {
            if (extendedNode2 == this.firstChild) {
                ExtendedNode extendedNode3 = (ExtendedNode)this.firstChild.getNextSibling();
                extendedNode.setNextSibling(extendedNode3);
                if (extendedNode2 == this.lastChild) {
                    this.lastChild = extendedNode;
                } else {
                    extendedNode3.setPreviousSibling(extendedNode);
                }
                this.firstChild.setNextSibling(null);
                this.firstChild = extendedNode;
                if (extendedNode2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                if (extendedNode.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return extendedNode2;
            }
            if (extendedNode2 == this.lastChild) {
                ExtendedNode extendedNode4 = (ExtendedNode)this.lastChild.getPreviousSibling();
                extendedNode.setPreviousSibling(extendedNode4);
                extendedNode4.setNextSibling(extendedNode);
                this.lastChild.setPreviousSibling(null);
                this.lastChild = extendedNode;
                if (extendedNode2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                if (extendedNode.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return extendedNode2;
            }
            ExtendedNode extendedNode5 = (ExtendedNode)extendedNode2.getPreviousSibling();
            ExtendedNode extendedNode6 = (ExtendedNode)extendedNode2.getNextSibling();
            if (extendedNode5.getNextSibling() == extendedNode2 && extendedNode6.getPreviousSibling() == extendedNode2 && extendedNode5.getParentNode() == extendedNode2.getParentNode() && extendedNode6.getParentNode() == extendedNode2.getParentNode()) {
                extendedNode5.setNextSibling(extendedNode);
                extendedNode.setPreviousSibling(extendedNode5);
                extendedNode.setNextSibling(extendedNode6);
                extendedNode6.setPreviousSibling(extendedNode);
                extendedNode2.setPreviousSibling(null);
                extendedNode2.setNextSibling(null);
                if (extendedNode2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                if (extendedNode.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return extendedNode2;
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(extendedNode2.getNodeType()), extendedNode2.getNodeName()});
        }

        public ExtendedNode remove(ExtendedNode extendedNode) {
            if (extendedNode == this.firstChild) {
                if (extendedNode == this.lastChild) {
                    this.firstChild = null;
                    this.lastChild = null;
                    --this.children;
                    if (extendedNode.getNodeType() == 1) {
                        --this.elementChildren;
                    }
                    return extendedNode;
                }
                this.firstChild = (ExtendedNode)this.firstChild.getNextSibling();
                this.firstChild.setPreviousSibling(null);
                extendedNode.setNextSibling(null);
                if (extendedNode.getNodeType() == 1) {
                    --this.elementChildren;
                }
                --this.children;
                return extendedNode;
            }
            if (extendedNode == this.lastChild) {
                this.lastChild = (ExtendedNode)this.lastChild.getPreviousSibling();
                this.lastChild.setNextSibling(null);
                extendedNode.setPreviousSibling(null);
                --this.children;
                if (extendedNode.getNodeType() == 1) {
                    --this.elementChildren;
                }
                return extendedNode;
            }
            ExtendedNode extendedNode2 = (ExtendedNode)extendedNode.getPreviousSibling();
            ExtendedNode extendedNode3 = (ExtendedNode)extendedNode.getNextSibling();
            if (extendedNode2.getNextSibling() == extendedNode && extendedNode3.getPreviousSibling() == extendedNode && extendedNode2.getParentNode() == extendedNode.getParentNode() && extendedNode3.getParentNode() == extendedNode.getParentNode()) {
                extendedNode2.setNextSibling(extendedNode3);
                extendedNode3.setPreviousSibling(extendedNode2);
                extendedNode.setPreviousSibling(null);
                extendedNode.setNextSibling(null);
                --this.children;
                if (extendedNode.getNodeType() == 1) {
                    --this.elementChildren;
                }
                return extendedNode;
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(extendedNode.getNodeType()), extendedNode.getNodeName()});
        }
    }

    protected class ElementsByTagNameNS
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String namespaceURI;
        protected String localName;

        public ElementsByTagNameNS(String string, String string2) {
            this.namespaceURI = string;
            this.localName = string2;
        }

        @Override
        public Node item(int n) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || n < 0 || n > this.size) {
                return null;
            }
            return this.table[n];
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node node) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] nodeArray = new Node[this.table.length * 2 + 1];
                System.arraycopy(this.table, 0, nodeArray, 0, this.size);
                this.table = nodeArray;
            }
            this.table[this.size++] = node;
        }

        protected void initialize() {
            this.size = 0;
            for (Node node = AbstractParentNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.initialize(node);
            }
        }

        private void initialize(Node node) {
            Object object;
            if (node.getNodeType() == 1) {
                String string;
                object = node.getNamespaceURI();
                String string2 = string = object == null ? node.getNodeName() : node.getLocalName();
                if (this.nsMatch(this.namespaceURI, node.getNamespaceURI()) && (this.localName.equals("*") || this.localName.equals(string))) {
                    this.append(node);
                }
            }
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                this.initialize((Node)object);
            }
        }

        private boolean nsMatch(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string == null || string2 == null) {
                return false;
            }
            if (string.equals("*")) {
                return true;
            }
            return string.equals(string2);
        }
    }

    protected class ElementsByTagName
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String name;

        public ElementsByTagName(String string) {
            this.name = string;
        }

        @Override
        public Node item(int n) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || n < 0 || n >= this.size) {
                return null;
            }
            return this.table[n];
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node node) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] nodeArray = new Node[this.table.length * 2 + 1];
                System.arraycopy(this.table, 0, nodeArray, 0, this.size);
                this.table = nodeArray;
            }
            this.table[this.size++] = node;
        }

        protected void initialize() {
            this.size = 0;
            for (Node node = AbstractParentNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.initialize(node);
            }
        }

        private void initialize(Node node) {
            Object object;
            if (node.getNodeType() == 1) {
                object = node.getNodeName();
                if (this.name.equals("*") || this.name.equals(object)) {
                    this.append(node);
                }
            }
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                this.initialize((Node)object);
            }
        }
    }
}

