from typing import TYPE_CHECKING, Any, Optional

from .constants import ChNr, ModuleKind
from .KeysightB1500_module import B1500Module

if TYPE_CHECKING:
    import qcodes.instrument_drivers.Keysight.keysightb1500


class B1530A(B1500Module):
    """
    Driver for Keysight B1530A Waveform Generator/Fast Measurement Unit
    module for B1500 Semiconductor Parameter Analyzer.

    Warning:
        At the moment this driver implements no functionality of the module.

    Args:
        parent: mainframe B1500 instance that this module belongs to
        name: Name of the instrument instance to create. If `None`
            (Default), then the name is autogenerated from the instrument
            class.
        slot_nr: Slot number of this module (not channel number)
    """
    MODULE_KIND = ModuleKind.WGFMU

    def __init__(
        self,
        parent: "qcodes.instrument_drivers.Keysight.keysightb1500.KeysightB1500",
        name: Optional[str],
        slot_nr: int,
        **kwargs: Any,
    ):
        super().__init__(parent, name, slot_nr, **kwargs)

        self.channels = (ChNr(slot_nr), ChNr(int(f"{slot_nr:d}02")))
