import sys
sys.path.append('../')
import logging
import logging.handlers
import os
from client.client.common.variables import LOGGING_LEVEL

server_formatter = logging.Formatter('%(asctime)s %(levelname)s %(filename)s %(message)s')
path = os.getcwd()
path = os.path.join(path, 'server.log')
steam = logging.StreamHandler(sys.stderr)
steam.setFormatter(server_formatter)
steam.setLevel(logging.INFO)
log_file = logging.handlers.TimedRotatingFileHandler(path, encoding='utf8', interval=1, when='D')
log_file.setFormatter(server_formatter)
logger = logging.getLogger('server')
logger.addHandler(steam)
logger.addHandler(log_file)
logger.setLevel(LOGGING_LEVEL)

if __name__ == '__main__':
    logger.critical('Test critical event')
    logger.error('Test error ivent')
    logger.debug('Test debug ivent')
    logger.info('Test info ivent')
