"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtXml, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtXml

bytes = str


class QDomText(PySide6.QtXml.QDomCharacterData):
    """
    https://doc.qt.io/qt-6/qdomtext.html

    **Detailed Description**

    You can split the text in a QDomText object over two QDomText objects with
    **splitText** ().

    For further information about the Document Object Model see **Level 1**  and
    **Level 2 Core** . For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdomtext.html#QDomText

        **QDomText::QDomText()**

        Constructs an empty QDomText object.

        To construct a QDomText with content, use
        **QDomDocument::createTextNode** ().
        """
        ...

    @overload
    def __init__(self, x: PySide6.QtXml.QDomText) -> None:
        """
        https://doc.qt.io/qt-6/qdomtext.html#QDomText-1

        **QDomText::QDomText(const QDomText & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def nodeType(self) -> PySide6.QtXml.QDomNode.NodeType:
        """
        https://doc.qt.io/qt-6/qdomtext.html#nodeType

        **QDomNode::NodeType QDomText::nodeType() const**

        Returns `TextNode`.
        """
        ...

    def splitText(self, offset: int) -> PySide6.QtXml.QDomText:
        """
        https://doc.qt.io/qt-6/qdomtext.html#splitText

        **QDomText QDomText::splitText(int offset )**

        Splits this DOM text object into two **QDomText**  objects. This object
        keeps its first **offset** characters and the second (newly created)
        object is inserted into the document tree after this object with the
        remaining characters.

        The function returns the newly created object.

        **See also** **QDomNode::normalize** ().
        """
        ...
