"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtXml, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtXml

bytes = str


class QDomEntityReference(PySide6.QtXml.QDomNode):
    """
    https://doc.qt.io/qt-6/qdomentityreference.html

    **Detailed Description**

    A QDomEntityReference object may be inserted into the DOM tree when an
    entity reference is in the source document, or when the user wishes to
    insert an entity reference.

    Note that character references and references to predefined entities are
    expanded by the XML processor so that characters are represented by their
    Unicode equivalent rather than by an entity reference.

    Moreover, the XML processor may completely expand references to entities
    while building the DOM tree, instead of providing QDomEntityReference
    objects.

    If it does provide such objects, then for a given entity reference node, it
    may be that there is no entity node representing the referenced entity; but
    if such an entity exists, then the child list of the entity reference node
    is the same as that of the entity node. As with the entity node, all
    descendants of the entity reference are read-only.

    For further information about the Document Object Model see **Level 1**  and
    **Level 2 Core** . For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdomentityreference.html#QDomEntityReference

        **QDomEntityReference::QDomEntityReference()**

        Constructs an empty entity reference. Use
        **QDomDocument::createEntityReference** () to create a entity reference
        with content.
        """
        ...

    @overload
    def __init__(self, x: PySide6.QtXml.QDomEntityReference) -> None:
        """
        https://doc.qt.io/qt-6/qdomentityreference.html#QDomEntityReference-1

        **QDomEntityReference::QDomEntityReference(const QDomEntityReference & x
        )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def nodeType(self) -> PySide6.QtXml.QDomNode.NodeType:
        """
        https://doc.qt.io/qt-6/qdomentityreference.html#nodeType

        **QDomNode::NodeType QDomEntityReference::nodeType() const**

        Returns `EntityReference`.
        """
        ...
