"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtXml, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtXml

bytes = str


class QDomDocumentType(PySide6.QtXml.QDomNode):
    """
    https://doc.qt.io/qt-6/qdomdocumenttype.html

    **Detailed Description**

    The QDomDocumentType class allows read-only access to some of the data
    structures in the DTD: it can return a map of all **entities** () and
    **notations** (). In addition the function **name** () returns the name of
    the document type as specified in the &lt;!DOCTYPE name&gt; tag. This class
    also provides the **publicId** (), **systemId** () and **internalSubset** ()
    functions.

    **See also** **QDomDocument** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#QDomDocumentType

        **QDomDocumentType::QDomDocumentType()**

        Creates an empty QDomDocumentType object.
        """
        ...

    @overload
    def __init__(self, x: PySide6.QtXml.QDomDocumentType) -> None:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#QDomDocumentType-1

        **QDomDocumentType::QDomDocumentType(const QDomDocumentType & n )**

        Constructs a copy of **n**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def entities(self) -> PySide6.QtXml.QDomNamedNodeMap:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#entities

        **QDomNamedNodeMap QDomDocumentType::entities() const**

        Returns a map of all entities described in the DTD.
        """
        ...

    def internalSubset(self) -> str:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#internalSubset

        **QString QDomDocumentType::internalSubset() const**

        Returns the internal subset of the document type or an empty string if
        there is no internal subset.

        **See also** **publicId** () and **systemId** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#name

        **QString QDomDocumentType::name() const**

        Returns the name of the document type as specified in the &lt;!DOCTYPE
        name&gt; tag.

        **See also** **nodeName** ().
        """
        ...

    def nodeType(self) -> PySide6.QtXml.QDomNode.NodeType:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#nodeType

        **QDomNode::NodeType QDomDocumentType::nodeType() const**

        Returns `DocumentTypeNode`.

        **See also** **isDocumentType** () and **QDomNode::toDocumentType** ().
        """
        ...

    def notations(self) -> PySide6.QtXml.QDomNamedNodeMap:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#notations

        **QDomNamedNodeMap QDomDocumentType::notations() const**

        Returns a map of all notations described in the DTD.
        """
        ...

    def publicId(self) -> str:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#publicId

        **QString QDomDocumentType::publicId() const**

        Returns the public identifier of the external DTD subset or an empty
        string if there is no public identifier.

        **See also** **systemId** (), **internalSubset** (), and
        **QDomImplementation::createDocumentType** ().
        """
        ...

    def systemId(self) -> str:
        """
        https://doc.qt.io/qt-6/qdomdocumenttype.html#systemId

        **QString QDomDocumentType::systemId() const**

        Returns the system identifier of the external DTD subset or an empty
        string if there is no system identifier.

        **See also** **publicId** (), **internalSubset** (), and
        **QDomImplementation::createDocumentType** ().
        """
        ...
