"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtXml, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtXml

bytes = str


class QDomDocumentFragment(PySide6.QtXml.QDomNode):
    """
    https://doc.qt.io/qt-6/qdomdocumentfragment.html

    **Detailed Description**

    If you want to do complex tree operations it is useful to have a lightweight
    class to store nodes and their relations. QDomDocumentFragment stores a
    subtree of a document which does not necessarily represent a well-formed XML
    document.

    QDomDocumentFragment is also useful if you want to group several nodes in a
    list and insert them all together as children of some node. In these cases
    QDomDocumentFragment can be used as a temporary container for this list of
    children.

    The most important feature of QDomDocumentFragment is that it is treated in
    a special way by **QDomNode::insertAfter** (), **QDomNode::insertBefore**
    (), **QDomNode::replaceChild** () and **QDomNode::appendChild** (): instead
    of inserting the fragment itself, all the fragment's children are inserted.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdomdocumentfragment.html#QDomDocumentFragment

        **QDomDocumentFragment::QDomDocumentFragment()**

        Constructs an empty document fragment.
        """
        ...

    @overload
    def __init__(self, x: PySide6.QtXml.QDomDocumentFragment) -> None:
        """
        https://doc.qt.io/qt-6/qdomdocumentfragment.html#QDomDocumentFragment-1

        **QDomDocumentFragment::QDomDocumentFragment(const QDomDocumentFragment
        & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def nodeType(self) -> PySide6.QtXml.QDomNode.NodeType:
        """
        https://doc.qt.io/qt-6/qdomdocumentfragment.html#nodeType

        **QDomNode::NodeType QDomDocumentFragment::nodeType() const**

        Returns `DocumentFragment`.

        **See also** **isDocumentFragment** () and
        **QDomNode::toDocumentFragment** ().
        """
        ...
