"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtXml, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtXml

bytes = str


class QDomComment(PySide6.QtXml.QDomCharacterData):
    """
    https://doc.qt.io/qt-6/qdomcomment.html

    **Detailed Description**

    A comment in the parsed XML such as this:

    <!-- this is a comment -->

    is represented by QDomComment objects in the parsed Dom tree.

    For further information about the Document Object Model see **Level 1**  and
    **Level 2 Core** . For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdomcomment.html#QDomComment

        **QDomComment::QDomComment()**

        Constructs an empty comment. To construct a comment with content, use
        the **QDomDocument::createComment** () function.
        """
        ...

    @overload
    def __init__(self, x: PySide6.QtXml.QDomComment) -> None:
        """
        https://doc.qt.io/qt-6/qdomcomment.html#QDomComment-1

        **QDomComment::QDomComment(const QDomComment & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def nodeType(self) -> PySide6.QtXml.QDomNode.NodeType:
        """
        https://doc.qt.io/qt-6/qdomcomment.html#nodeType

        **QDomNode::NodeType QDomComment::nodeType() const**

        Returns `CommentNode`.
        """
        ...
