"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QWizardPage(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qwizardpage.html

    **Detailed Description**

    **QWizard**  represents a wizard. Each page is a QWizardPage. When you
    create your own wizards, you can use QWizardPage directly, or you can
    subclass it for more control.

    A page has the following attributes, which are rendered by **QWizard** : a
    **title** , a **subTitle** , and a **set of pixmaps** . See **Elements of a
    Wizard Page**  for details. Once a page is added to the wizard (using
    **QWizard::addPage** () or **QWizard::setPage** ()), **wizard** () returns a
    pointer to the associated **QWizard**  object.

    Page provides five virtual functions that can be reimplemented to provide
    custom behavior:

    * **initializePage** () is called to initialize the page's contents when the
    user clicks the wizard's **Next** button. If you want to derive the page's
    default from what the user entered on previous pages, this is the function
    to reimplement.
      * **cleanupPage** () is called to reset the page's
    contents when the user clicks the wizard's **Back** button.
      *
    **validatePage** () validates the page when the user clicks **Next** or
    **Finish**. It is often used to show an error message if the user has
    entered incomplete or invalid information.
      * **nextId** () returns the ID
    of the next page. It is useful when **creating non-linear wizards** , which
    allow different traversal paths based on the information provided by the
    user.
      * **isComplete** () is called to determine whether the **Next**
    and/or **Finish** button should be enabled or disabled. If you reimplement
    **isComplete** (), also make sure that **completeChanged** () is emitted
    whenever the complete state changes.

    Normally, the **Next** button and the **Finish** button of a wizard are
    mutually exclusive. If **isFinalPage** () returns `true`, **Finish** is
    available; otherwise, **Next** is available. By default, **isFinalPage** ()
    is true only when **nextId** () returns -1. If you want to show **Next** and
    **Final** simultaneously for a page (letting the user perform an "early
    finish"), call **setFinalPage** (true) on that page. For wizards that
    support early finishes, you might also want to set the
    **HaveNextButtonOnLastPage**  and **HaveFinishButtonOnEarlyPages**  options
    on the wizard.

    In many wizards, the contents of a page may affect the default values of the
    fields of a later page. To make it easy to communicate between pages,
    **QWizard**  supports a **"field" mechanism**  that allows you to register a
    field (e.g., a **QLineEdit** ) on a page and to access its value from any
    page. Fields are global to the entire wizard and make it easy for any single
    page to access information stored by another page, without having to put all
    the logic in **QWizard**  or having the pages know explicitly about each
    other. Fields are registered using **registerField** () and can be accessed
    at any time using **field** () and **setField** ().

    **See also** **QWizard** , **Class Wizard Example** , and **License Wizard
    Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#QWizardPage

        **QWizardPage::QWizardPage(QWidget * parent = nullptr)**

        Constructs a wizard page with the given **parent**.

        When the page is inserted into a wizard using **QWizard::addPage** () or
        **QWizard::setPage** (), the parent is automatically set to be the
        wizard.

        **See also** **wizard** ().
        """
        ...

    def buttonText(self, which: PySide6.QtWidgets.QWizard.WizardButton) -> str:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#buttonText

        **QString QWizardPage::buttonText(QWizard::WizardButton which ) const**

        Returns the text on button **which** on this page.

        If a text has ben set using **setButtonText** (), this text is returned.
        Otherwise, if a text has been set using **QWizard::setButtonText** (),
        this text is returned.

        By default, the text on buttons depends on the **QWizard::wizardStyle**
        . For example, on macOS, the **Next** button is called **Continue**.

        **See also** **setButtonText** (), **QWizard::buttonText** (), and
        **QWizard::setButtonText** ().
        """
        ...

    def cleanupPage(self) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#cleanupPage

        **[virtual] void QWizardPage::cleanupPage()**

        This virtual function is called by **QWizard::cleanupPage** () when the
        user leaves the page by clicking **Back** (unless the
        **QWizard::IndependentPages**  option is set).

        The default implementation resets the page's fields to their original
        values (the values they had before **initializePage** () was called).

        **See also** **QWizard::cleanupPage** (), **initializePage** (), and
        **QWizard::IndependentPages** .
        """
        ...

    def field(self, name: str) -> Any:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#field

        **[protected] QVariant QWizardPage::field(const QString & name ) const**

        Returns the value of the field called **name**.

        This function can be used to access fields on any page of the wizard. It
        is equivalent to calling **wizard** ()->**field( **name** )** .

        Example:

        void OutputFilesPage::initializePage()
            {
                **QString**
        className = field("className").toString();
        headerLineEdit->setText(className.toLower() + ".h");
        implementationLineEdit->setText(className.toLower() + ".cpp");
        outputDirLineEdit->setText(**QDir** ::toNativeSeparators(**QDir**
        ::tempPath()));
            }

        **See also** **QWizard::field** (), **setField** (), and
        **registerField** ().
        """
        ...

    def initializePage(self) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#initializePage

        **[virtual] void QWizardPage::initializePage()**

        This virtual function is called by **QWizard::initializePage** () to
        prepare the page just before it is shown either as a result of
        **QWizard::restart** () being called, or as a result of the user
        clicking **Next**. (However, if the **QWizard::IndependentPages**
        option is set, this function is only called the first time the page is
        shown.)

        By reimplementing this function, you can ensure that the page's fields
        are properly initialized based on fields from previous pages. For
        example:

        void OutputFilesPage::initializePage()
            {
                **QString**
        className = field("className").toString();
        headerLineEdit->setText(className.toLower() + ".h");
        implementationLineEdit->setText(className.toLower() + ".cpp");
        outputDirLineEdit->setText(**QDir** ::toNativeSeparators(**QDir**
        ::tempPath()));
            }

        The default implementation does nothing.

        **See also** **QWizard::initializePage** (), **cleanupPage** (), and
        **QWizard::IndependentPages** .
        """
        ...

    def isCommitPage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#isCommitPage

        **bool QWizardPage::isCommitPage() const**

        Returns `true` if this page is a commit page; otherwise returns `false`.

        **See also** **setCommitPage** ().
        """
        ...

    def isComplete(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#isComplete

        **[virtual] bool QWizardPage::isComplete() const**

        This virtual function is called by **QWizard**  to determine whether the
        **Next** or **Finish** button should be enabled or disabled.

        The default implementation returns `true` if all **mandatory fields**
        are filled; otherwise, it returns `false`.

        If you reimplement this function, make sure to emit **completeChanged**
        (), from the rest of your implementation, whenever the value of
        isComplete() changes. This ensures that **QWizard**  updates the enabled
        or disabled state of its buttons. An example of the reimplementation is
        available **here** .

        **See also** **completeChanged** () and **isFinalPage** ().
        """
        ...

    def isFinalPage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#isFinalPage

        **bool QWizardPage::isFinalPage() const**

        This function is called by **QWizard**  to determine whether the
        **Finish** button should be shown for this page or not.

        By default, it returns `true` if there is no next page (i.e., **nextId**
        () returns -1); otherwise, it returns `false`.

        By explicitly calling **setFinalPage** (true), you can let the user
        perform an "early finish".

        **See also** **isComplete** () and
        **QWizard::HaveFinishButtonOnEarlyPages** .
        """
        ...

    def nextId(self) -> int:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#nextId

        **[virtual] int QWizardPage::nextId() const**

        This virtual function is called by **QWizard::nextId** () to find out
        which page to show when the user clicks the **Next** button.

        The return value is the ID of the next page, or -1 if no page follows.

        By default, this function returns the lowest ID greater than the ID of
        the current page, or -1 if there is no such ID.

        By reimplementing this function, you can specify a dynamic page order.
        For example:

        int IntroPage::nextId() const
            {
                if
        (evaluateRadioButton->isChecked()) {
                    return
        LicenseWizard::Page_Evaluate;
                } else {
                    return
        LicenseWizard::Page_Register;
                }
            }

        **See also** **QWizard::nextId** ().
        """
        ...

    def pixmap(
        self, which: PySide6.QtWidgets.QWizard.WizardPixmap
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#pixmap

        **QPixmap QWizardPage::pixmap(QWizard::WizardPixmap which ) const**

        Returns the pixmap set for role **which**.

        Pixmaps can also be set for the entire wizard using
        **QWizard::setPixmap** (), in which case they apply for all pages that
        don't specify a pixmap.

        **See also** **setPixmap** (), **QWizard::pixmap** (), and **Elements of
        a Wizard Page** .
        """
        ...

    def registerField(
        self,
        name: str,
        widget: PySide6.QtWidgets.QWidget,
        property: Optional[bytes] = ...,
        changedSignal: Optional[bytes] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#registerField

        **[protected] void QWizardPage::registerField(const QString & name ,
        QWidget * widget , const char * property = nullptr, const char *
        changedSignal = nullptr)**

        Creates a field called **name** associated with the given **property**
        of the given **widget**. From then on, that property becomes accessible
        using **field** () and **setField** ().

        Fields are global to the entire wizard and make it easy for any single
        page to access information stored by another page, without having to put
        all the logic in **QWizard**  or having the pages know explicitly about
        each other.

        If **name** ends with an asterisk (`*`), the field is a mandatory field.
        When a page has mandatory fields, the **Next** and/or **Finish** buttons
        are enabled only when all mandatory fields are filled. This requires a
        **changedSignal** to be specified, to tell **QWizard**  to recheck the
        value stored by the mandatory field.

        **QWizard**  knows the most common Qt widgets. For these (or their
        subclasses), you don't need to specify a **property** or a
        **changedSignal**. The table below lists these widgets:

        WidgetPropertyChange Notification Signal
        **QAbstractButton** bool
        **checked** **toggled** ()
        **QAbstractSlider** int **value**
        **valueChanged** ()
        **QComboBox** int **currentIndex**
        **currentIndexChanged** ()
        **QDateTimeEdit** **QDateTime**
        **dateTime** **dateTimeChanged** ()
        **QLineEdit** **QString**
        **text** **textChanged** ()
        **QListWidget** int **currentRow**
        **currentRowChanged** ()
        **QSpinBox** int **value** **valueChanged**
        ()

        You can use **QWizard::setDefaultProperty** () to add entries to this
        table or to override existing entries.

        To consider a field "filled", **QWizard**  simply checks that their
        current value doesn't equal their original value (the value they had
        before **initializePage** () was called). For **QLineEdit** , it also
        checks that **hasAcceptableInput** () returns true, to honor any
        validator or mask.

        **QWizard** 's mandatory field mechanism is provided for convenience. It
        can be bypassed by reimplementing **QWizardPage::isComplete** ().

        **See also** **field** (), **setField** (), and
        **QWizard::setDefaultProperty** ().
        """
        ...

    def setButtonText(
        self, which: PySide6.QtWidgets.QWizard.WizardButton, text: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#setButtonText

        **void QWizardPage::setButtonText(QWizard::WizardButton which , const
        QString & text )**

        Sets the text on button **which** to be **text** on this page.

        By default, the text on buttons depends on the **QWizard::wizardStyle**
        , but may be redefined for the wizard as a whole using
        **QWizard::setButtonText** ().

        **See also** **buttonText** (), **QWizard::setButtonText** (), and
        **QWizard::buttonText** ().
        """
        ...

    def setCommitPage(self, commitPage: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#setCommitPage

        **void QWizardPage::setCommitPage(bool commitPage )**

        Sets this page to be a commit page if **commitPage** is true; otherwise,
        sets it to be a normal page.

        A commit page is a page that represents an action which cannot be undone
        by clicking **Back** or **Cancel**.

        A **Commit** button replaces the **Next** button on a commit page.
        Clicking this button simply calls **QWizard::next** () just like
        clicking **Next** does.

        A page entered directly from a commit page has its **Back** button
        disabled.

        **See also** **isCommitPage** ().
        """
        ...

    def setField(self, name: str, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#setField

        **[protected] void QWizardPage::setField(const QString & name , const
        QVariant & value )**

        Sets the value of the field called **name** to **value**.

        This function can be used to set fields on any page of the wizard. It is
        equivalent to calling **wizard** ()->**setField( **name** , **value**
        )** .

        **See also** **QWizard::setField** (), **field** (), and
        **registerField** ().
        """
        ...

    def setFinalPage(self, finalPage: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#setFinalPage

        **void QWizardPage::setFinalPage(bool finalPage )**

        Explicitly sets this page to be final if **finalPage** is true.

        After calling setFinalPage(true), **isFinalPage** () returns `true` and
        the **Finish** button is visible (and enabled if **isComplete** ()
        returns true).

        After calling setFinalPage(false), **isFinalPage** () returns `true` if
        **nextId** () returns -1; otherwise, it returns `false`.

        **See also** **isFinalPage** (), **isComplete** (), and
        **QWizard::HaveFinishButtonOnEarlyPages** .
        """
        ...

    def setPixmap(
        self,
        which: PySide6.QtWidgets.QWizard.WizardPixmap,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#setPixmap

        **void QWizardPage::setPixmap(QWizard::WizardPixmap which , const
        QPixmap & pixmap )**

        Sets the pixmap for role **which** to **pixmap**.

        The pixmaps are used by **QWizard**  when displaying a page. Which
        pixmaps are actually used depend on the **wizard style** .

        Pixmaps can also be set for the entire wizard using
        **QWizard::setPixmap** (), in which case they apply for all pages that
        don't specify a pixmap.

        **See also** **pixmap** (), **QWizard::setPixmap** (), and **Elements of
        a Wizard Page** .
        """
        ...

    def setSubTitle(self, subTitle: str) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#subTitle-prop

        **subTitle : QString**

        This property holds the subtitle of the page

        The subtitle is shown by the **QWizard** , between the title and the
        actual page. Subtitles are optional. In **ClassicStyle**  and
        **ModernStyle** , using subtitles is necessary to make the header
        appear. In **MacStyle** , the subtitle is shown as a text label just
        above the actual page.

        The subtitle may be plain text or HTML, depending on the value of the
        **QWizard::subTitleFormat**  property.

        By default, this property contains an empty string.

        **Access functions:**

        QString **subTitle** () const
        void **setSubTitle** (const QString &
        **subTitle** )

        **See also** **title** , **QWizard::IgnoreSubTitles** , and **Elements
        of a Wizard Page** .
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#title-prop

        **title : QString**

        This property holds the title of the page

        The title is shown by the **QWizard** , above the actual page. All pages
        should have a title.

        The title may be plain text or HTML, depending on the value of the
        **QWizard::titleFormat**  property.

        By default, this property contains an empty string.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **subTitle**  and **Elements of a Wizard Page** .

        **Member Function Documentation**
        """
        ...

    def subTitle(self) -> str:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#subTitle-prop

        **subTitle : QString**

        This property holds the subtitle of the page

        The subtitle is shown by the **QWizard** , between the title and the
        actual page. Subtitles are optional. In **ClassicStyle**  and
        **ModernStyle** , using subtitles is necessary to make the header
        appear. In **MacStyle** , the subtitle is shown as a text label just
        above the actual page.

        The subtitle may be plain text or HTML, depending on the value of the
        **QWizard::subTitleFormat**  property.

        By default, this property contains an empty string.

        **Access functions:**

        QString **subTitle** () const
        void **setSubTitle** (const QString &
        **subTitle** )

        **See also** **title** , **QWizard::IgnoreSubTitles** , and **Elements
        of a Wizard Page** .
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#title-prop

        **title : QString**

        This property holds the title of the page

        The title is shown by the **QWizard** , above the actual page. All pages
        should have a title.

        The title may be plain text or HTML, depending on the value of the
        **QWizard::titleFormat**  property.

        By default, this property contains an empty string.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **subTitle**  and **Elements of a Wizard Page** .

        **Member Function Documentation**
        """
        ...

    def validatePage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#validatePage

        **[virtual] bool QWizardPage::validatePage()**

        This virtual function is called by **QWizard::validateCurrentPage** ()
        when the user clicks **Next** or **Finish** to perform some last-minute
        validation. If it returns `true`, the next page is shown (or the wizard
        finishes); otherwise, the current page stays up.

        The default implementation returns `true`.

        When possible, it is usually better style to disable the **Next** or
        **Finish** button (by specifying **mandatory fields**  or reimplementing
        **isComplete** ()) than to reimplement validatePage().

        **See also** **QWizard::validateCurrentPage** () and **isComplete** ().
        """
        ...

    def wizard(self) -> PySide6.QtWidgets.QWizard:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#wizard

        **[protected] QWizard *QWizardPage::wizard() const**

        Returns the wizard associated with this page, or `nullptr` if this page
        hasn't been inserted into a **QWizard**  yet.

        **See also** **QWizard::addPage** () and **QWizard::setPage** ().
        """
        ...

    @property
    def completeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwizardpage.html#completeChanged

        **[signal] void QWizardPage::completeChanged()**

        This signal is emitted whenever the complete state of the page (i.e.,
        the value of **isComplete** ()) changes.

        If you reimplement **isComplete** (), make sure to emit
        completeChanged() whenever the value of **isComplete** () changes, to
        ensure that **QWizard**  updates the enabled or disabled state of its
        buttons.

        **See also** **isComplete** ().
        """
        ...
