"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTreeView(PySide6.QtWidgets.QAbstractItemView):
    """
    https://doc.qt.io/qt-6/qtreeview.html

    **Detailed Description**

    ![](images/windows-treeview.png)

    A QTreeView implements a tree representation of items from a model. This
    class is used to provide standard hierarchical lists that were previously
    provided by the `QListView` class, but using the more flexible approach
    provided by Qt's model/view architecture.

    The QTreeView class is one of the **Model/View Classes**  and is part of
    Qt's **model/view framework** .

    QTreeView implements the interfaces defined by the **QAbstractItemView**
    class to allow it to display data provided by models derived from the
    **QAbstractItemModel**  class.

    It is simple to construct a tree view displaying data from a model. In the
    following example, the contents of a directory are supplied by a
    **QFileSystemModel**  and displayed as a tree:

    **QFileSystemModel**  *model = new **QFileSystemModel** ;
    model->setRootPath(**QDir** ::currentPath());
            **QTreeView**  *tree =
    new **QTreeView** (splitter);
            tree->setModel(model);

    The model/view architecture ensures that the contents of the tree view are
    updated as the model changes.

    Items that have children can be in an expanded (children are visible) or
    collapsed (children are hidden) state. When this state changes a
    **collapsed** () or **expanded** () signal is emitted with the model index
    of the relevant item.

    The amount of indentation used to indicate levels of hierarchy is controlled
    by the **indentation**  property.

    Headers in tree views are constructed using the **QHeaderView**  class and
    can be hidden using `header()->hide()`. Note that each header is configured
    with its **stretchLastSection**  property set to true, ensuring that the
    view does not waste any of the space assigned to it for its header. If this
    value is set to true, this property will override the resize mode set on the
    last section in the header.

    By default, all columns in a tree view are movable except the first. To
    disable movement of these columns, use **QHeaderView** 's
    **setSectionsMovable** () function. For more information about rearranging
    sections, see **Moving Header Sections** .

    **Key Bindings**

    QTreeView supports a set of key bindings that enable the user to navigate in
    the view and interact with the contents of items:

    KeyAction
    UpMoves the cursor to the item in the same column on the
    previous row. If the parent of the current item has no more rows to navigate
    to, the cursor moves to the relevant item in the last row of the sibling
    that precedes the parent.
    DownMoves the cursor to the item in the same
    column on the next row. If the parent of the current item has no more rows
    to navigate to, the cursor moves to the relevant item in the first row of
    the sibling that follows the parent.
    LeftHides the children of the current
    item (if present) by collapsing a branch.
    MinusSame as Left.
    RightReveals the children of the current item (if present) by expanding a
    branch.
    PlusSame as Right.
    AsteriskExpands the current item and all its
    children (if present).
    PageUpMoves the cursor up one page.
    PageDownMoves
    the cursor down one page.
    HomeMoves the cursor to an item in the same
    column of the first row of the first top-level item in the model.
    EndMoves
    the cursor to an item in the same column of the last row of the last top-
    level item in the model.
    F2In editable models, this opens the current item
    for editing. The Escape key can be used to cancel the editing process and
    revert any changes to the data displayed.

    **Improving Performance**

    It is possible to give the view hints about the data it is handling in order
    to improve its performance when displaying large numbers of items. One
    approach that can be taken for views that are intended to display items with
    equal heights is to set the **uniformRowHeights**  property to true.

    **See also** **QListView** , **QTreeWidget** , **View Classes** ,
    **QAbstractItemModel** , **QAbstractItemView** , and **Dir View Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#QTreeView

        **QTreeView::QTreeView(QWidget * parent = nullptr)**

        Constructs a tree view with a **parent** to represent a model's data.
        Use **setModel** () to set the model.

        **See also** **QAbstractItemModel** .
        """
        ...

    def allColumnsShowFocus(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#allColumnsShowFocus-prop

        **allColumnsShowFocus : bool**

        This property holds whether items should show keyboard focus using all
        columns

        If this property is `true` all columns will show focus, otherwise only
        one column will show focus.

        The default is false.

        **Access functions:**

        bool **allColumnsShowFocus** () const
        void **setAllColumnsShowFocus**
        (bool **enable** )
        """
        ...

    def autoExpandDelay(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#autoExpandDelay-prop

        **autoExpandDelay : int**

        This property holds the delay time before items in a tree are opened
        during a drag and drop operation.

        This property holds the amount of time in milliseconds that the user
        must wait over a node before that node will automatically open or close.
        If the time is set to less then 0 then it will not be activated.

        By default, this property has a value of -1, meaning that auto-expansion
        is disabled.

        **Access functions:**

        int **autoExpandDelay** () const
        void **setAutoExpandDelay** (int
        **delay** )
        """
        ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#changeEvent

        **[override virtual protected] void QTreeView::changeEvent(QEvent *
        event )**

        Reimplements: **QFrame::changeEvent** (QEvent *ev).
        """
        ...

    def collapse(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#collapse

        **[slot] void QTreeView::collapse(const QModelIndex & index )**

        Collapses the model item specified by the **index**.

        **See also** **collapsed** ().
        """
        ...

    def collapseAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#collapseAll

        **[slot] void QTreeView::collapseAll()**

        Collapses all expanded items.

        **See also** **expandAll** (), **expand** (), **collapse** (), and
        **setExpanded** ().
        """
        ...

    def columnAt(self, x: int) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#columnAt

        **int QTreeView::columnAt(int x ) const**

        Returns the column in the tree view whose header covers the **x**
        coordinate given.
        """
        ...

    def columnCountChanged(self, oldCount: int, newCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#columnCountChanged

        **[protected slot] void QTreeView::columnCountChanged(int oldCount , int
        newCount )**

        Informs the tree view that the number of columns in the tree view has
        changed from **oldCount** to **newCount**.
        """
        ...

    def columnMoved(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#columnMoved

        **[protected slot] void QTreeView::columnMoved()**

        This slot is called whenever a column has been moved.
        """
        ...

    def columnResized(self, column: int, oldSize: int, newSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#columnResized

        **[protected slot] void QTreeView::columnResized(int column , int
        oldSize , int newSize )**

        This function is called whenever **column** 's size is changed in the
        header. **oldSize** and **newSize** give the previous size and the new
        size in pixels.

        **See also** **setColumnWidth** ().
        """
        ...

    def columnViewportPosition(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#columnViewportPosition

        **int QTreeView::columnViewportPosition(int column ) const**

        Returns the horizontal position of the **column** in the viewport.
        """
        ...

    def columnWidth(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#columnWidth

        **int QTreeView::columnWidth(int column ) const**

        Returns the width of the **column**.

        **See also** **resizeColumnToContents** () and **setColumnWidth** ().
        """
        ...

    def currentChanged(
        self,
        current: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        previous: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#currentChanged

        **[override virtual protected] void QTreeView::currentChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        Reimplements: **QAbstractItemView::currentChanged** (const QModelIndex
        &current, const QModelIndex &previous).
        """
        ...

    def dataChanged(
        self,
        topLeft: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        bottomRight: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        roles: Sequence[int] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#dataChanged

        **[override virtual] void QTreeView::dataChanged(const QModelIndex &
        topLeft , const QModelIndex & bottomRight , const QList<int> & roles =
        QList<int>())**

        Reimplements: **QAbstractItemView::dataChanged** (const QModelIndex
        &topLeft, const QModelIndex &bottomRight, const QList<int> &roles).
        """
        ...

    def doItemsLayout(self) -> None:
        ...

    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#dragMoveEvent

        **[override virtual protected] void
        QTreeView::dragMoveEvent(QDragMoveEvent * event )**

        Reimplements: **QAbstractItemView::dragMoveEvent** (QDragMoveEvent
        *event).
        """
        ...

    def drawBranches(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#drawBranches

        **[virtual protected] void QTreeView::drawBranches(QPainter * painter ,
        const QRect & rect , const QModelIndex & index ) const**

        Draws the branches in the tree view on the same row as the model item
        **index** , using the **painter** given. The branches are drawn in the
        rectangle specified by **rect**.
        """
        ...

    def drawRow(
        self,
        painter: PySide6.QtGui.QPainter,
        options: PySide6.QtWidgets.QStyleOptionViewItem,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#drawRow

        **[virtual protected] void QTreeView::drawRow(QPainter * painter , const
        QStyleOptionViewItem & option , const QModelIndex & index ) const**

        Draws the row in the tree view that contains the model item **index** ,
        using the **painter** given. The **option** controls how the item is
        displayed.

        **See also** **setAlternatingRowColors** ().
        """
        ...

    def drawTree(
        self,
        painter: PySide6.QtGui.QPainter,
        region: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#drawTree

        **[protected] void QTreeView::drawTree(QPainter * painter , const
        QRegion & region ) const**

        Draws the part of the tree intersecting the given **region** using the
        specified **painter**.

        **See also** **paintEvent** ().
        """
        ...

    def expand(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expand

        **[slot] void QTreeView::expand(const QModelIndex & index )**

        Expands the model item specified by the **index**.

        **See also** **expanded** ().
        """
        ...

    def expandAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expandAll

        **[slot] void QTreeView::expandAll()**

        Expands all expandable items.

        **Note:** This function will not try to **fetch more**  data.

        **Warning:** If the model contains a large number of items, this
        function will take some time to execute.

        **See also** **collapseAll** (), **expand** (), **collapse** (), and
        **setExpanded** ().
        """
        ...

    def expandRecursively(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        depth: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expandRecursively

        **[slot, since 5.13] void QTreeView::expandRecursively(const QModelIndex
        & index , int depth = -1)**

        Expands the item at the given **index** and all its children to the
        given **depth**. The **depth** is relative to the given **index**. A
        **depth** of -1 will expand all children, a **depth** of 0 will only
        expand the given **index**.

        **Note:** This function will not try to **fetch more**  data.

        **Warning:** If the model contains a large number of items, this
        function will take some time to execute.

        This function was introduced in Qt 5.13.

        **See also** **expandAll** ().
        """
        ...

    def expandToDepth(self, depth: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expandToDepth

        **[slot] void QTreeView::expandToDepth(int depth )**

        Expands all expandable items to the given **depth**.

        **Note:** This function will not try to **fetch more**  data.

        **See also** **expandAll** (), **collapseAll** (), **expand** (),
        **collapse** (), and **setExpanded** ().
        """
        ...

    def expandsOnDoubleClick(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expandsOnDoubleClick-prop

        **expandsOnDoubleClick : bool**

        This property holds whether the items can be expanded by double-
        clicking.

        This property holds whether the user can expand and collapse items by
        double-clicking. The default value is true.

        **Access functions:**

        bool **expandsOnDoubleClick** () const
        void
        **setExpandsOnDoubleClick** (bool **enable** )

        **See also** **itemsExpandable** .
        """
        ...

    def header(self) -> PySide6.QtWidgets.QHeaderView:
        """
        https://doc.qt.io/qt-6/qtreeview.html#header

        **QHeaderView *QTreeView::header() const**

        Returns the header for the tree view.

        **See also** **setHeader** () and **QAbstractItemModel::headerData** ().
        """
        ...

    def hideColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#hideColumn

        **[slot] void QTreeView::hideColumn(int column )**

        Hides the **column** given.

        **Note:** This function should only be called after the model has been
        initialized, as the view needs to know the number of columns in order to
        hide **column**.

        **See also** **showColumn** () and **setColumnHidden** ().
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#horizontalOffset

        **[override virtual protected] int QTreeView::horizontalOffset() const**

        Reimplements: **QAbstractItemView::horizontalOffset() const** .

        Returns the horizontal offset of the items in the treeview.

        Note that the tree view uses the horizontal header section positions to
        determine the positions of columns in the view.

        **See also** **verticalOffset** ().
        """
        ...

    def horizontalScrollbarAction(self, action: int) -> None:
        ...

    def indentation(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#indentation-prop

        **indentation : int**

        indentation of the items in the tree view.

        This property holds the indentation measured in pixels of the items for
        each level in the tree view. For top-level items, the indentation
        specifies the horizontal distance from the viewport edge to the items in
        the first column; for child items, it specifies their indentation from
        their parent items.

        By default, the value of this property is style dependent. Thus, when
        the style changes, this property updates from it. Calling
        setIndentation() stops the updates, calling resetIndentation() will
        restore default behavior.

        **Access functions:**

        int **indentation** () const
        void **setIndentation** (int **i** )
        void **resetIndentation** ()
        """
        ...

    def indexAbove(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qtreeview.html#indexAbove

        **QModelIndex QTreeView::indexAbove(const QModelIndex & index ) const**

        Returns the model index of the item above **index**.
        """
        ...

    def indexAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qtreeview.html#indexAt

        **[override virtual] QModelIndex QTreeView::indexAt(const QPoint & point
        ) const**

        Reimplements: **QAbstractItemView::indexAt(const QPoint &point) const**
        .
        """
        ...

    def indexBelow(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qtreeview.html#indexBelow

        **QModelIndex QTreeView::indexBelow(const QModelIndex & index ) const**

        Returns the model index of the item below **index**.
        """
        ...

    def indexRowSizeHint(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#indexRowSizeHint

        **[protected] int QTreeView::indexRowSizeHint(const QModelIndex & index
        ) const**

        Returns the size hint for the row indicated by **index**.

        **See also** **sizeHintForColumn** () and **uniformRowHeights** ().
        """
        ...

    def isAnimated(self) -> bool:
        ...

    def isColumnHidden(self, column: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#isColumnHidden

        **bool QTreeView::isColumnHidden(int column ) const**

        Returns `true` if the **column** is hidden; otherwise returns `false`.

        **See also** **hideColumn** () and **isRowHidden** ().
        """
        ...

    def isExpanded(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#isExpanded

        **bool QTreeView::isExpanded(const QModelIndex & index ) const**

        Returns `true` if the model item **index** is expanded; otherwise
        returns false.

        **See also** **expand** (), **expanded** (), and **setExpanded** ().
        """
        ...

    def isFirstColumnSpanned(
        self,
        row: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#isFirstColumnSpanned

        **bool QTreeView::isFirstColumnSpanned(int row , const QModelIndex &
        parent ) const**

        Returns `true` if the item in first column in the given **row** of the
        **parent** is spanning all the columns; otherwise returns `false`.

        **See also** **setFirstColumnSpanned** ().
        """
        ...

    def isHeaderHidden(self) -> bool:
        ...

    def isIndexHidden(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#isIndexHidden

        **[override virtual protected] bool QTreeView::isIndexHidden(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemView::isIndexHidden(const QModelIndex
        &index) const** .
        """
        ...

    def isRowHidden(
        self,
        row: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#isRowHidden

        **bool QTreeView::isRowHidden(int row , const QModelIndex & parent )
        const**

        Returns `true` if the item in the given **row** of the **parent** is
        hidden; otherwise returns `false`.

        **See also** **setRowHidden** () and **isColumnHidden** ().
        """
        ...

    def isSortingEnabled(self) -> bool:
        ...

    def itemsExpandable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#itemsExpandable-prop

        **itemsExpandable : bool**

        This property holds whether the items are expandable by the user.

        This property holds whether the user can expand and collapse items
        interactively.

        By default, this property is `true`.

        **Access functions:**

        bool **itemsExpandable** () const
        void **setItemsExpandable** (bool
        **enable** )
        """
        ...

    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#keyPressEvent

        **[override virtual protected] void QTreeView::keyPressEvent(QKeyEvent *
        event )**

        Reimplements: **QAbstractItemView::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def keyboardSearch(self, search: str) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#keyboardSearch

        **[override virtual] void QTreeView::keyboardSearch(const QString &
        search )**

        Reimplements: **QAbstractItemView::keyboardSearch** (const QString
        &search).
        """
        ...

    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QTreeView::mouseDoubleClickEvent(QMouseEvent * event )**

        Reimplements: **QAbstractItemView::mouseDoubleClickEvent** (QMouseEvent
        *event).
        """
        ...

    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#mouseMoveEvent

        **[override virtual protected] void
        QTreeView::mouseMoveEvent(QMouseEvent * event )**

        Reimplements: **QAbstractItemView::mouseMoveEvent** (QMouseEvent
        *event).
        """
        ...

    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#mousePressEvent

        **[override virtual protected] void
        QTreeView::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QAbstractItemView::mousePressEvent** (QMouseEvent
        *event).
        """
        ...

    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#mouseReleaseEvent

        **[override virtual protected] void
        QTreeView::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QAbstractItemView::mouseReleaseEvent** (QMouseEvent
        *event).
        """
        ...

    def moveCursor(
        self,
        cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qtreeview.html#moveCursor

        **[override virtual protected] QModelIndex
        QTreeView::moveCursor(QAbstractItemView::CursorAction cursorAction ,
        Qt::KeyboardModifiers modifiers )**

        Reimplements: **QAbstractItemView::moveCursor**
        (QAbstractItemView::CursorAction cursorAction, Qt::KeyboardModifiers
        modifiers).

        Move the cursor in the way described by **cursorAction** , using the
        information provided by the button **modifiers**.
        """
        ...

    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#paintEvent

        **[override virtual protected] void QTreeView::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).
        """
        ...

    def reexpand(self) -> None:
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#reset

        **[override virtual] void QTreeView::reset()**

        Reimplements: **QAbstractItemView::reset** ().
        """
        ...

    def resetIndentation(self) -> None:
        ...

    def resizeColumnToContents(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#resizeColumnToContents

        **[slot] void QTreeView::resizeColumnToContents(int column )**

        Resizes the **column** given to the size of its contents.

        **See also** **columnWidth** (), **setColumnWidth** (),
        **sizeHintForColumn** (), and **QHeaderView::resizeContentsPrecision**
        ().
        """
        ...

    def rootIsDecorated(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#rootIsDecorated-prop

        **rootIsDecorated : bool**

        This property holds whether to show controls for expanding and
        collapsing top-level items

        Items with children are typically shown with controls to expand and
        collapse them, allowing their children to be shown or hidden. If this
        property is false, these controls are not shown for top-level items.
        This can be used to make a single level tree structure appear like a
        simple list of items.

        By default, this property is `true`.

        **Access functions:**

        bool **rootIsDecorated** () const
        void **setRootIsDecorated** (bool
        **show** )
        """
        ...

    def rowHeight(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#rowHeight

        **[protected] int QTreeView::rowHeight(const QModelIndex & index )
        const**

        Returns the height of the row indicated by the given **index**.

        **See also** **indexRowSizeHint** ().
        """
        ...

    def rowsAboutToBeRemoved(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        start: int,
        end: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#rowsAboutToBeRemoved

        **[override virtual protected] void
        QTreeView::rowsAboutToBeRemoved(const QModelIndex & parent , int start ,
        int end )**

        Reimplements: **QAbstractItemView::rowsAboutToBeRemoved** (const
        QModelIndex &parent, int start, int end).

        Informs the view that the rows from the **start** row to the **end** row
        inclusive are about to removed from the given **parent** model item.
        """
        ...

    def rowsInserted(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        start: int,
        end: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#rowsInserted

        **[override virtual protected] void QTreeView::rowsInserted(const
        QModelIndex & parent , int start , int end )**

        Reimplements: **QAbstractItemView::rowsInserted** (const QModelIndex
        &parent, int start, int end).

        Informs the view that the rows from the **start** row to the **end** row
        inclusive have been inserted into the **parent** model item.
        """
        ...

    def rowsRemoved(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        first: int,
        last: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#rowsRemoved

        **[protected slot] void QTreeView::rowsRemoved(const QModelIndex &
        parent , int start , int end )**

        Informs the view that the rows from the **start** row to the **end** row
        inclusive have been removed from the given **parent** model item.
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#scrollContentsBy

        **[override virtual protected] void QTreeView::scrollContentsBy(int dx ,
        int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).

        Scrolls the contents of the tree view by ( **dx** , **dy** ).
        """
        ...

    def scrollTo(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#scrollTo

        **[override virtual] void QTreeView::scrollTo(const QModelIndex & index
        , QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Reimplements: **QAbstractItemView::scrollTo** (const QModelIndex &index,
        QAbstractItemView::ScrollHint hint).

        Scroll the contents of the tree view until the given model item
        **index** is visible. The **hint** parameter specifies more precisely
        where the item should be located after the operation. If any of the
        parents of the model item are collapsed, they will be expanded to ensure
        that the model item is visible.
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#selectAll

        **[override virtual] void QTreeView::selectAll()**

        Reimplements: **QAbstractItemView::selectAll** ().
        """
        ...

    def selectedIndexes(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qtreeview.html#selectedIndexes

        **[override virtual protected] QModelIndexList
        QTreeView::selectedIndexes() const**

        Reimplements: **QAbstractItemView::selectedIndexes() const** .
        """
        ...

    def selectionChanged(
        self,
        selected: PySide6.QtCore.QItemSelection,
        deselected: PySide6.QtCore.QItemSelection,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#selectionChanged

        **[override virtual protected] void QTreeView::selectionChanged(const
        QItemSelection & selected , const QItemSelection & deselected )**

        Reimplements: **QAbstractItemView::selectionChanged** (const
        QItemSelection &selected, const QItemSelection &deselected).
        """
        ...

    def setAllColumnsShowFocus(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#allColumnsShowFocus-prop

        **allColumnsShowFocus : bool**

        This property holds whether items should show keyboard focus using all
        columns

        If this property is `true` all columns will show focus, otherwise only
        one column will show focus.

        The default is false.

        **Access functions:**

        bool **allColumnsShowFocus** () const
        void **setAllColumnsShowFocus**
        (bool **enable** )
        """
        ...

    def setAnimated(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#animated-prop

        **animated : bool**

        This property holds whether animations are enabled

        If this property is `true` the treeview will animate expansion and
        collapsing of branches. If this property is `false`, the treeview will
        expand or collapse branches immediately without showing the animation.

        By default, this property is `false`.

        **Access functions:**

        bool **isAnimated** () const
        void **setAnimated** (bool **enable** )
        """
        ...

    def setAutoExpandDelay(self, delay: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#autoExpandDelay-prop

        **autoExpandDelay : int**

        This property holds the delay time before items in a tree are opened
        during a drag and drop operation.

        This property holds the amount of time in milliseconds that the user
        must wait over a node before that node will automatically open or close.
        If the time is set to less then 0 then it will not be activated.

        By default, this property has a value of -1, meaning that auto-expansion
        is disabled.

        **Access functions:**

        int **autoExpandDelay** () const
        void **setAutoExpandDelay** (int
        **delay** )
        """
        ...

    def setColumnHidden(self, column: int, hide: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setColumnHidden

        **void QTreeView::setColumnHidden(int column , bool hide )**

        If **hide** is true the **column** is hidden, otherwise the **column**
        is shown.

        **See also** **isColumnHidden** (), **hideColumn** (), and
        **setRowHidden** ().
        """
        ...

    def setColumnWidth(self, column: int, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setColumnWidth

        **void QTreeView::setColumnWidth(int column , int width )**

        Sets the width of the given **column** to the **width** specified.

        **See also** **columnWidth** () and **resizeColumnToContents** ().
        """
        ...

    def setExpanded(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        expand: bool,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setExpanded

        **void QTreeView::setExpanded(const QModelIndex & index , bool expanded
        )**

        Sets the item referred to by **index** to either collapse or expanded,
        depending on the value of **expanded**.

        **See also** **expanded** (), **expand** (), and **isExpanded** ().
        """
        ...

    def setExpandsOnDoubleClick(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expandsOnDoubleClick-prop

        **expandsOnDoubleClick : bool**

        This property holds whether the items can be expanded by double-
        clicking.

        This property holds whether the user can expand and collapse items by
        double-clicking. The default value is true.

        **Access functions:**

        bool **expandsOnDoubleClick** () const
        void
        **setExpandsOnDoubleClick** (bool **enable** )

        **See also** **itemsExpandable** .
        """
        ...

    def setFirstColumnSpanned(
        self,
        row: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        span: bool,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setFirstColumnSpanned

        **void QTreeView::setFirstColumnSpanned(int row , const QModelIndex &
        parent , bool span )**

        If **span** is true the item in the first column in the **row** with the
        given **parent** is set to span all columns, otherwise all items on the
        **row** are shown.

        **See also** **isFirstColumnSpanned** ().
        """
        ...

    def setHeader(self, header: PySide6.QtWidgets.QHeaderView) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setHeader

        **void QTreeView::setHeader(QHeaderView * header )**

        Sets the header for the tree view, to the given **header**.

        The view takes ownership over the given **header** and deletes it when a
        new header is set.

        **See also** **QAbstractItemModel::headerData** ().
        """
        ...

    def setHeaderHidden(self, hide: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#headerHidden-prop

        **headerHidden : bool**

        This property holds whether the header is shown or not.

        If this property is `true`, the header is not shown otherwise it is. The
        default value is false.

        **Access functions:**

        bool **isHeaderHidden** () const
        void **setHeaderHidden** (bool
        **hide** )

        **See also** **header** ().
        """
        ...

    def setIndentation(self, i: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#indentation-prop

        **indentation : int**

        indentation of the items in the tree view.

        This property holds the indentation measured in pixels of the items for
        each level in the tree view. For top-level items, the indentation
        specifies the horizontal distance from the viewport edge to the items in
        the first column; for child items, it specifies their indentation from
        their parent items.

        By default, the value of this property is style dependent. Thus, when
        the style changes, this property updates from it. Calling
        setIndentation() stops the updates, calling resetIndentation() will
        restore default behavior.

        **Access functions:**

        int **indentation** () const
        void **setIndentation** (int **i** )
        void **resetIndentation** ()
        """
        ...

    def setItemsExpandable(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#itemsExpandable-prop

        **itemsExpandable : bool**

        This property holds whether the items are expandable by the user.

        This property holds whether the user can expand and collapse items
        interactively.

        By default, this property is `true`.

        **Access functions:**

        bool **itemsExpandable** () const
        void **setItemsExpandable** (bool
        **enable** )
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setModel

        **[override virtual] void QTreeView::setModel(QAbstractItemModel * model
        )**

        Reimplements: **QAbstractItemView::setModel** (QAbstractItemModel
        *model).
        """
        ...

    def setRootIndex(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setRootIndex

        **[override virtual] void QTreeView::setRootIndex(const QModelIndex &
        index )**

        Reimplements: **QAbstractItemView::setRootIndex** (const QModelIndex
        &index).
        """
        ...

    def setRootIsDecorated(self, show: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#rootIsDecorated-prop

        **rootIsDecorated : bool**

        This property holds whether to show controls for expanding and
        collapsing top-level items

        Items with children are typically shown with controls to expand and
        collapse them, allowing their children to be shown or hidden. If this
        property is false, these controls are not shown for top-level items.
        This can be used to make a single level tree structure appear like a
        simple list of items.

        By default, this property is `true`.

        **Access functions:**

        bool **rootIsDecorated** () const
        void **setRootIsDecorated** (bool
        **show** )
        """
        ...

    def setRowHidden(
        self,
        row: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        hide: bool,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setRowHidden

        **void QTreeView::setRowHidden(int row , const QModelIndex & parent ,
        bool hide )**

        If **hide** is true the **row** with the given **parent** is hidden,
        otherwise the **row** is shown.

        **See also** **isRowHidden** () and **setColumnHidden** ().
        """
        ...

    def setSelection(
        self,
        rect: PySide6.QtCore.QRect,
        command: PySide6.QtCore.QItemSelectionModel.SelectionFlags,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setSelection

        **[override virtual protected] void QTreeView::setSelection(const QRect
        & rect , QItemSelectionModel::SelectionFlags command )**

        Reimplements: **QAbstractItemView::setSelection** (const QRect &rect,
        QItemSelectionModel::SelectionFlags flags).

        Applies the selection **command** to the items in or touched by the
        rectangle, **rect**.

        **See also** **selectionCommand** ().
        """
        ...

    def setSelectionModel(
        self, selectionModel: PySide6.QtCore.QItemSelectionModel
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setSelectionModel

        **[override virtual] void
        QTreeView::setSelectionModel(QItemSelectionModel * selectionModel )**

        Reimplements: **QAbstractItemView::setSelectionModel**
        (QItemSelectionModel *selectionModel).
        """
        ...

    def setSortingEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#sortingEnabled-prop

        **sortingEnabled : bool**

        This property holds whether sorting is enabled

        If this property is `true`, sorting is enabled for the tree; if the
        property is false, sorting is not enabled. The default value is false.

        **Note:** In order to avoid performance issues, it is recommended that
        sorting is enabled **after** inserting the items into the tree.
        Alternatively, you could also insert the items into a list before
        inserting the items into the tree.

        **Access functions:**

        bool **isSortingEnabled** () const
        void **setSortingEnabled** (bool
        **enable** )

        **See also** **sortByColumn** ().
        """
        ...

    def setTreePosition(self, logicalIndex: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#setTreePosition

        **[since 5.2] void QTreeView::setTreePosition(int index )**

        This specifies that the tree structure should be placed at logical index
        **index**. If  set to -1 then the tree will always follow visual index
        0.

        This function was introduced in Qt 5.2.

        **See also** **treePosition** (), **QHeaderView::swapSections** (), and
        **QHeaderView::moveSection** ().
        """
        ...

    def setUniformRowHeights(self, uniform: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#uniformRowHeights-prop

        **uniformRowHeights : bool**

        This property holds whether all items in the treeview have the same
        height

        This property should only be set to true if it is guaranteed that all
        items in the view has the same height. This enables the view to do some
        optimizations.

        The height is obtained from the first item in the view. It is updated
        when the data changes on that item.

        **Note:** If the editor size hint is bigger than the cell size hint,
        then the size hint of the editor will be used.

        By default, this property is `false`.

        **Access functions:**

        bool **uniformRowHeights** () const
        void **setUniformRowHeights**
        (bool **uniform** )
        """
        ...

    def setWordWrap(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the item text word-wrapping policy

        If this property is `true` then the item text is wrapped where necessary
        at word-breaks; otherwise it is not wrapped at all. This property is
        `false` by default.

        Note that even if wrapping is enabled, the cell will not be expanded to
        fit all text. Ellipsis will be inserted according to the current
        **textElideMode** .

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **Member Function Documentation**
        """
        ...

    def showColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#showColumn

        **[slot] void QTreeView::showColumn(int column )**

        Shows the given **column** in the tree view.

        **See also** **hideColumn** () and **setColumnHidden** ().
        """
        ...

    def sizeHintForColumn(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#sizeHintForColumn

        **[override virtual protected] int QTreeView::sizeHintForColumn(int
        column ) const**

        Reimplements: **QAbstractItemView::sizeHintForColumn(int column) const**
        .

        Returns the size hint for the **column** 's width or -1 if there is no
        model.

        If you need to set the width of a given column to a fixed value, call
        **QHeaderView::resizeSection** () on the view's header.

        If you reimplement this function in a subclass, note that the value you
        return is only used when **resizeColumnToContents** () is called. In
        that case, if a larger column width is required by either the view's
        header or the item delegate, that width will be used instead.

        **See also** **QWidget::sizeHint** , **header** (), and
        **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def sortByColumn(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#sortByColumn

        **[slot] void QTreeView::sortByColumn(int column , Qt::SortOrder order
        )**

        Sorts the model by the values in the given **column** and **order**.

        **column** may be -1, in which case no sort indicator will be shown and
        the model will return to its natural, unsorted order. Note that not all
        models support this and may even crash in this case.

        **See also** **sortingEnabled** .
        """
        ...

    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#timerEvent

        **[override virtual protected] void QTreeView::timerEvent(QTimerEvent *
        event )**

        Reimplements: **QAbstractItemView::timerEvent** (QTimerEvent *event).
        """
        ...

    def treePosition(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#treePosition

        **[since 5.2] int QTreeView::treePosition() const**

        Return the logical index the tree is set on. If the return value is -1
        then the tree is placed on the visual index 0.

        This function was introduced in Qt 5.2.

        **See also** **setTreePosition** ().
        """
        ...

    def uniformRowHeights(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#uniformRowHeights-prop

        **uniformRowHeights : bool**

        This property holds whether all items in the treeview have the same
        height

        This property should only be set to true if it is guaranteed that all
        items in the view has the same height. This enables the view to do some
        optimizations.

        The height is obtained from the first item in the view. It is updated
        when the data changes on that item.

        **Note:** If the editor size hint is bigger than the cell size hint,
        then the size hint of the editor will be used.

        By default, this property is `false`.

        **Access functions:**

        bool **uniformRowHeights** () const
        void **setUniformRowHeights**
        (bool **uniform** )
        """
        ...

    def updateGeometries(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreeview.html#updateGeometries

        **[override virtual protected] void QTreeView::updateGeometries()**

        Reimplements: **QAbstractItemView::updateGeometries** ().
        """
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreeview.html#verticalOffset

        **[override virtual protected] int QTreeView::verticalOffset() const**

        Reimplements: **QAbstractItemView::verticalOffset() const** .

        Returns the vertical offset of the items in the tree view.

        **See also** **horizontalOffset** ().
        """
        ...

    def verticalScrollbarValueChanged(self, value: int) -> None:
        ...

    def viewportEvent(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#viewportEvent

        **[override virtual protected] bool QTreeView::viewportEvent(QEvent *
        event )**

        Reimplements: **QAbstractItemView::viewportEvent** (QEvent *event).
        """
        ...

    def viewportSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtreeview.html#viewportSizeHint

        **[override virtual protected] QSize QTreeView::viewportSizeHint()
        const**

        Reimplements: **QAbstractItemView::viewportSizeHint() const** .
        """
        ...

    def visualRect(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qtreeview.html#visualRect

        **[override virtual] QRect QTreeView::visualRect(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemView::visualRect(const QModelIndex &index)
        const** .

        Returns the rectangle on the viewport occupied by the item at **index**.
        If the index is not visible or explicitly hidden, the returned rectangle
        is invalid.
        """
        ...

    def visualRegionForSelection(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qtreeview.html#visualRegionForSelection

        **[override virtual protected] QRegion
        QTreeView::visualRegionForSelection(const QItemSelection & selection )
        const**

        Reimplements: **QAbstractItemView::visualRegionForSelection(const
        QItemSelection &selection) const** .

        Returns the rectangle from the viewport of the items in the given
        **selection**.

        Since 4.7, the returned region only contains rectangles intersecting (or
        included in) the viewport.
        """
        ...

    def wordWrap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreeview.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the item text word-wrapping policy

        If this property is `true` then the item text is wrapped where necessary
        at word-breaks; otherwise it is not wrapped at all. This property is
        `false` by default.

        Note that even if wrapping is enabled, the cell will not be expanded to
        fit all text. Ellipsis will be inserted according to the current
        **textElideMode** .

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **Member Function Documentation**
        """
        ...

    @property
    def collapsed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtreeview.html#collapsed

        **[signal] void QTreeView::collapsed(const QModelIndex & index )**

        This signal is emitted when the item specified by **index** is
        collapsed.
        """
        ...

    @property
    def expanded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtreeview.html#expanded

        **[signal] void QTreeView::expanded(const QModelIndex & index )**

        This signal is emitted when the item specified by **index** is expanded.

        **See also** **setExpanded** ().
        """
        ...
