"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QToolButton(PySide6.QtWidgets.QAbstractButton):
    """
    https://doc.qt.io/qt-6/qtoolbutton.html

    **Detailed Description**

    A tool button is a special button that provides quick-access to specific
    commands or options. As opposed to a normal command button, a tool button
    usually doesn't show a text label, but shows an icon instead.

    Tool buttons are normally created when new **QAction**  instances are
    created with **QToolBar::addAction** () or existing actions are added to a
    toolbar with **QToolBar::addAction** (). It is also possible to construct
    tool buttons in the same way as any other widget, and arrange them alongside
    other widgets in layouts.

    One classic use of a tool button is to select tools; for example, the "pen"
    tool in a drawing program. This would be implemented by using a QToolButton
    as a toggle button (see **setCheckable** ()).

    QToolButton supports auto-raising. In auto-raise mode, the button draws a 3D
    frame only when the mouse points at it. The feature is automatically turned
    on when a button is used inside a **QToolBar** . Change it with
    **setAutoRaise** ().

    A tool button's icon is set as **QIcon** . This makes it possible to specify
    different pixmaps for the disabled and active state. The disabled pixmap is
    used when the button's functionality is not available. The active pixmap is
    displayed when the button is auto-raised because the mouse pointer is
    hovering over it.

    The button's look and dimension is adjustable with **setToolButtonStyle** ()
    and **setIconSize** (). When used inside a **QToolBar**  in a
    **QMainWindow** , the button automatically adjusts to **QMainWindow** 's
    settings (see **QMainWindow::setToolButtonStyle** () and
    **QMainWindow::setIconSize** ()). Instead of an icon, a tool button can also
    display an arrow symbol, specified with **arrowType** .

    A tool button can offer additional choices in a popup menu. The popup menu
    can be set using **setMenu** (). Use **setPopupMode** () to configure the
    different modes available for tool buttons with a menu set. The default mode
    is DelayedPopupMode which is sometimes used with the "Back" button in a web
    browser. After pressing and holding the button down for a while, a menu pops
    up showing a list of possible pages to jump to. The timeout is style
    dependent, see **QStyle::SH_ToolButton_PopupDelay** .

    ![Qt Assistant's toolbar with tool buttons](images/assistant-toolbar.png)
    Qt Assistant's toolbar contains tool buttons that are associated with
    actions used in other parts of the main window.

    **See also** **QPushButton** , **QToolBar** , **QMainWindow** , **QAction**
    , and **GUI Design Handbook: Push Button** .
    """

    DelayedPopup: QToolButton.ToolButtonPopupMode = ...
    MenuButtonPopup: QToolButton.ToolButtonPopupMode = ...
    InstantPopup: QToolButton.ToolButtonPopupMode = ...

    class ToolButtonPopupMode(Enum):
        DelayedPopup: QToolButton.ToolButtonPopupMode = ...
        MenuButtonPopup: QToolButton.ToolButtonPopupMode = ...
        InstantPopup: QToolButton.ToolButtonPopupMode = ...

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#QToolButton

        **QToolButton::QToolButton(QWidget * parent = nullptr)**

        Constructs an empty tool button with parent **parent**.
        """
        ...

    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#actionEvent

        **[override virtual protected] void
        QToolButton::actionEvent(QActionEvent * event )**

        Reimplements: **QWidget::actionEvent** (QActionEvent *event).
        """
        ...

    def arrowType(self) -> PySide6.QtCore.Qt.ArrowType:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#arrowType-prop

        **arrowType : Qt::ArrowType**

        This property holds whether the button displays an arrow instead of a
        normal icon

        This displays an arrow as the icon for the **QToolButton** .

        By default, this property is set to **Qt::NoArrow** .

        **Access functions:**

        Qt::ArrowType **arrowType** () const
        void **setArrowType**
        (Qt::ArrowType **type** )
        """
        ...

    def autoRaise(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#autoRaise-prop

        **autoRaise : bool**

        This property holds whether auto-raising is enabled or not.

        The default is disabled (i.e. false).

        This property is currently ignored on macOS when using QMacStyle.

        **Access functions:**

        bool **autoRaise** () const
        void **setAutoRaise** (bool **enable** )
        """
        ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#changeEvent

        **[override virtual protected] void QToolButton::changeEvent(QEvent * e
        )**

        Reimplements: **QAbstractButton::changeEvent** (QEvent *e).
        """
        ...

    def checkStateSet(self) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#checkStateSet

        **[override virtual protected] void QToolButton::checkStateSet()**

        Reimplements: **QAbstractButton::checkStateSet** ().
        """
        ...

    def defaultAction(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#defaultAction

        **QAction *QToolButton::defaultAction() const**

        Returns the default action.

        **See also** **setDefaultAction** ().
        """
        ...

    def enterEvent(self, arg__1: PySide6.QtGui.QEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#enterEvent

        **[override virtual protected] void QToolButton::enterEvent(QEnterEvent
        * e )**

        Reimplements: **QWidget::enterEvent** (QEnterEvent *event).
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#event

        **[override virtual protected] bool QToolButton::event(QEvent * event
        )**

        Reimplements: **QAbstractButton::event** (QEvent *e).
        """
        ...

    def hitButton(self, pos: PySide6.QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#hitButton

        **[override virtual protected] bool QToolButton::hitButton(const QPoint
        & pos ) const**

        Reimplements: **QAbstractButton::hitButton(const QPoint &pos) const** .
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionToolButton) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#initStyleOption

        **[virtual protected] void
        QToolButton::initStyleOption(QStyleOptionToolButton * option ) const**

        Initialize **option** with the values from this **QToolButton** . This
        method is useful for subclasses when they need a
        **QStyleOptionToolButton** , but don't want to fill in all the
        information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#leaveEvent

        **[override virtual protected] void QToolButton::leaveEvent(QEvent * e
        )**

        Reimplements: **QWidget::leaveEvent** (QEvent *event).
        """
        ...

    def menu(self) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#menu

        **QMenu *QToolButton::menu() const**

        Returns the associated menu, or `nullptr` if no menu has been defined.

        **See also** **setMenu** ().
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#minimumSizeHint

        **[override virtual] QSize QToolButton::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#mousePressEvent

        **[override virtual protected] void
        QToolButton::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QAbstractButton::mousePressEvent** (QMouseEvent *e).
        """
        ...

    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#mouseReleaseEvent

        **[override virtual protected] void
        QToolButton::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QAbstractButton::mouseReleaseEvent** (QMouseEvent *e).
        """
        ...

    def nextCheckState(self) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#nextCheckState

        **[override virtual protected] void QToolButton::nextCheckState()**

        Reimplements: **QAbstractButton::nextCheckState** ().
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#paintEvent

        **[override virtual protected] void QToolButton::paintEvent(QPaintEvent
        * event )**

        Reimplements: **QAbstractButton::paintEvent** (QPaintEvent *e).

        Paints the button in response to the paint **event**.
        """
        ...

    def popupMode(self) -> PySide6.QtWidgets.QToolButton.ToolButtonPopupMode:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#popupMode-prop

        **popupMode : ToolButtonPopupMode**

        describes the way that popup menus are used with tool buttons

        By default, this property is set to **DelayedPopup** .

        **Access functions:**

        QToolButton::ToolButtonPopupMode **popupMode** () const
        void
        **setPopupMode** (QToolButton::ToolButtonPopupMode **mode** )
        """
        ...

    def setArrowType(self, type: PySide6.QtCore.Qt.ArrowType) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#arrowType-prop

        **arrowType : Qt::ArrowType**

        This property holds whether the button displays an arrow instead of a
        normal icon

        This displays an arrow as the icon for the **QToolButton** .

        By default, this property is set to **Qt::NoArrow** .

        **Access functions:**

        Qt::ArrowType **arrowType** () const
        void **setArrowType**
        (Qt::ArrowType **type** )
        """
        ...

    def setAutoRaise(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#autoRaise-prop

        **autoRaise : bool**

        This property holds whether auto-raising is enabled or not.

        The default is disabled (i.e. false).

        This property is currently ignored on macOS when using QMacStyle.

        **Access functions:**

        bool **autoRaise** () const
        void **setAutoRaise** (bool **enable** )
        """
        ...

    def setDefaultAction(self, arg__1: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#setDefaultAction

        **[slot] void QToolButton::setDefaultAction(QAction * action )**

        Sets the default action to **action**.

        If a tool button has a default action, the action defines the following
        properties of the button:

        * **checkable**
          * **checked**
          * **enabled**
          * **font**
          *
        **icon**
          * **popupMode**  (assuming the action has a menu)
          *
        **statusTip**
          * **text**
          * **toolTip**
          * **whatsThis**

        Other properties, such as **autoRepeat** , are not affected by actions.

        **See also** **defaultAction** ().
        """
        ...

    def setMenu(self, menu: PySide6.QtWidgets.QMenu) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#setMenu

        **void QToolButton::setMenu(QMenu * menu )**

        Associates the given **menu** with this tool button.

        The menu will be shown according to the button's **popupMode** .

        Ownership of the menu is not transferred to the tool button.

        **See also** **menu** ().
        """
        ...

    def setPopupMode(
        self, mode: PySide6.QtWidgets.QToolButton.ToolButtonPopupMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#popupMode-prop

        **popupMode : ToolButtonPopupMode**

        describes the way that popup menus are used with tool buttons

        By default, this property is set to **DelayedPopup** .

        **Access functions:**

        QToolButton::ToolButtonPopupMode **popupMode** () const
        void
        **setPopupMode** (QToolButton::ToolButtonPopupMode **mode** )
        """
        ...

    def setToolButtonStyle(self, style: PySide6.QtCore.Qt.ToolButtonStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        This property holds whether the tool button displays an icon only, text
        only, or text beside/below the icon.

        The default is **Qt::ToolButtonIconOnly** .

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        **QToolButton**  automatically connects this slot to the relevant signal
        in the **QMainWindow**  in which is resides.

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **style** )

        **Member Function Documentation**
        """
        ...

    def showMenu(self) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#showMenu

        **[slot] void QToolButton::showMenu()**

        Shows (pops up) the associated popup menu. If there is no such menu,
        this function does nothing. This function does not return until the
        popup menu has been closed by the user.
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#sizeHint

        **[override virtual] QSize QToolButton::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#timerEvent

        **[override virtual protected] void QToolButton::timerEvent(QTimerEvent
        * e )**

        Reimplements: **QAbstractButton::timerEvent** (QTimerEvent *e).
        """
        ...

    def toolButtonStyle(self) -> PySide6.QtCore.Qt.ToolButtonStyle:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        This property holds whether the tool button displays an icon only, text
        only, or text beside/below the icon.

        The default is **Qt::ToolButtonIconOnly** .

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        **QToolButton**  automatically connects this slot to the relevant signal
        in the **QMainWindow**  in which is resides.

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **style** )

        **Member Function Documentation**
        """
        ...

    @property
    def triggered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbutton.html#triggered

        **[signal] void QToolButton::triggered(QAction * action )**

        This signal is emitted when the given **action** is triggered.

        The action may also be associated with other parts of the user
        interface, such as menu items and keyboard shortcuts. Sharing actions in
        this way helps make the user interface more consistent and is often less
        work to implement.
        """
        ...
